/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.widget;

import com.baozi.treerecyclerview.adpater.TreeRecyclerAdapter;
import com.baozi.treerecyclerview.adpater.TreeRecyclerType;
import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.item.TreeItem;
import com.baozi.treerecyclerview.item.TreeSortItem;
import com.baozi.treerecyclerview.manager.ItemManager;
import java.util.HashMap;
import java.util.List;

public class TreeSortAdapter
extends TreeRecyclerAdapter {
    private final HashMap<Object, TreeItem> sortMap = new HashMap();
    private TreeSortManageWrapper manageWrapper;

    public TreeSortAdapter() {
    }

    public TreeSortAdapter(TreeRecyclerType treeRecyclerType) {
        super(treeRecyclerType);
    }

    @Override
    public void setDatas(List<TreeItem> datas) {
        super.setDatas(datas);
        this.getItemManager().updateSorts(this.getDatas());
    }

    public TreeItem getSortItem(Object o) {
        if (o == null) {
            return null;
        }
        return this.sortMap.get(o);
    }

    public int getSortIndex(Object o) {
        TreeItem sortItem = this.getSortItem(o);
        if (sortItem == null) {
            return -1;
        }
        return this.getItemManager().getItemPosition(sortItem);
    }

    public TreeSortManageWrapper getItemManager() {
        if (this.manageWrapper == null) {
            this.manageWrapper = new TreeSortManageWrapper(this, super.getItemManager());
        }
        return this.manageWrapper;
    }

    public class TreeSortManageWrapper
    extends ItemManager<TreeItem> {
        ItemManager<TreeItem> manager;

        public TreeSortManageWrapper(BaseRecyclerAdapter adapter, ItemManager<TreeItem> manager) {
            super(adapter);
            this.manager = manager;
        }

        @Override
        public void setOpenAnim(boolean openAnim) {
            this.manager.setOpenAnim(openAnim);
        }

        @Override
        public boolean isOpenAnim() {
            return this.manager.isOpenAnim();
        }

        @Override
        public void addItem(TreeItem treeItem) {
            this.manager.addItem(treeItem);
            this.updateSort(this.manager.getItemPosition(treeItem), treeItem);
        }

        @Override
        public void addItem(int i, TreeItem treeItem) {
            this.manager.addItem(i, treeItem);
            this.updateSort(i, treeItem);
        }

        @Override
        public void addItems(List<TreeItem> list) {
            this.manager.addItems(list);
            this.updateSorts(list);
        }

        @Override
        public void addItems(int i, List<TreeItem> list) {
            this.manager.addItems(i, list);
            this.updateSorts(list);
        }

        @Override
        public void setAdapter(BaseRecyclerAdapter<TreeItem> adapter) {
            this.manager.setAdapter(adapter);
        }

        @Override
        public BaseRecyclerAdapter getAdapter() {
            return this.manager.getAdapter();
        }

        @Override
        public void removeItem(TreeItem treeItem) {
            this.manager.removeItem(treeItem);
            this.updateSort(this.getItemPosition(treeItem), treeItem);
        }

        @Override
        public void removeItem(int i) {
            TreeItem item = this.manager.getItem(i);
            if (item instanceof TreeSortItem) {
                TreeSortAdapter.this.sortMap.remove(((TreeSortItem)item).getSortKey());
            }
            this.manager.removeItem(i);
        }

        @Override
        public void removeItems(List<TreeItem> list) {
            this.manager.removeItems(list);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                TreeItem item = list.get(i);
                if (!(item instanceof TreeSortItem)) continue;
                TreeSortAdapter.this.sortMap.remove(((TreeSortItem)item).getSortKey());
            }
        }

        @Override
        public void replaceItem(int i, TreeItem treeItem) {
            this.manager.replaceItem(i, treeItem);
            this.updateSort(i, treeItem);
        }

        @Override
        public void replaceAllItem(List<TreeItem> list) {
            this.manager.replaceAllItem(list);
            this.updateSorts(list);
        }

        @Override
        public TreeItem getItem(int i) {
            return this.manager.getItem(i);
        }

        @Override
        public int getItemPosition(TreeItem treeItem) {
            return this.manager.getItemPosition(treeItem);
        }

        @Override
        public void clean() {
            this.manager.clean();
        }

        public void updateSorts(List<TreeItem> treeItems) {
            int size = treeItems.size();
            for (int i = 0; i < size; ++i) {
                TreeItem treeItem = treeItems.get(i);
                if (!(treeItem instanceof TreeSortItem)) continue;
                TreeSortAdapter.this.sortMap.put(((TreeSortItem)treeItem).getSortKey(), treeItem);
            }
        }

        public void updateSort(TreeItem treeItem) {
            if (treeItem instanceof TreeSortItem) {
                TreeSortAdapter.this.sortMap.put(((TreeSortItem)treeItem).getSortKey(), treeItem);
            }
        }

        public void updateSort(int position, TreeItem treeItem) {
            if (treeItem instanceof TreeSortItem) {
                TreeSortAdapter.this.sortMap.put(((TreeSortItem)treeItem).getSortKey(), treeItem);
            }
        }

        @Override
        public int dataToItemPosition(int index) {
            return this.manager.dataToItemPosition(index);
        }

        @Override
        public int itemToDataPosition(int position) {
            return this.manager.itemToDataPosition(position);
        }

        @Override
        public void notifyDataChanged() {
            this.manager.notifyDataChanged();
        }

        @Override
        public void addCheckItemInterfaces(ItemManager.CheckItemInterface itemInterface) {
            this.manager.addCheckItemInterfaces(itemInterface);
        }

        @Override
        public void removeCheckItemInterfaces(ItemManager.CheckItemInterface itemInterface) {
            this.manager.removeCheckItemInterfaces(itemInterface);
        }
    }
}

