/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.baozi.treerecyclerview.R;
import com.baozi.treerecyclerview.widget.DragSelectRecyclerAdapter;

public class DragSelectRecyclerView
extends RecyclerView {
    private static final boolean LOGGING = false;
    private static final int AUTO_SCROLL_DELAY = 25;
    private int mLastDraggedIndex = -1;
    private DragSelectRecyclerAdapter<?> mAdapter;
    private int mInitialSelection;
    private boolean mDragSelectActive;
    private int mMinReached;
    private int mMaxReached;
    private int mHotspotHeight;
    private int mHotspotOffsetTop;
    private int mHotspotOffsetBottom;
    private int mHotspotTopBoundStart;
    private int mHotspotTopBoundEnd;
    private int mHotspotBottomBoundStart;
    private int mHotspotBottomBoundEnd;
    private int mAutoScrollVelocity;
    private FingerListener mFingerListener;
    private boolean mInTopHotspot;
    private boolean mInBottomHotspot;
    private Handler mAutoScrollHandler;
    private Runnable mAutoScrollRunnable = new Runnable(){

        @Override
        public void run() {
            if (DragSelectRecyclerView.this.mAutoScrollHandler == null) {
                return;
            }
            if (DragSelectRecyclerView.this.mInTopHotspot) {
                DragSelectRecyclerView.this.scrollBy(0, -DragSelectRecyclerView.this.mAutoScrollVelocity);
                DragSelectRecyclerView.this.mAutoScrollHandler.postDelayed((Runnable)this, 25L);
            } else if (DragSelectRecyclerView.this.mInBottomHotspot) {
                DragSelectRecyclerView.this.scrollBy(0, DragSelectRecyclerView.this.mAutoScrollVelocity);
                DragSelectRecyclerView.this.mAutoScrollHandler.postDelayed((Runnable)this, 25L);
            }
        }
    };
    private RectF mTopBoundRect;
    private RectF mBottomBoundRect;
    private Paint mDebugPaint;
    private boolean mDebugEnabled = false;

    public DragSelectRecyclerView(Context context) {
        super(context);
        this.init(context, null);
    }

    public DragSelectRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DragSelectRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private static void LOG(String message, Object ... args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.mAutoScrollHandler = new Handler();
        int defaultHotspotHeight = context.getResources().getDimensionPixelSize(R.dimen.dsrv_defaultHotspotHeight);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DragSelectRecyclerView, 0, 0);
            try {
                boolean autoScrollEnabled = a.getBoolean(R.styleable.DragSelectRecyclerView_dsrv_autoScrollEnabled, true);
                if (!autoScrollEnabled) {
                    this.mHotspotHeight = -1;
                    this.mHotspotOffsetTop = -1;
                    this.mHotspotOffsetBottom = -1;
                    DragSelectRecyclerView.LOG("Auto-scroll disabled", new Object[0]);
                }
                this.mHotspotHeight = a.getDimensionPixelSize(R.styleable.DragSelectRecyclerView_dsrv_autoScrollHotspotHeight, defaultHotspotHeight);
                this.mHotspotOffsetTop = a.getDimensionPixelSize(R.styleable.DragSelectRecyclerView_dsrv_autoScrollHotspot_offsetTop, 0);
                this.mHotspotOffsetBottom = a.getDimensionPixelSize(R.styleable.DragSelectRecyclerView_dsrv_autoScrollHotspot_offsetBottom, 0);
                DragSelectRecyclerView.LOG("Hotspot height = %d", this.mHotspotHeight);
            }
            finally {
                a.recycle();
            }
        } else {
            this.mHotspotHeight = defaultHotspotHeight;
            DragSelectRecyclerView.LOG("Hotspot height = %d", this.mHotspotHeight);
        }
    }

    public void setFingerListener(@Nullable FingerListener listener) {
        this.mFingerListener = listener;
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        super.onMeasure(widthSpec, heightSpec);
        if (this.mHotspotHeight > -1) {
            this.mHotspotTopBoundStart = this.mHotspotOffsetTop;
            this.mHotspotTopBoundEnd = this.mHotspotOffsetTop + this.mHotspotHeight;
            this.mHotspotBottomBoundStart = this.getMeasuredHeight() - this.mHotspotHeight - this.mHotspotOffsetBottom;
            this.mHotspotBottomBoundEnd = this.getMeasuredHeight() - this.mHotspotOffsetBottom;
            DragSelectRecyclerView.LOG("RecyclerView height = %d", this.getMeasuredHeight());
            DragSelectRecyclerView.LOG("Hotspot top bound = %d to %d", this.mHotspotTopBoundStart, this.mHotspotTopBoundStart);
            DragSelectRecyclerView.LOG("Hotspot bottom bound = %d to %d", this.mHotspotBottomBoundStart, this.mHotspotBottomBoundEnd);
        }
    }

    public boolean setDragSelectActive(boolean active, int initialSelection) {
        if (active && this.mDragSelectActive) {
            DragSelectRecyclerView.LOG("Drag selection is already active.", new Object[0]);
            return false;
        }
        this.mLastDraggedIndex = -1;
        this.mMinReached = -1;
        this.mMaxReached = -1;
        if (!this.mAdapter.isIndexSelectable(initialSelection)) {
            this.mDragSelectActive = false;
            this.mInitialSelection = -1;
            this.mLastDraggedIndex = -1;
            DragSelectRecyclerView.LOG("Index %d is not selectable.", initialSelection);
            return false;
        }
        this.mAdapter.setSelected(initialSelection, true);
        this.mDragSelectActive = active;
        this.mInitialSelection = initialSelection;
        this.mLastDraggedIndex = initialSelection;
        if (this.mFingerListener != null) {
            this.mFingerListener.onDragSelectFingerAction(true);
        }
        DragSelectRecyclerView.LOG("Drag selection initialized, starting at index %d.", initialSelection);
        return true;
    }

    @Deprecated
    public void setAdapter(RecyclerView.Adapter adapter) {
        if (!(adapter instanceof DragSelectRecyclerAdapter)) {
            throw new IllegalArgumentException("Adapter must be a DragSelectRecyclerAdapter.");
        }
        this.setAdapter((DragSelectRecyclerAdapter)adapter);
    }

    public void setAdapter(DragSelectRecyclerAdapter<?> adapter) {
        super.setAdapter(adapter);
        this.mAdapter = adapter;
    }

    private int getItemPosition(MotionEvent e) {
        View v = this.findChildViewUnder(e.getX(), e.getY());
        if (v == null) {
            return -2;
        }
        if (v.getTag() == null || !(v.getTag() instanceof RecyclerView.ViewHolder)) {
            throw new IllegalStateException("Make sure your adapter makes a call to super.onBindViewHolder(), and doesn't override itemView tags.");
        }
        RecyclerView.ViewHolder holder = (RecyclerView.ViewHolder)v.getTag();
        return holder.getAdapterPosition();
    }

    public final void enableDebug() {
        this.mDebugEnabled = true;
        this.invalidate();
    }

    public void onDraw(Canvas c) {
        super.onDraw(c);
        if (this.mDebugEnabled) {
            if (this.mDebugPaint == null) {
                this.mDebugPaint = new Paint();
                this.mDebugPaint.setColor(-16777216);
                this.mDebugPaint.setAntiAlias(true);
                this.mDebugPaint.setStyle(Paint.Style.FILL);
                this.mTopBoundRect = new RectF(0.0f, (float)this.mHotspotTopBoundStart, (float)this.getMeasuredWidth(), (float)this.mHotspotTopBoundEnd);
                this.mBottomBoundRect = new RectF(0.0f, (float)this.mHotspotBottomBoundStart, (float)this.getMeasuredWidth(), (float)this.mHotspotBottomBoundEnd);
            }
            c.drawRect(this.mTopBoundRect, this.mDebugPaint);
            c.drawRect(this.mBottomBoundRect, this.mDebugPaint);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent e) {
        if (this.mAdapter.getItemCount() == 0) {
            return super.dispatchTouchEvent(e);
        }
        if (this.mDragSelectActive) {
            int itemPosition = this.getItemPosition(e);
            if (e.getAction() == 1) {
                this.mDragSelectActive = false;
                this.mInTopHotspot = false;
                this.mInBottomHotspot = false;
                this.mAutoScrollHandler.removeCallbacks(this.mAutoScrollRunnable);
                if (this.mFingerListener != null) {
                    this.mFingerListener.onDragSelectFingerAction(false);
                }
                return true;
            }
            if (e.getAction() == 2) {
                if (this.mHotspotHeight > -1) {
                    if (e.getY() >= (float)this.mHotspotTopBoundStart && e.getY() <= (float)this.mHotspotTopBoundEnd) {
                        this.mInBottomHotspot = false;
                        if (!this.mInTopHotspot) {
                            this.mInTopHotspot = true;
                            this.mAutoScrollHandler.removeCallbacks(this.mAutoScrollRunnable);
                            this.mAutoScrollHandler.postDelayed(this.mAutoScrollRunnable, 25L);
                        }
                        float simulatedFactor = this.mHotspotTopBoundEnd - this.mHotspotTopBoundStart;
                        float simulatedY = e.getY() - (float)this.mHotspotTopBoundStart;
                        this.mAutoScrollVelocity = (int)(simulatedFactor - simulatedY) / 2;
                    } else if (e.getY() >= (float)this.mHotspotBottomBoundStart && e.getY() <= (float)this.mHotspotBottomBoundEnd) {
                        this.mInTopHotspot = false;
                        if (!this.mInBottomHotspot) {
                            this.mInBottomHotspot = true;
                            this.mAutoScrollHandler.removeCallbacks(this.mAutoScrollRunnable);
                            this.mAutoScrollHandler.postDelayed(this.mAutoScrollRunnable, 25L);
                        }
                        float simulatedY = e.getY() + (float)this.mHotspotBottomBoundEnd;
                        float simulatedFactor = this.mHotspotBottomBoundStart + this.mHotspotBottomBoundEnd;
                        this.mAutoScrollVelocity = (int)(simulatedY - simulatedFactor) / 2;
                    } else if (this.mInTopHotspot || this.mInBottomHotspot) {
                        this.mAutoScrollHandler.removeCallbacks(this.mAutoScrollRunnable);
                        this.mInTopHotspot = false;
                        this.mInBottomHotspot = false;
                    }
                }
                if (itemPosition != -2 && this.mLastDraggedIndex != itemPosition) {
                    this.mLastDraggedIndex = itemPosition;
                    if (this.mMinReached == -1) {
                        this.mMinReached = this.mLastDraggedIndex;
                    }
                    if (this.mMaxReached == -1) {
                        this.mMaxReached = this.mLastDraggedIndex;
                    }
                    if (this.mLastDraggedIndex > this.mMaxReached) {
                        this.mMaxReached = this.mLastDraggedIndex;
                    }
                    if (this.mLastDraggedIndex < this.mMinReached) {
                        this.mMinReached = this.mLastDraggedIndex;
                    }
                    if (this.mAdapter != null) {
                        this.mAdapter.selectRange(this.mInitialSelection, this.mLastDraggedIndex, this.mMinReached, this.mMaxReached);
                    }
                    if (this.mInitialSelection == this.mLastDraggedIndex) {
                        this.mMinReached = this.mLastDraggedIndex;
                        this.mMaxReached = this.mLastDraggedIndex;
                    }
                }
                return true;
            }
        }
        return super.dispatchTouchEvent(e);
    }

    public static interface FingerListener {
        public void onDragSelectFingerAction(boolean var1);
    }
}

