/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.adpater.wrapper;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.baozi.treerecyclerview.adpater.wrapper.BaseWrapper;
import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.base.ViewHolder;
import com.baozi.treerecyclerview.item.SimpleTreeItem;
import com.baozi.treerecyclerview.item.TreeItem;

public class TreeLoadWrapper
extends BaseWrapper<TreeItem> {
    private static final int ITEM_LOAD_MORE = -5000;
    private TreeItem mEmptyView;
    private TreeItem mLoadingView;
    private LoadMoreItem mLoadMoreItem;
    private LoadMoreListener loadMoreListener;
    private boolean initLoadMore;
    private Type mType;

    public TreeLoadWrapper(BaseRecyclerAdapter<TreeItem> adapter) {
        super(adapter);
    }

    private boolean isEmpty() {
        return this.getDatas().size() == 0;
    }

    private boolean isLoading() {
        return this.mType == Type.LOADING;
    }

    private boolean isLoadMoreViewPos(int position) {
        return position >= this.mAdapter.getItemCount();
    }

    public void setType(Type type) {
        switch (type) {
            case EMPTY: {
                break;
            }
            case SUCCESS: 
            case REFRESH_OVER: {
                break;
            }
            case LOADING: {
                if (this.mLoadingView == null) {
                    return;
                }
                this.notifyDataSetChanged();
                break;
            }
            case LOAD_MORE: 
            case LOAD_ERROR: 
            case LOAD_OVER: {
                if (this.mLoadMoreItem == null) break;
                this.mLoadMoreItem.setType(type);
            }
        }
        this.mType = type;
    }

    @Override
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.mEmptyView == null) {
            this.mEmptyView = new SimpleTreeItem();
        }
        if (this.mLoadingView == null) {
            this.mLoadingView = new SimpleTreeItem();
        }
        this.setType(Type.LOADING);
        if (this.mLoadMoreItem != null) {
            recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    int lastVisibleIndex;
                    if (TreeLoadWrapper.this.loadMoreListener == null) {
                        return;
                    }
                    LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                    int itemCount = TreeLoadWrapper.this.getDatas().size();
                    int lastPosition = TreeLoadWrapper.this.checkPosition(layoutManager.findLastVisibleItemPosition());
                    int n = lastVisibleIndex = TreeLoadWrapper.this.mLoadMoreItem.getLastVisibleIndex() == 0 ? 1 : TreeLoadWrapper.this.mLoadMoreItem.getLastVisibleIndex();
                    if (lastPosition >= itemCount - lastVisibleIndex && itemCount >= TreeLoadWrapper.this.mLoadMoreItem.getMinPageSize() - lastVisibleIndex) {
                        TreeLoadWrapper.this.loadMoreListener.loadMore(TreeLoadWrapper.this.mType);
                    }
                }
            });
        }
    }

    @Override
    public int getItemSpanSize(int position, int maxSpan) {
        if ((this.isEmpty() || this.isLoading()) && position == 0) {
            return maxSpan;
        }
        if (this.isLoadMoreViewPos(position)) {
            return maxSpan;
        }
        return super.getItemSpanSize(position, maxSpan);
    }

    public LoadMoreListener getLoadMoreListener() {
        return this.loadMoreListener;
    }

    public void setLoadMoreListener(LoadMoreListener loadMoreListener) {
        this.loadMoreListener = loadMoreListener;
    }

    @Override
    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.isLoading() || this.isEmpty()) {
            ViewHolder viewHolder = ViewHolder.createViewHolder(parent, viewType);
            this.onBindViewHolderClick(viewHolder, viewHolder.itemView);
            return viewHolder;
        }
        if (viewType == -5000) {
            return ViewHolder.createViewHolder(this.mLoadMoreItem.getLoadMoreView());
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    @Override
    public int getItemViewType(int position) {
        if (this.isLoading()) {
            return this.mLoadingView.getLayoutId();
        }
        if (this.isEmpty()) {
            return this.mEmptyView.getLayoutId();
        }
        if (this.isLoadMoreViewPos(position)) {
            return -5000;
        }
        return this.mAdapter.getItemViewType(position);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        if (this.isLoading()) {
            this.mLoadingView.onBindViewHolder(holder);
            return;
        }
        if (this.isEmpty()) {
            this.mEmptyView.onBindViewHolder(holder);
            return;
        }
        if (this.isLoadMoreViewPos(position)) {
            return;
        }
        this.mAdapter.onBindViewHolder(holder, position);
    }

    @Override
    public void onBindViewHolderClick(final @NonNull ViewHolder holder, View view) {
        if (this.isLoading()) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TreeLoadWrapper.this.mLoadingView.onClick(holder);
                }
            });
            return;
        }
        if (this.isEmpty()) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TreeLoadWrapper.this.mEmptyView.onClick(holder);
                }
            });
            return;
        }
        super.onBindViewHolderClick(holder, view);
    }

    @Override
    public int getItemCount() {
        if (this.isEmpty() || this.isLoading()) {
            return 1;
        }
        if (!this.initLoadMore) {
            return this.mAdapter.getItemCount();
        }
        if (this.mType == Type.LOAD_ERROR || this.mType == Type.LOAD_OVER) {
            return this.mAdapter.getItemCount() + 1;
        }
        if (this.mAdapter.getItemCount() >= this.mLoadMoreItem.getMinPageSize()) {
            return this.mAdapter.getItemCount() + 1;
        }
        return this.mAdapter.getItemCount();
    }

    public void setEmptyView(TreeItem emptyView) {
        if (emptyView == null) {
            this.mEmptyView = new SimpleTreeItem(0);
            return;
        }
        this.mEmptyView = emptyView;
    }

    public void setEmptyView(int layoutId) {
        this.mEmptyView = new SimpleTreeItem(layoutId);
    }

    public void setLoadingView(TreeItem loadingView) {
        if (loadingView == null) {
            this.mLoadingView = new SimpleTreeItem(0);
            return;
        }
        this.mLoadingView = loadingView;
    }

    public void setLoadingView(int layoutId) {
        this.mLoadingView = new SimpleTreeItem(layoutId);
    }

    public void setLoadMore(LoadMoreItem loadMoreItem) {
        this.mLoadMoreItem = loadMoreItem;
        this.initLoadMore = this.mLoadMoreItem != null;
    }

    public static abstract class LoadMoreItem {
        private FrameLayout mLayout;
        private View loadMoreView;
        private View loadOverView;
        private View loadErrorView;

        public LoadMoreItem(Context context) {
            this.mLayout = new FrameLayout(context);
            this.mLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            this.loadErrorView = this.getLoadErrorView();
            if (this.loadErrorView != null) {
                this.mLayout.addView(this.loadErrorView);
            } else {
                this.loadErrorView = new View(context);
            }
            this.loadOverView = this.getLoadOverView();
            int loadOverLayout = this.getLoadOverLayout();
            if (this.loadOverView != null) {
                this.mLayout.addView(this.loadOverView);
            } else if (this.getLoadOverLayout() > 0) {
                this.loadOverView = LayoutInflater.from((Context)context).inflate(loadOverLayout, (ViewGroup)this.mLayout, false);
                this.mLayout.addView(this.loadOverView);
            } else {
                this.loadOverView = new View(context);
            }
            int loadMoreLayout = this.getLoadMoreLayout();
            if (loadMoreLayout > 0) {
                this.loadMoreView = LayoutInflater.from((Context)context).inflate(loadMoreLayout, (ViewGroup)this.mLayout, false);
                this.mLayout.addView(this.loadMoreView);
            } else {
                this.loadMoreView = new View(context);
            }
        }

        public View getLoadMoreView() {
            return this.mLayout;
        }

        public int getLastVisibleIndex() {
            return 0;
        }

        public View getLoadOverView() {
            return null;
        }

        public View getLoadErrorView() {
            return null;
        }

        void setType(Type type) {
            this.loadErrorView.setVisibility(8);
            this.loadMoreView.setVisibility(8);
            this.loadOverView.setVisibility(8);
            switch (type) {
                case LOAD_MORE: {
                    this.loadMoreView.setVisibility(0);
                    break;
                }
                case LOAD_OVER: {
                    this.loadOverView.setVisibility(0);
                    break;
                }
                case LOAD_ERROR: {
                    this.loadErrorView.setVisibility(0);
                }
            }
        }

        public abstract int getLoadMoreLayout();

        public abstract int getLoadOverLayout();

        public abstract int getMinPageSize();
    }

    public static interface LoadMoreListener {
        public void loadMore(Type var1);
    }

    public static enum Type {
        EMPTY,
        REFRESH_OVER,
        SUCCESS,
        LOADING,
        LOAD_MORE,
        LOAD_ERROR,
        LOAD_OVER;

    }
}

