/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.adpater.wrapper;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.baozi.treerecyclerview.adpater.wrapper.BaseWrapper;
import com.baozi.treerecyclerview.adpater.wrapper.SwipeWrapper;
import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.base.ViewHolder;
import com.baozi.treerecyclerview.item.SwipeItem;
import com.baozi.treerecyclerview.widget.swipe.SwipeItemMangerInterface;
import com.baozi.treerecyclerview.widget.swipe.SwipeLayout;
import com.baozi.treerecyclerview.widget.swipe.SwipeMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwipeWrapper<T>
extends BaseWrapper<T> {
    private static final int SWIPE_ITEM = 6666;
    private SwipeItemMangerInterface mSwipeManger;
    private SparseIntArray swipeItemSparseArray = new SparseIntArray();

    public SwipeWrapper(BaseRecyclerAdapter<T> adapter) {
        super(adapter);
    }

    public SwipeItemMangerInterface getSwipeManger() {
        if (this.mSwipeManger == null) {
            this.mSwipeManger = new SwipeItemMangerImpl();
        }
        return this.mSwipeManger;
    }

    public void setmSwipeManger(SwipeItemMangerInterface mSwipeManger) {
        this.mSwipeManger = mSwipeManger;
    }

    @Override
    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        int i = this.swipeItemSparseArray.get(viewType, -1);
        if (i != -1) {
            SwipeLayout swipeLayout = new SwipeLayout(parent.getContext());
            View inflate = LayoutInflater.from((Context)parent.getContext()).inflate(viewType, parent, false);
            swipeLayout.setLayoutParams(inflate.getLayoutParams());
            swipeLayout.addView(inflate);
            ViewHolder swipeViewHolder = ViewHolder.createViewHolder((View)swipeLayout);
            super.onBindViewHolderClick(swipeViewHolder, inflate);
            return swipeViewHolder;
        }
        return super.onCreateViewHolder(parent, viewType);
    }

    @Override
    public int getItemViewType(int position) {
        Object o;
        int itemViewType = super.getItemViewType(position);
        if (this.swipeItemSparseArray.get(itemViewType, -1) == -1 && (o = this.getData(this.checkPosition(position))) instanceof SwipeItem) {
            this.swipeItemSparseArray.put(itemViewType, 6666 + this.swipeItemSparseArray.size());
        }
        return super.getItemViewType(position);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        int checkPosition = this.checkPosition(position);
        Object data = this.getData(checkPosition);
        if (data instanceof SwipeItem) {
            this.checkSwipeLayout(holder, (SwipeItem)data, position);
        }
        super.onBindViewHolder(holder, position);
    }

    private void checkSwipeLayout(ViewHolder holder, SwipeItem data, int position) {
        SwipeLayout swipeLayout = (SwipeLayout)holder.itemView;
        Map<SwipeLayout.DragEdge, View> dragEdgeMap = swipeLayout.getDragEdgeMap();
        if (dragEdgeMap.get((Object)data.getDragEdge()) == null) {
            View inflate = LayoutInflater.from((Context)swipeLayout.getContext()).inflate(data.getSwipeLayoutId(), (ViewGroup)swipeLayout, false);
            swipeLayout.addDrag(data.getDragEdge(), inflate, inflate.getLayoutParams());
        }
        this.getSwipeManger().bind(swipeLayout, data.getSwipeLayoutId(), position);
        data.onBindSwipeView(holder, position, this.getSwipeManger());
    }

    @Override
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (!SwipeWrapper.this.getSwipeManger().isOpen(-1)) {
                    SwipeWrapper.this.getSwipeManger().closeAllItems();
                }
            }
        });
    }

    private class SwipeItemMangerImpl
    implements SwipeItemMangerInterface {
        private SwipeMode mode = SwipeMode.Single;
        public static final int INVALID_POSITION = -1;
        protected int mOpenPosition = -1;
        protected Set<Integer> mOpenPositions = new HashSet<Integer>();
        protected Set<SwipeLayout> mShownLayouts = new HashSet<SwipeLayout>();

        @Override
        public SwipeMode getMode() {
            return this.mode;
        }

        @Override
        public void setMode(SwipeMode mode) {
            this.mode = mode;
            this.mOpenPositions.clear();
            this.mShownLayouts.clear();
            this.mOpenPosition = -1;
        }

        @Override
        public void bind(SwipeLayout swipeLayout, int resId, int position) {
            if (swipeLayout.getTag(resId) == null) {
                OnLayoutListener onLayoutListener = new OnLayoutListener(position);
                SwipeMemory swipeMemory = new SwipeMemory(position);
                swipeLayout.addSwipeListener(swipeMemory);
                swipeLayout.addOnLayoutListener(onLayoutListener);
                swipeLayout.setTag(resId, new ValueBox(this, position, swipeMemory, onLayoutListener));
                this.mShownLayouts.add(swipeLayout);
            } else {
                ValueBox valueBox = (ValueBox)swipeLayout.getTag(resId);
                valueBox.swipeMemory.setPosition(position);
                valueBox.onLayoutListener.setPosition(position);
                valueBox.position = position;
            }
        }

        @Override
        public void openItem(int position) {
            if (this.mode == SwipeMode.Multiple) {
                if (!this.mOpenPositions.contains(position)) {
                    this.mOpenPositions.add(position);
                }
            } else {
                this.mOpenPosition = position;
            }
            SwipeWrapper.this.getItemManager().notifyDataChanged();
        }

        @Override
        public void closeItem(int position) {
            if (this.mode == SwipeMode.Multiple) {
                this.mOpenPositions.remove(position);
            } else if (this.mOpenPosition == position) {
                this.mOpenPosition = -1;
            }
            SwipeWrapper.this.getItemManager().notifyDataChanged();
        }

        @Override
        public void closeAllExcept(SwipeLayout layout) {
            for (SwipeLayout s : this.mShownLayouts) {
                if (s == layout) continue;
                s.close();
            }
        }

        @Override
        public void closeAllItems() {
            if (this.mode == SwipeMode.Multiple) {
                this.mOpenPositions.clear();
            } else {
                this.mOpenPosition = -1;
            }
            for (SwipeLayout s : this.mShownLayouts) {
                s.close();
            }
        }

        @Override
        public void removeShownLayouts(SwipeLayout layout) {
            this.mShownLayouts.remove((Object)layout);
        }

        @Override
        public List<Integer> getOpenItems() {
            if (this.mode == SwipeMode.Multiple) {
                return new ArrayList<Integer>(this.mOpenPositions);
            }
            return Collections.singletonList(this.mOpenPosition);
        }

        @Override
        public List<SwipeLayout> getOpenLayouts() {
            return new ArrayList<SwipeLayout>(this.mShownLayouts);
        }

        @Override
        public boolean isOpen(int position) {
            if (this.mode == SwipeMode.Multiple) {
                return this.mOpenPositions.contains(position);
            }
            return this.mOpenPosition == position;
        }

        private class SwipeMemory
        implements SwipeLayout.SwipeListener {
            private int position;

            SwipeMemory(int position) {
                this.position = position;
            }

            @Override
            public void onClose(SwipeLayout layout) {
                if (SwipeItemMangerImpl.this.mode == SwipeMode.Multiple) {
                    SwipeItemMangerImpl.this.mOpenPositions.remove(this.position);
                } else if (SwipeItemMangerImpl.this.mOpenPosition == this.position) {
                    SwipeItemMangerImpl.this.mOpenPosition = -1;
                }
            }

            @Override
            public void onUpdate(SwipeLayout layout, int leftOffset, int topOffset) {
            }

            @Override
            public void onHandRelease(SwipeLayout layout, float xvel, float yvel) {
            }

            @Override
            public void onStartOpen(SwipeLayout layout) {
                if (SwipeItemMangerImpl.this.mode == SwipeMode.Single) {
                    SwipeItemMangerImpl.this.closeAllExcept(layout);
                }
            }

            @Override
            public void onOpen(SwipeLayout layout) {
                if (SwipeItemMangerImpl.this.mode == SwipeMode.Multiple) {
                    SwipeItemMangerImpl.this.mOpenPositions.add(this.position);
                } else {
                    SwipeItemMangerImpl.this.closeAllExcept(layout);
                    SwipeItemMangerImpl.this.mOpenPosition = this.position;
                }
            }

            @Override
            public void onStartClose(SwipeLayout layout) {
            }

            public void setPosition(int position) {
                this.position = position;
            }
        }

        private class OnLayoutListener
        implements SwipeLayout.OnLayout {
            private int position;

            OnLayoutListener(int position) {
                this.position = position;
            }

            public void setPosition(int position) {
                this.position = position;
            }

            @Override
            public void onLayout(SwipeLayout v) {
            }
        }

        private static class ValueBox {
            com.baozi.treerecyclerview.adpater.wrapper.SwipeWrapper$SwipeItemMangerImpl.OnLayoutListener onLayoutListener;
            com.baozi.treerecyclerview.adpater.wrapper.SwipeWrapper$SwipeItemMangerImpl.SwipeMemory swipeMemory;
            int position;
            final /* synthetic */ SwipeItemMangerImpl this$1;

            ValueBox(int position, com.baozi.treerecyclerview.adpater.wrapper.SwipeWrapper$SwipeItemMangerImpl.SwipeMemory swipeMemory, com.baozi.treerecyclerview.adpater.wrapper.SwipeWrapper$SwipeItemMangerImpl.OnLayoutListener onLayoutListener) {
                this.this$1 = var1_1;
                this.swipeMemory = swipeMemory;
                this.onLayoutListener = onLayoutListener;
                this.position = position;
            }
        }
    }
}

