/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.adpater.wrapper;

import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.baozi.treerecyclerview.adpater.wrapper.BaseWrapper;
import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.base.ViewHolder;
import com.baozi.treerecyclerview.manager.ItemManager;

public class HeaderAndFootWrapper<T>
extends BaseWrapper<T> {
    private static final int HEAD_ITEM = 1000;
    private SparseArray<View> mHeaderViews = new SparseArray();
    private boolean headShow = true;
    private int mHeaderSize;

    public HeaderAndFootWrapper(BaseRecyclerAdapter<T> adapter) {
        super(adapter);
        this.getItemManager().addCheckItemInterfaces(new ItemManager.CheckItemInterface(){

            @Override
            public int itemToDataPosition(int position) {
                return position - HeaderAndFootWrapper.this.getHeadersCount();
            }

            @Override
            public int dataToItemPosition(int index) {
                return index + HeaderAndFootWrapper.this.getHeadersCount();
            }
        });
    }

    @Override
    public T getData(int position) {
        return this.mAdapter.getData(position);
    }

    @Override
    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.mHeaderViews.get(viewType) != null) {
            return ViewHolder.createViewHolder((View)this.mHeaderViews.get(viewType));
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void onBindViewHolderClick(@NonNull ViewHolder holder, View view) {
        int layoutPosition = holder.getLayoutPosition();
        if (this.isHeaderViewPos(layoutPosition)) {
            return;
        }
        super.onBindViewHolderClick(holder, view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        if (this.isHeaderViewPos(position)) {
            return;
        }
        super.onBindViewHolder(holder, position - this.getHeadersCount());
    }

    @Override
    public int getItemCount() {
        return this.getHeadersCount() + this.mAdapter.getItemCount();
    }

    @Override
    @Deprecated
    public int getItemSpanSize(int position) {
        if (this.isHeaderViewPos(position)) {
            return 0;
        }
        return super.getItemSpanSize(position);
    }

    @Override
    public int getItemSpanSize(int position, int maxSpan) {
        if (this.isHeaderViewPos(position)) {
            return maxSpan;
        }
        return super.getItemSpanSize(position, maxSpan);
    }

    @Override
    public int getItemViewType(int position) {
        if (this.isHeaderViewPos(position)) {
            return this.mHeaderViews.keyAt(position);
        }
        return super.getItemViewType(position - this.getHeadersCount());
    }

    public void addHeaderView(View view) {
        int size = this.mHeaderViews.size();
        this.mHeaderViews.put(1000 + size, (Object)view);
        ++this.mHeaderSize;
    }

    @Deprecated
    public void addFootView(View view) {
    }

    protected boolean isHeaderViewPos(int position) {
        return position < this.getHeadersCount();
    }

    @Deprecated
    protected boolean isFooterViewPos(int position) {
        return false;
    }

    public void setShowHeadView(boolean show) {
        this.headShow = show;
        int size = this.mHeaderViews.size();
        for (int i = 0; i < size; ++i) {
            View view = (View)this.mHeaderViews.valueAt(i);
            view.setVisibility(show ? 0 : 8);
        }
    }

    public int getHeadersCount() {
        if (!this.headShow) {
            return 0;
        }
        return this.mHeaderSize;
    }
}

