/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control.examples;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import net.freehaven.tor.control.EventHandler;

public class DebuggingEventHandler
implements EventHandler {
    private final PrintWriter out;

    public DebuggingEventHandler(PrintWriter p) {
        this.out = p;
    }

    @Override
    public void circuitStatus(String status, String circID, String path) {
        this.out.println("Circuit " + circID + " is now " + status + " (path=" + path + ")");
    }

    @Override
    public void streamStatus(String status, String streamID, String target) {
        this.out.println("Stream " + streamID + " is now " + status + " (target=" + target + ")");
    }

    @Override
    public void orConnStatus(String status, String orName) {
        this.out.println("OR connection to " + orName + " is now " + status);
    }

    @Override
    public void bandwidthUsed(long read, long written) {
        this.out.println("Bandwidth usage: " + read + " bytes read; " + written + " bytes written.");
    }

    @Override
    public void newDescriptors(List<String> orList) {
        this.out.println("New descriptors for routers:");
        Iterator<String> i = orList.iterator();
        while (i.hasNext()) {
            this.out.println("   " + i.next());
        }
    }

    @Override
    public void message(String type, String msg) {
        this.out.println("[" + type + "] " + msg.trim());
    }

    @Override
    public void hiddenServiceEvent(String type, String msg) {
        this.out.println("hiddenServiceEvent: HS_DESC " + msg.trim());
    }

    @Override
    public void hiddenServiceFailedEvent(String reason, String msg) {
        this.out.println("hiddenServiceEvent: HS_DESC " + msg.trim());
    }

    @Override
    public void hiddenServiceDescriptor(String descriptorId, String descriptor, String msg) {
        this.out.println("hiddenServiceEvent: HS_DESC_CONTENT " + msg.trim());
    }

    @Override
    public void unrecognized(String type, String msg) {
        this.out.println("unrecognized event [" + type + "] " + msg.trim());
    }

    @Override
    public void timeout() {
        this.out.println("The control connection to tor did not provide a response within one minute of waiting.");
    }
}

