/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize;

import android.app.Activity;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.DisplayMetricsInfo;
import me.jessyan.autosize.external.ExternalAdaptInfo;
import me.jessyan.autosize.internal.CustomAdapt;
import me.jessyan.autosize.utils.LogUtils;
import me.jessyan.autosize.utils.Preconditions;

public final class AutoSize {
    private static Map<String, DisplayMetricsInfo> mCache = new ConcurrentHashMap<String, DisplayMetricsInfo>();

    private AutoSize() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static void autoConvertDensityOfGlobal(Activity activity) {
        if (AutoSizeConfig.getInstance().isBaseOnWidth()) {
            AutoSize.autoConvertDensityBaseOnWidth(activity, AutoSizeConfig.getInstance().getDesignWidthInDp());
        } else {
            AutoSize.autoConvertDensityBaseOnHeight(activity, AutoSizeConfig.getInstance().getDesignHeightInDp());
        }
    }

    public static void autoConvertDensityOfCustomAdapt(Activity activity, CustomAdapt customAdapt) {
        Preconditions.checkNotNull(customAdapt, "customAdapt == null");
        float sizeInDp = customAdapt.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = customAdapt.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSize.autoConvertDensity(activity, sizeInDp, customAdapt.isBaseOnWidth());
    }

    public static void autoConvertDensityOfExternalAdaptInfo(Activity activity, ExternalAdaptInfo externalAdaptInfo) {
        Preconditions.checkNotNull(externalAdaptInfo, "externalAdaptInfo == null");
        float sizeInDp = externalAdaptInfo.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = externalAdaptInfo.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSize.autoConvertDensity(activity, sizeInDp, externalAdaptInfo.isBaseOnWidth());
    }

    public static void autoConvertDensityBaseOnWidth(Activity activity, float designWidthInDp) {
        AutoSize.autoConvertDensity(activity, designWidthInDp, true);
    }

    public static void autoConvertDensityBaseOnHeight(Activity activity, float designHeightInDp) {
        AutoSize.autoConvertDensity(activity, designHeightInDp, false);
    }

    public static void autoConvertDensity(Activity activity, float sizeInDp, boolean isBaseOnWidth) {
        Preconditions.checkNotNull(activity, "activity == null");
        int screenSize = isBaseOnWidth ? AutoSizeConfig.getInstance().getScreenWidth() : AutoSizeConfig.getInstance().getScreenHeight();
        String key = sizeInDp + "|" + isBaseOnWidth + "|" + AutoSizeConfig.getInstance().isUseDeviceSize() + "|" + AutoSizeConfig.getInstance().getInitScaledDensity() + "|" + screenSize;
        DisplayMetricsInfo displayMetricsInfo = mCache.get(key);
        float targetDensity = 0.0f;
        int targetDensityDpi = 0;
        float targetScaledDensity = 0.0f;
        float targetXdpi = 0.0f;
        if (displayMetricsInfo == null) {
            targetDensity = isBaseOnWidth ? (float)AutoSizeConfig.getInstance().getScreenWidth() * 1.0f / sizeInDp : (float)AutoSizeConfig.getInstance().getScreenHeight() * 1.0f / sizeInDp;
            targetScaledDensity = targetDensity * (AutoSizeConfig.getInstance().getInitScaledDensity() * 1.0f / AutoSizeConfig.getInstance().getInitDensity());
            targetDensityDpi = (int)(targetDensity * 160.0f);
            targetXdpi = isBaseOnWidth ? (float)AutoSizeConfig.getInstance().getScreenWidth() * 1.0f / sizeInDp : (float)AutoSizeConfig.getInstance().getScreenHeight() * 1.0f / sizeInDp;
            mCache.put(key, new DisplayMetricsInfo(targetDensity, targetDensityDpi, targetScaledDensity, targetXdpi));
        } else {
            targetDensity = displayMetricsInfo.getDensity();
            targetDensityDpi = displayMetricsInfo.getDensityDpi();
            targetScaledDensity = displayMetricsInfo.getScaledDensity();
            targetXdpi = displayMetricsInfo.getXdpi();
        }
        AutoSize.setDensity(activity, targetDensity, targetDensityDpi, targetScaledDensity, targetXdpi);
        LogUtils.d(String.format(Locale.ENGLISH, "The %s has been adapted! \n%s Info: isBaseOnWidth = %s, %s = %f, targetDensity = %f, targetScaledDensity = %f, targetDensityDpi = %d, targetXdpi = %f", activity.getClass().getName(), activity.getClass().getSimpleName(), isBaseOnWidth, isBaseOnWidth ? "designWidthInDp" : "designHeightInDp", Float.valueOf(sizeInDp), Float.valueOf(targetDensity), Float.valueOf(targetScaledDensity), targetDensityDpi, Float.valueOf(targetXdpi)));
    }

    public static void cancelAdapt(Activity activity) {
        AutoSize.setDensity(activity, AutoSizeConfig.getInstance().getInitDensity(), AutoSizeConfig.getInstance().getInitDensityDpi(), AutoSizeConfig.getInstance().getInitScaledDensity(), AutoSizeConfig.getInstance().getInitXdpi());
    }

    private static void setDensity(Activity activity, float density, int densityDpi, float scaledDensity, float xdpi) {
        DisplayMetrics activityDisplayMetrics = activity.getResources().getDisplayMetrics();
        DisplayMetrics appDisplayMetrics = AutoSizeConfig.getInstance().getApplication().getResources().getDisplayMetrics();
        AutoSize.setDensity(activityDisplayMetrics, density, densityDpi, scaledDensity, xdpi);
        AutoSize.setDensity(appDisplayMetrics, density, densityDpi, scaledDensity, xdpi);
        DisplayMetrics activityDisplayMetricsOnMIUI = AutoSize.getMetricsOnMiui(activity.getResources());
        DisplayMetrics appDisplayMetricsOnMIUI = AutoSize.getMetricsOnMiui(AutoSizeConfig.getInstance().getApplication().getResources());
        if (activityDisplayMetricsOnMIUI != null) {
            AutoSize.setDensity(activityDisplayMetricsOnMIUI, density, densityDpi, scaledDensity, xdpi);
        }
        if (appDisplayMetricsOnMIUI != null) {
            AutoSize.setDensity(appDisplayMetricsOnMIUI, density, densityDpi, scaledDensity, xdpi);
        }
    }

    private static void setDensity(DisplayMetrics displayMetrics, float density, int densityDpi, float scaledDensity, float xdpi) {
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportDP()) {
            displayMetrics.density = density;
            displayMetrics.densityDpi = densityDpi;
        }
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportSP()) {
            displayMetrics.scaledDensity = scaledDensity;
        }
        switch (AutoSizeConfig.getInstance().getUnitsManager().getSupportSubunits()) {
            case NONE: {
                break;
            }
            case PT: {
                displayMetrics.xdpi = xdpi * 72.0f;
                break;
            }
            case IN: {
                displayMetrics.xdpi = xdpi;
                break;
            }
            case MM: {
                displayMetrics.xdpi = xdpi * 25.4f;
                break;
            }
        }
    }

    private static DisplayMetrics getMetricsOnMiui(Resources resources) {
        if ("MiuiResources".equals(resources.getClass().getSimpleName()) || "XResources".equals(resources.getClass().getSimpleName())) {
            try {
                Field field = Resources.class.getDeclaredField("mTmpMetrics");
                field.setAccessible(true);
                return (DisplayMetrics)field.get(resources);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

