/*
 * Decompiled with CFR 0.152.
 */
package jaygoo.widget.wlv;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.List;
import jaygoo.widget.wlv.R;
import jaygoo.widget.wlv.RenderView;

public class WaveLineView
extends RenderView {
    private static final int DEFAULT_SAMPLING_SIZE = 64;
    private static final float DEFAULT_OFFSET_SPEED = 250.0f;
    private static final int DEFAULT_SENSIBILITY = 5;
    private int samplingSize;
    private float offsetSpeed;
    private float volume = 0.0f;
    private int targetVolume = 50;
    private float perVolume;
    private int sensibility;
    private int backGroundColor = -1;
    private int lineColor;
    private int thickLineWidth;
    private int fineLineWidth;
    private final Paint paint = new Paint();
    private List<Path> paths;
    private float[] pathFuncs;
    private float[] samplingX;
    private float[] mapX;
    private int width;
    private int height;
    private int centerHeight;
    private float amplitude;
    private SparseArray<Double> recessionFuncs;
    private boolean isPrepareLineAnimEnd;
    private int lineAnimX;
    private boolean isPrepareAlphaAnimEnd;
    private float prepareAlpha;
    private boolean isOpenPrepareAnim;
    private boolean isTransparentMode;

    public WaveLineView(Context context) {
        this(context, null);
    }

    public WaveLineView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WaveLineView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.paint.setDither(true);
        this.paint.setAntiAlias(true);
        this.paths = new ArrayList<Path>();
        for (int i = 0; i < 4; ++i) {
            this.paths.add(new Path());
        }
        this.pathFuncs = new float[]{0.6f, 0.35f, 0.1f, -0.1f};
        this.recessionFuncs = new SparseArray();
        this.isPrepareLineAnimEnd = false;
        this.lineAnimX = 0;
        this.isPrepareAlphaAnimEnd = false;
        this.prepareAlpha = 0.0f;
        this.isOpenPrepareAnim = false;
        this.isTransparentMode = false;
        this.initAttr(attrs);
    }

    private void initAttr(AttributeSet attrs) {
        TypedArray t = this.getContext().obtainStyledAttributes(attrs, R.styleable.WaveLineView);
        this.backGroundColor = t.getColor(R.styleable.WaveLineView_wlvBackgroundColor, -1);
        this.samplingSize = t.getInt(R.styleable.WaveLineView_wlvSamplingSize, 64);
        this.lineColor = t.getColor(R.styleable.WaveLineView_wlvLineColor, Color.parseColor((String)"#2ED184"));
        this.thickLineWidth = (int)t.getDimension(R.styleable.WaveLineView_wlvThickLineWidth, 6.0f);
        this.fineLineWidth = (int)t.getDimension(R.styleable.WaveLineView_wlvFineLineWidth, 2.0f);
        this.offsetSpeed = t.getFloat(R.styleable.WaveLineView_wlvMoveSpeed, 250.0f);
        this.sensibility = t.getInt(R.styleable.WaveLineView_wlvSensibility, 5);
        this.isTransparentMode = this.backGroundColor == 0;
        t.recycle();
        this.checkVolumeValue();
        this.checkSensibilityValue();
        this.setZOrderOnTop(true);
        if (this.getHolder() != null) {
            this.getHolder().setFormat(-3);
        }
    }

    @Override
    protected void doDrawBackground(Canvas canvas) {
        if (this.isTransparentMode) {
            canvas.drawColor(this.backGroundColor, PorterDuff.Mode.CLEAR);
        } else {
            canvas.drawColor(this.backGroundColor);
        }
    }

    private boolean isParametersNull() {
        return null == this.samplingX || null == this.mapX || null == this.pathFuncs;
    }

    @Override
    protected void onRender(Canvas canvas, long millisPassed) {
        float offset = (float)millisPassed / this.offsetSpeed;
        if (this.isParametersNull()) {
            this.initDraw(canvas);
        }
        if (this.lineAnim(canvas)) {
            int i;
            this.resetPaths();
            this.softerChangeVolume();
            for (i = 0; i <= this.samplingSize; ++i) {
                if (this.isParametersNull()) {
                    this.initDraw(canvas);
                    if (this.isParametersNull()) {
                        return;
                    }
                }
                float x = this.samplingX[i];
                float curY = (float)((double)this.amplitude * this.calcValue(this.mapX[i], offset));
                for (int n = 0; n < this.paths.size(); ++n) {
                    float realY = curY * this.pathFuncs[n] * this.volume * 0.01f;
                    this.paths.get(n).lineTo(x, (float)this.centerHeight + realY);
                }
            }
            for (i = 0; i < this.paths.size(); ++i) {
                this.paths.get(i).moveTo((float)this.width, (float)this.centerHeight);
            }
            for (int n = 0; n < this.paths.size(); ++n) {
                if (n == 0) {
                    this.paint.setStrokeWidth((float)this.thickLineWidth);
                    this.paint.setAlpha((int)(255.0f * this.alphaInAnim()));
                } else {
                    this.paint.setStrokeWidth((float)this.fineLineWidth);
                    this.paint.setAlpha((int)(100.0f * this.alphaInAnim()));
                }
                canvas.drawPath(this.paths.get(n), this.paint);
            }
        }
    }

    private void checkVolumeValue() {
        if (this.targetVolume > 100) {
            this.targetVolume = 100;
        }
    }

    private void checkSensibilityValue() {
        if (this.sensibility > 10) {
            this.sensibility = 10;
        }
        if (this.sensibility < 1) {
            this.sensibility = 1;
        }
    }

    private void softerChangeVolume() {
        this.volume = this.volume < (float)this.targetVolume - this.perVolume ? (this.volume += this.perVolume) : (this.volume > (float)this.targetVolume + this.perVolume ? (this.volume < this.perVolume * 2.0f ? this.perVolume * 2.0f : (this.volume -= this.perVolume)) : (float)this.targetVolume);
    }

    private float alphaInAnim() {
        if (!this.isOpenPrepareAnim) {
            return 1.0f;
        }
        this.prepareAlpha = this.prepareAlpha < 1.0f ? (this.prepareAlpha += 0.02f) : 1.0f;
        return this.prepareAlpha;
    }

    private boolean lineAnim(Canvas canvas) {
        if (this.isPrepareLineAnimEnd || !this.isOpenPrepareAnim) {
            return true;
        }
        this.paths.get(0).moveTo(0.0f, (float)this.centerHeight);
        this.paths.get(1).moveTo((float)this.width, (float)this.centerHeight);
        for (int i = 1; i <= this.samplingSize; ++i) {
            float x = 1.0f * (float)i * (float)this.lineAnimX / (float)this.samplingSize;
            this.paths.get(0).lineTo(x, (float)this.centerHeight);
            this.paths.get(1).lineTo((float)this.width - x, (float)this.centerHeight);
        }
        this.paths.get(0).moveTo((float)this.width / 2.0f, (float)this.centerHeight);
        this.paths.get(1).moveTo((float)this.width / 2.0f, (float)this.centerHeight);
        this.lineAnimX += this.width / 60;
        canvas.drawPath(this.paths.get(0), this.paint);
        canvas.drawPath(this.paths.get(1), this.paint);
        if (this.lineAnimX > this.width / 2) {
            this.isPrepareLineAnimEnd = true;
            return true;
        }
        return false;
    }

    private void resetPaths() {
        for (int i = 0; i < this.paths.size(); ++i) {
            this.paths.get(i).rewind();
            this.paths.get(i).moveTo(0.0f, (float)this.centerHeight);
        }
    }

    private void initParameters() {
        this.lineAnimX = 0;
        this.prepareAlpha = 0.0f;
        this.isPrepareLineAnimEnd = false;
        this.isPrepareAlphaAnimEnd = false;
        this.samplingX = null;
    }

    @Override
    public void startAnim() {
        this.initParameters();
        super.startAnim();
    }

    @Override
    public void stopAnim() {
        super.stopAnim();
        this.clearDraw();
    }

    public void clearDraw() {
        Canvas canvas = null;
        try {
            canvas = this.getHolder().lockCanvas(null);
            canvas.drawColor(this.backGroundColor);
            this.resetPaths();
            for (int i = 0; i < this.paths.size(); ++i) {
                canvas.drawPath(this.paths.get(i), this.paint);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (canvas != null) {
                this.getHolder().unlockCanvasAndPost(canvas);
            }
        }
    }

    private void initDraw(Canvas canvas) {
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
        if (this.width == 0 || this.height == 0 || this.samplingSize == 0) {
            return;
        }
        this.centerHeight = this.height >> 1;
        this.amplitude = (float)this.height / 3.0f;
        this.perVolume = (float)this.sensibility * 0.35f;
        this.samplingX = new float[this.samplingSize + 1];
        this.mapX = new float[this.samplingSize + 1];
        float gap = (float)this.width / (float)this.samplingSize;
        for (int i = 0; i <= this.samplingSize; ++i) {
            float x;
            this.samplingX[i] = x = (float)i * gap;
            this.mapX[i] = x / (float)this.width * 4.0f - 2.0f;
        }
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.lineColor);
        this.paint.setStrokeWidth((float)this.thickLineWidth);
    }

    private double calcValue(float mapX, float offset) {
        double recessionFunc;
        int keyX = (int)(mapX * 1000.0f);
        double sinFunc = Math.sin(Math.PI * (double)mapX - (double)(offset %= 2.0f) * Math.PI);
        if (this.recessionFuncs.indexOfKey(keyX) >= 0) {
            recessionFunc = (Double)this.recessionFuncs.get(keyX);
        } else {
            recessionFunc = 4.0 / (4.0 + Math.pow(mapX, 4.0));
            this.recessionFuncs.put(keyX, (Object)recessionFunc);
        }
        return sinFunc * recessionFunc;
    }

    public void setMoveSpeed(float moveSpeed) {
        this.offsetSpeed = moveSpeed;
    }

    public void setVolume(int volume) {
        if ((float)Math.abs(this.targetVolume - volume) > this.perVolume) {
            this.targetVolume = volume;
            this.checkVolumeValue();
        }
    }

    public void setBackGroundColor(int backGroundColor) {
        this.backGroundColor = backGroundColor;
        this.isTransparentMode = backGroundColor == 0;
    }

    public void setLineColor(int lineColor) {
        this.lineColor = lineColor;
    }

    public void setSensibility(int sensibility) {
        this.sensibility = sensibility;
        this.checkSensibilityValue();
    }
}

