/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jaygoo.widget.R;

public class RangeSeekBar
extends View {
    public static final int HINT_MODE_DEFAULT = 0;
    public static final int HINT_MODE_ALWAYS_HIDE = 1;
    public static final int HINT_MODE_TOUCH_ALWAYS_SHOW = 2;
    public static final int HINT_MODE_ALWAYS_SHOW = 3;
    private static final float DEFAULT_RADIUS = 0.5f;
    private int DEFAULT_PADDING_LEFT_AND_RIGHT;
    private int defaultPaddingTop;
    private int mProgressHintBGId;
    private int mThumbResId;
    private int mCellMode;
    private int mSeekBarMode;
    private int cellsCount = 1;
    private int textPadding;
    private int mHintBGPadding;
    private int mSeekBarHeight;
    private int mThumbSize;
    private int reserveCount;
    private int mCursorTextHeight;
    private int mPartLength;
    private int heightNeeded;
    private int lineWidth;
    private float lineRadius;
    private int colorLineSelected;
    private int colorLineEdge;
    private int colorPrimary;
    private int colorSecondary;
    private int mTextSize;
    private int lineTop;
    private int lineBottom;
    private int lineLeft;
    private int lineRight;
    private float mHintBGHeight;
    private float mHintBGWith;
    private float offsetValue;
    private float cellsPercent;
    private float reserveValue;
    private float reservePercent;
    private float maxValue;
    private float minValue;
    private float mMin;
    private float mMax;
    private boolean isEnable = true;
    private int mProgressHintMode;
    private CharSequence[] mTextArray;
    private Bitmap mProgressHintBG;
    private Paint mMainPaint = new Paint();
    private Paint mCursorPaint = new Paint();
    private Paint mProgressPaint;
    private RectF backgroundLineRect = new RectF();
    private RectF foregroundLineRect = new RectF();
    private SeekBar leftSB;
    private SeekBar rightSB;
    private SeekBar currTouch;
    private OnRangeChangedListener callback;

    public RangeSeekBar(Context context) {
        this(context, null);
    }

    public RangeSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.RangeSeekBar);
        this.cellsCount = t.getInt(R.styleable.RangeSeekBar_rsb_cells, 1);
        this.reserveValue = t.getFloat(R.styleable.RangeSeekBar_rsb_reserve, 0.0f);
        this.mMin = t.getFloat(R.styleable.RangeSeekBar_rsb_min, 0.0f);
        this.mMax = t.getFloat(R.styleable.RangeSeekBar_rsb_max, 100.0f);
        this.mThumbResId = t.getResourceId(R.styleable.RangeSeekBar_rsb_thumbResId, 0);
        this.mProgressHintBGId = t.getResourceId(R.styleable.RangeSeekBar_rsb_progressHintResId, 0);
        this.colorLineSelected = t.getColor(R.styleable.RangeSeekBar_rsb_lineColorSelected, -11806366);
        this.colorLineEdge = t.getColor(R.styleable.RangeSeekBar_rsb_lineColorEdge, -2631721);
        this.colorPrimary = t.getColor(R.styleable.RangeSeekBar_rsb_thumbPrimaryColor, 0);
        this.colorSecondary = t.getColor(R.styleable.RangeSeekBar_rsb_thumbSecondaryColor, 0);
        this.mTextArray = t.getTextArray(R.styleable.RangeSeekBar_rsb_markTextArray);
        this.mProgressHintMode = t.getInt(R.styleable.RangeSeekBar_rsb_progressHintMode, 0);
        this.textPadding = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_textPadding, (float)this.dp2px(context, 7.0f));
        this.mTextSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_textSize, (float)this.dp2px(context, 12.0f));
        this.mHintBGHeight = t.getDimension(R.styleable.RangeSeekBar_rsb_hintBGHeight, 0.0f);
        this.mHintBGWith = t.getDimension(R.styleable.RangeSeekBar_rsb_hintBGWith, 0.0f);
        this.mSeekBarHeight = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_seekBarHeight, (float)this.dp2px(context, 2.0f));
        this.mHintBGPadding = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_hintBGPadding, 0.0f);
        this.mThumbSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_thumbSize, (float)this.dp2px(context, 26.0f));
        this.mCellMode = t.getInt(R.styleable.RangeSeekBar_rsb_cellMode, 0);
        this.mSeekBarMode = t.getInt(R.styleable.RangeSeekBar_rsb_seekBarMode, 2);
        this.lineRadius = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_lineRadius, -1.0f);
        if (this.mSeekBarMode == 2) {
            this.leftSB = new SeekBar(-1);
            this.rightSB = new SeekBar(1);
        } else {
            this.leftSB = new SeekBar(-1);
        }
        this.DEFAULT_PADDING_LEFT_AND_RIGHT = this.mHintBGWith == 0.0f ? this.dp2px(context, 25.0f) : Math.max((int)(this.mHintBGWith / 2.0f + (float)this.dp2px(context, 5.0f)), this.dp2px(context, 25.0f));
        this.setRules(this.mMin, this.mMax, this.reserveValue, this.cellsCount);
        this.initPaint();
        this.initBitmap();
        t.recycle();
        this.defaultPaddingTop = this.mSeekBarHeight / 2;
        this.mHintBGHeight = this.mProgressHintMode == 1 && this.mTextArray == null ? this.mCursorPaint.measureText("\u56fd") : (this.mHintBGHeight == 0.0f ? this.mCursorPaint.measureText("\u56fd") * 3.0f : this.mHintBGHeight);
        this.lineTop = (int)this.mHintBGHeight + this.mThumbSize / 2 - this.mSeekBarHeight / 2;
        this.lineBottom = this.lineTop + this.mSeekBarHeight;
        if (this.lineRadius < 0.0f) {
            this.lineRadius = (int)((float)(this.lineBottom - this.lineTop) * 0.45f);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.heightNeeded = 2 * this.lineTop + this.mSeekBarHeight;
        heightSize = heightMode == 0x40000000 ? View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000) : (heightMode == Integer.MIN_VALUE ? View.MeasureSpec.makeMeasureSpec((int)this.heightNeeded, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)this.heightNeeded, (int)0x40000000));
        super.onMeasure(widthMeasureSpec, heightSize);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.lineLeft = this.DEFAULT_PADDING_LEFT_AND_RIGHT + this.getPaddingLeft();
        this.lineRight = w - this.lineLeft - this.getPaddingRight();
        this.lineWidth = this.lineRight - this.lineLeft;
        this.backgroundLineRect.set((float)this.lineLeft, (float)this.lineTop, (float)this.lineRight, (float)this.lineBottom);
        this.leftSB.onSizeChanged(this.lineLeft, this.lineBottom, this.mThumbSize, this.lineWidth, this.cellsCount > 1, this.mThumbResId, this.getContext());
        if (this.mSeekBarMode == 2) {
            this.rightSB.onSizeChanged(this.lineLeft, this.lineBottom, this.mThumbSize, this.lineWidth, this.cellsCount > 1, this.mThumbResId, this.getContext());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mTextArray != null) {
            this.mPartLength = this.lineWidth / (this.mTextArray.length - 1);
            for (int i = 0; i < this.mTextArray.length; ++i) {
                float x;
                String text2Draw = this.mTextArray[i].toString();
                if (this.mCellMode == 1) {
                    this.mCursorPaint.setColor(this.colorLineEdge);
                    x = (float)(this.lineLeft + i * this.mPartLength) - this.mCursorPaint.measureText(text2Draw) / 2.0f;
                } else {
                    float[] result;
                    float num = Float.parseFloat(text2Draw);
                    if (this.compareFloat(num, (result = this.getCurrentRange())[0]) != -1 && this.compareFloat(num, result[1]) != 1 && this.mSeekBarMode == 2) {
                        this.mCursorPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorAccent));
                    } else {
                        this.mCursorPaint.setColor(this.colorLineEdge);
                    }
                    x = (float)this.lineLeft + (float)this.lineWidth * (num - this.mMin) / (this.mMax - this.mMin) - this.mCursorPaint.measureText(text2Draw) / 2.0f;
                }
                float y = this.lineTop - this.textPadding;
                canvas.drawText(text2Draw, x, y, this.mCursorPaint);
            }
        }
        this.mMainPaint.setColor(this.colorLineEdge);
        canvas.drawRoundRect(this.backgroundLineRect, this.lineRadius, this.lineRadius, this.mMainPaint);
        this.mMainPaint.setColor(this.colorLineSelected);
        if (this.mSeekBarMode == 2) {
            this.foregroundLineRect.top = this.lineTop;
            this.foregroundLineRect.left = (float)(this.leftSB.left + this.leftSB.widthSize / 2) + (float)this.leftSB.lineWidth * this.leftSB.currPercent;
            this.foregroundLineRect.right = (float)(this.rightSB.left + this.rightSB.widthSize / 2) + (float)this.rightSB.lineWidth * this.rightSB.currPercent;
            this.foregroundLineRect.bottom = this.lineBottom;
            canvas.drawRoundRect(this.foregroundLineRect, this.lineRadius, this.lineRadius, this.mMainPaint);
        } else {
            this.foregroundLineRect.top = this.lineTop;
            this.foregroundLineRect.left = this.leftSB.left + this.leftSB.widthSize / 2;
            this.foregroundLineRect.right = (float)(this.leftSB.left + this.leftSB.widthSize / 2) + (float)this.leftSB.lineWidth * this.leftSB.currPercent;
            this.foregroundLineRect.bottom = this.lineBottom;
            canvas.drawRoundRect(this.foregroundLineRect, this.lineRadius, this.lineRadius, this.mMainPaint);
        }
        if (this.mProgressHintMode == 3) {
            this.isShowProgressHint(this.leftSB, true);
        }
        this.leftSB.draw(canvas);
        if (this.mSeekBarMode == 2) {
            if (this.mProgressHintMode == 3) {
                this.isShowProgressHint(this.rightSB, true);
            }
            this.rightSB.draw(canvas);
        }
    }

    private void initPaint() {
        this.mMainPaint.setStyle(Paint.Style.FILL);
        this.mMainPaint.setColor(this.colorLineEdge);
        this.mCursorPaint.setStyle(Paint.Style.FILL);
        this.mCursorPaint.setColor(this.colorLineEdge);
        this.mCursorPaint.setTextSize((float)this.mTextSize);
        this.mProgressPaint = new Paint(1);
        this.mProgressPaint.setTypeface(Typeface.DEFAULT);
        Paint.FontMetrics fm = this.mCursorPaint.getFontMetrics();
        this.mCursorTextHeight = (int)(Math.ceil(fm.descent - fm.ascent) + 2.0);
    }

    private void initBitmap() {
        this.mProgressHintBG = this.mProgressHintBGId != 0 ? BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mProgressHintBGId) : BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.progress_hint_bg);
    }

    public void setOnRangeChangedListener(OnRangeChangedListener listener) {
        this.callback = listener;
    }

    public void setValue(float min, float max) {
        min += this.offsetValue;
        max += this.offsetValue;
        if (min < this.minValue) {
            throw new IllegalArgumentException("setValue() min < (preset min - offsetValue) . #min:" + min + " #preset min:" + this.minValue + " #offsetValue:" + this.offsetValue);
        }
        if (max > this.maxValue) {
            throw new IllegalArgumentException("setValue() max > (preset max - offsetValue) . #max:" + max + " #preset max:" + this.maxValue + " #offsetValue:" + this.offsetValue);
        }
        if (this.reserveCount > 1) {
            if ((min - this.minValue) % (float)this.reserveCount != 0.0f) {
                throw new IllegalArgumentException("setValue() (min - preset min) % reserveCount != 0 . #min:" + min + " #preset min:" + this.minValue + "#reserveCount:" + this.reserveCount + "#reserve:" + this.reserveValue);
            }
            if ((max - this.minValue) % (float)this.reserveCount != 0.0f) {
                throw new IllegalArgumentException("setValue() (max - preset min) % reserveCount != 0 . #max:" + max + " #preset min:" + this.minValue + "#reserveCount:" + this.reserveCount + "#reserve:" + this.reserveValue);
            }
            this.leftSB.currPercent = (min - this.minValue) / (float)this.reserveCount * this.cellsPercent;
            if (this.mSeekBarMode == 2) {
                this.rightSB.currPercent = (max - this.minValue) / (float)this.reserveCount * this.cellsPercent;
            }
        } else {
            this.leftSB.currPercent = (min - this.minValue) / (this.maxValue - this.minValue);
            if (this.mSeekBarMode == 2) {
                this.rightSB.currPercent = (max - this.minValue) / (this.maxValue - this.minValue);
            }
        }
        if (this.callback != null) {
            if (this.mSeekBarMode == 2) {
                this.callback.onRangeChanged(this, this.leftSB.currPercent, this.rightSB.currPercent, false);
            } else {
                this.callback.onRangeChanged(this, this.leftSB.currPercent, this.leftSB.currPercent, false);
            }
        }
        this.invalidate();
    }

    public void setValue(float value) {
        this.setValue(value, this.mMax);
    }

    public void setRange(float min, float max) {
        this.setRules(min, max, this.reserveCount, this.cellsCount);
    }

    public void setLineColor(int colorLineEdge, int colorLineSelected) {
        this.colorLineEdge = colorLineEdge;
        this.colorLineSelected = colorLineSelected;
    }

    public void setThumbPrimaryColor(int thumbPrimaryColor) {
        this.colorPrimary = thumbPrimaryColor;
    }

    public void setThumbSecondaryColor(int thumbSecondaryColor) {
        this.colorSecondary = thumbSecondaryColor;
    }

    public void setCellsCount(int cellsCount) {
        this.cellsCount = cellsCount;
    }

    public void setThumbSize(int mThumbSize) {
        this.mThumbSize = mThumbSize;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setProgressHintMode(int mProgressHintMode) {
        this.mProgressHintMode = mProgressHintMode;
    }

    public void setProgressHintBGId(int mProgressHintBGId) {
        this.mProgressHintBGId = mProgressHintBGId;
    }

    public void setThumbResId(int mThumbResId) {
        this.mThumbResId = mThumbResId;
    }

    public void setCellMode(int mCellMode) {
        this.mCellMode = mCellMode;
    }

    public void setSeekBarMode(int mSeekBarMode) {
        this.mSeekBarMode = mSeekBarMode;
    }

    public void setRules(float min, float max, float reserve, int cells) {
        if (max <= min) {
            throw new IllegalArgumentException("setRules() max must be greater than min ! #max:" + max + " #min:" + min);
        }
        this.mMax = max;
        this.mMin = min;
        if (min < 0.0f) {
            this.offsetValue = 0.0f - min;
            min += this.offsetValue;
            max += this.offsetValue;
        }
        this.minValue = min;
        this.maxValue = max;
        if (reserve < 0.0f) {
            throw new IllegalArgumentException("setRules() reserve must be greater than zero ! #reserve:" + reserve);
        }
        if (reserve >= max - min) {
            throw new IllegalArgumentException("setRules() reserve must be less than (max - min) ! #reserve:" + reserve + " #max - min:" + (max - min));
        }
        if (cells < 1) {
            throw new IllegalArgumentException("setRules() cells must be greater than 1 ! #cells:" + cells);
        }
        this.cellsCount = cells;
        this.cellsPercent = 1.0f / (float)this.cellsCount;
        this.reserveValue = reserve;
        this.reservePercent = reserve / (max - min);
        this.reserveCount = (int)(this.reservePercent / this.cellsPercent + (float)(this.reservePercent % this.cellsPercent != 0.0f ? 1 : 0));
        if (this.cellsCount > 1) {
            if (this.mSeekBarMode == 2) {
                if (this.leftSB.currPercent + this.cellsPercent * (float)this.reserveCount <= 1.0f && this.leftSB.currPercent + this.cellsPercent * (float)this.reserveCount > this.rightSB.currPercent) {
                    this.rightSB.currPercent = this.leftSB.currPercent + this.cellsPercent * (float)this.reserveCount;
                } else if (this.rightSB.currPercent - this.cellsPercent * (float)this.reserveCount >= 0.0f && this.rightSB.currPercent - this.cellsPercent * (float)this.reserveCount < this.leftSB.currPercent) {
                    this.leftSB.currPercent = this.rightSB.currPercent - this.cellsPercent * (float)this.reserveCount;
                }
            } else if (1.0f - this.cellsPercent * (float)this.reserveCount >= 0.0f && 1.0f - this.cellsPercent * (float)this.reserveCount < this.leftSB.currPercent) {
                this.leftSB.currPercent = 1.0f - this.cellsPercent * (float)this.reserveCount;
            }
        } else if (this.mSeekBarMode == 2) {
            if (this.leftSB.currPercent + this.reservePercent <= 1.0f && this.leftSB.currPercent + this.reservePercent > this.rightSB.currPercent) {
                this.rightSB.currPercent = this.leftSB.currPercent + this.reservePercent;
            } else if (this.rightSB.currPercent - this.reservePercent >= 0.0f && this.rightSB.currPercent - this.reservePercent < this.leftSB.currPercent) {
                this.leftSB.currPercent = this.rightSB.currPercent - this.reservePercent;
            }
        } else if (1.0f - this.reservePercent >= 0.0f && 1.0f - this.reservePercent < this.leftSB.currPercent) {
            this.leftSB.currPercent = 1.0f - this.reservePercent;
        }
        this.invalidate();
    }

    public float getMax() {
        return this.mMax;
    }

    public float getMin() {
        return this.mMin;
    }

    public float[] getCurrentRange() {
        float range = this.maxValue - this.minValue;
        if (this.mSeekBarMode == 2) {
            return new float[]{-this.offsetValue + this.minValue + range * this.leftSB.currPercent, -this.offsetValue + this.minValue + range * this.rightSB.currPercent};
        }
        return new float[]{-this.offsetValue + this.minValue + range * this.leftSB.currPercent, -this.offsetValue + this.minValue + range * 1.0f};
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.isEnable = enabled;
    }

    public void setProgressDescription(String progress) {
        if (this.leftSB != null) {
            this.leftSB.setProgressHint(progress);
        }
        if (this.rightSB != null) {
            this.rightSB.setProgressHint(progress);
        }
    }

    public void setLeftProgressDescription(String progress) {
        if (this.leftSB != null) {
            this.leftSB.setProgressHint(progress);
        }
    }

    public void setRightProgressDescription(String progress) {
        if (this.rightSB != null) {
            this.rightSB.setProgressHint(progress);
        }
    }

    private void isShowProgressHint(SeekBar seekBar, boolean isEnable) {
        switch (this.mProgressHintMode) {
            case 0: {
                seekBar.isShowingHint = isEnable;
                break;
            }
            case 2: 
            case 3: {
                seekBar.isShowingHint = true;
                break;
            }
            case 1: {
                seekBar.isShowingHint = false;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnable) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                boolean touchResult = false;
                if (this.rightSB != null && this.rightSB.currPercent >= 1.0f && this.leftSB.collide(event)) {
                    this.currTouch = this.leftSB;
                    touchResult = true;
                } else if (this.rightSB != null && this.rightSB.collide(event)) {
                    this.currTouch = this.rightSB;
                    touchResult = true;
                } else if (this.leftSB.collide(event)) {
                    this.currTouch = this.leftSB;
                    touchResult = true;
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.callback != null) {
                    this.callback.onStartTrackingTouch(this, this.currTouch == this.leftSB);
                }
                return touchResult;
            }
            case 2: {
                float x = event.getX();
                this.currTouch.material = this.currTouch.material >= 1.0f ? 1.0f : this.currTouch.material + 0.1f;
                if (this.currTouch == this.leftSB) {
                    float percent;
                    if (this.cellsCount > 1) {
                        percent = x < (float)this.lineLeft ? 0.0f : (x - (float)this.lineLeft) * 1.0f / (float)this.lineWidth;
                        int touchLeftCellsValue = Math.round(percent / this.cellsPercent);
                        int currRightCellsValue = this.mSeekBarMode == 2 ? Math.round(this.rightSB.currPercent / this.cellsPercent) : Math.round(1.0f / this.cellsPercent);
                        percent = (float)touchLeftCellsValue * this.cellsPercent;
                        while (touchLeftCellsValue > currRightCellsValue - this.reserveCount && --touchLeftCellsValue >= 0) {
                            percent = (float)touchLeftCellsValue * this.cellsPercent;
                        }
                    } else {
                        percent = x < (float)this.lineLeft ? 0.0f : (x - (float)this.lineLeft) * 1.0f / (float)this.lineWidth;
                        if (this.mSeekBarMode == 2) {
                            if (percent > this.rightSB.currPercent - this.reservePercent) {
                                percent = this.rightSB.currPercent - this.reservePercent;
                            }
                        } else if (percent > 1.0f - this.reservePercent) {
                            percent = 1.0f - this.reservePercent;
                        }
                    }
                    this.leftSB.slide(percent);
                    this.isShowProgressHint(this.leftSB, true);
                    if (this.getParent() != null) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                } else if (this.currTouch == this.rightSB) {
                    float percent;
                    if (this.cellsCount > 1) {
                        percent = x > (float)this.lineRight ? 1.0f : (x - (float)this.lineLeft) * 1.0f / (float)this.lineWidth;
                        int touchRightCellsValue = Math.round(percent / this.cellsPercent);
                        int currLeftCellsValue = Math.round(this.leftSB.currPercent / this.cellsPercent);
                        percent = (float)touchRightCellsValue * this.cellsPercent;
                        while (touchRightCellsValue < currLeftCellsValue + this.reserveCount && !((float)(++touchRightCellsValue) > this.maxValue - this.minValue)) {
                            percent = (float)touchRightCellsValue * this.cellsPercent;
                        }
                    } else {
                        percent = x > (float)this.lineRight ? 1.0f : (x - (float)this.lineLeft) * 1.0f / (float)this.lineWidth;
                        if (percent < this.leftSB.currPercent + this.reservePercent) {
                            percent = this.leftSB.currPercent + this.reservePercent;
                        }
                    }
                    this.rightSB.slide(percent);
                    this.isShowProgressHint(this.rightSB, true);
                }
                if (this.callback != null) {
                    float[] result = this.getCurrentRange();
                    this.callback.onRangeChanged(this, result[0], result[1], true);
                }
                this.invalidate();
                if (this.getParent() == null) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 3: {
                if (this.mSeekBarMode == 2) {
                    this.isShowProgressHint(this.rightSB, false);
                }
                this.isShowProgressHint(this.leftSB, false);
                if (this.callback != null) {
                    float[] result = this.getCurrentRange();
                    this.callback.onRangeChanged(this, result[0], result[1], false);
                }
                if (this.getParent() == null) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                if (this.mSeekBarMode == 2) {
                    this.isShowProgressHint(this.rightSB, false);
                }
                this.isShowProgressHint(this.leftSB, false);
                this.currTouch.materialRestore();
                if (this.callback != null) {
                    float[] result = this.getCurrentRange();
                    this.callback.onRangeChanged(this, result[0], result[1], false);
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.callback == null) break;
                this.callback.onStopTrackingTouch(this, this.currTouch == this.leftSB);
            }
        }
        return super.onTouchEvent(event);
    }

    Bitmap drawableToBitmap(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)this.mThumbSize, (int)this.mThumbSize, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.minValue = this.minValue - this.offsetValue;
        ss.maxValue = this.maxValue - this.offsetValue;
        ss.reserveValue = this.reserveValue;
        ss.cellsCount = this.cellsCount;
        float[] results = this.getCurrentRange();
        ss.currSelectedMin = results[0];
        ss.currSelectedMax = results[1];
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        float min = ss.minValue;
        float max = ss.maxValue;
        float reserve = ss.reserveValue;
        int cells = ss.cellsCount;
        this.setRules(min, max, reserve, cells);
        float currSelectedMin = ss.currSelectedMin;
        float currSelectedMax = ss.currSelectedMax;
        this.setValue(currSelectedMin, currSelectedMax);
    }

    private int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private int compareFloat(float a, float b) {
        int tb;
        int ta = Math.round(a * 1000.0f);
        if (ta > (tb = Math.round(b * 1000.0f))) {
            return 1;
        }
        if (ta < tb) {
            return -1;
        }
        return 0;
    }

    private static class SavedState
    extends View.BaseSavedState {
        private float minValue;
        private float maxValue;
        private float reserveValue;
        private int cellsCount;
        private float currSelectedMin;
        private float currSelectedMax;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.minValue = in.readFloat();
            this.maxValue = in.readFloat();
            this.reserveValue = in.readFloat();
            this.cellsCount = in.readInt();
            this.currSelectedMin = in.readFloat();
            this.currSelectedMax = in.readFloat();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.minValue);
            out.writeFloat(this.maxValue);
            out.writeFloat(this.reserveValue);
            out.writeInt(this.cellsCount);
            out.writeFloat(this.currSelectedMin);
            out.writeFloat(this.currSelectedMax);
        }
    }

    public static interface OnRangeChangedListener {
        public void onRangeChanged(RangeSeekBar var1, float var2, float var3, boolean var4);

        public void onStartTrackingTouch(RangeSeekBar var1, boolean var2);

        public void onStopTrackingTouch(RangeSeekBar var1, boolean var2);
    }

    private class SeekBar {
        private int lineWidth;
        private int widthSize;
        private int heightSize;
        private int left;
        private int right;
        private int top;
        private int bottom;
        private float currPercent;
        private float material = 0.0f;
        public boolean isShowingHint;
        private boolean isLeft;
        private Bitmap bmp;
        private ValueAnimator anim;
        private RadialGradient shadowGradient;
        private Paint defaultPaint;
        private String mHintText2Draw;
        private Boolean isPrimary = true;
        final TypeEvaluator<Integer> te = new TypeEvaluator<Integer>(){

            public Integer evaluate(float fraction, Integer startValue, Integer endValue) {
                int alpha = (int)((float)Color.alpha((int)startValue) + fraction * (float)(Color.alpha((int)endValue) - Color.alpha((int)startValue)));
                int red = (int)((float)Color.red((int)startValue) + fraction * (float)(Color.red((int)endValue) - Color.red((int)startValue)));
                int green = (int)((float)Color.green((int)startValue) + fraction * (float)(Color.green((int)endValue) - Color.green((int)startValue)));
                int blue = (int)((float)Color.blue((int)startValue) + fraction * (float)(Color.blue((int)endValue) - Color.blue((int)startValue)));
                return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
            }
        };

        public SeekBar(int position) {
            this.isLeft = position < 0;
        }

        protected void onSizeChanged(int x, int y, int hSize, int parentLineWidth, boolean cellsMode, int bmpResId, Context context) {
            this.widthSize = this.heightSize = hSize;
            this.left = x - this.widthSize / 2;
            this.right = x + this.widthSize / 2;
            this.top = y - this.heightSize / 2;
            this.bottom = y + this.heightSize / 2;
            this.lineWidth = cellsMode ? parentLineWidth : parentLineWidth;
            if (bmpResId > 0) {
                Bitmap original = RangeSeekBar.this.drawableToBitmap(RangeSeekBar.this.getResources().getDrawable(bmpResId));
                if (original != null) {
                    float scaleHeight;
                    Matrix matrix = new Matrix();
                    float scaleWidth = scaleHeight = (float)RangeSeekBar.this.mThumbSize * 1.0f / (float)original.getHeight();
                    matrix.postScale(scaleWidth, scaleHeight);
                    this.bmp = Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)original.getWidth(), (int)original.getHeight(), (Matrix)matrix, (boolean)true);
                }
            } else {
                this.defaultPaint = new Paint(1);
                int radius = (int)((float)this.widthSize * 0.5f);
                int barShadowRadius = (int)((float)radius * 0.95f);
                int mShadowCenterX = this.widthSize / 2;
                int mShadowCenterY = this.heightSize / 2;
                this.shadowGradient = new RadialGradient((float)mShadowCenterX, (float)mShadowCenterY, (float)barShadowRadius, -16777216, 0, Shader.TileMode.CLAMP);
            }
        }

        protected void draw(Canvas canvas) {
            int offset = (int)((float)this.lineWidth * this.currPercent);
            canvas.save();
            canvas.translate((float)offset, 0.0f);
            String text2Draw = "";
            int hintW = 0;
            int hintH = 0;
            float[] result = RangeSeekBar.this.getCurrentRange();
            if (this.isLeft) {
                text2Draw = this.mHintText2Draw == null ? (int)result[0] + "" : this.mHintText2Draw;
                this.isPrimary = RangeSeekBar.this.compareFloat(result[0], RangeSeekBar.this.mMin) == 0;
            } else {
                text2Draw = this.mHintText2Draw == null ? (int)result[1] + "" : this.mHintText2Draw;
                this.isPrimary = RangeSeekBar.this.compareFloat(result[1], RangeSeekBar.this.mMax) == 0;
            }
            hintH = (int)RangeSeekBar.this.mHintBGHeight;
            hintW = (int)(RangeSeekBar.this.mHintBGWith == 0.0f ? RangeSeekBar.this.mCursorPaint.measureText(text2Draw) + (float)RangeSeekBar.this.DEFAULT_PADDING_LEFT_AND_RIGHT : RangeSeekBar.this.mHintBGWith);
            if ((float)hintW < 1.5f * (float)hintH) {
                hintW = (int)(1.5f * (float)hintH);
            }
            if (this.bmp != null) {
                canvas.drawBitmap(this.bmp, (float)this.left, (float)(RangeSeekBar.this.lineTop + (RangeSeekBar.this.mSeekBarHeight - this.bmp.getHeight()) / 2), null);
                if (this.isShowingHint) {
                    Rect rect = new Rect();
                    rect.left = this.left - (hintW / 2 - this.bmp.getWidth() / 2);
                    rect.top = this.bottom - hintH - this.bmp.getHeight();
                    rect.right = rect.left + hintW;
                    rect.bottom = rect.top + hintH;
                    this.drawNinePath(canvas, RangeSeekBar.this.mProgressHintBG, rect);
                    RangeSeekBar.this.mCursorPaint.setColor(-1);
                    int x = (int)((float)(this.left + this.bmp.getWidth() / 2) - RangeSeekBar.this.mCursorPaint.measureText(text2Draw) / 2.0f);
                    int y = this.bottom - hintH - this.bmp.getHeight() + hintH / 2;
                    canvas.drawText(text2Draw, (float)x, (float)y, RangeSeekBar.this.mCursorPaint);
                }
            } else {
                canvas.translate((float)this.left, 0.0f);
                if (this.isShowingHint) {
                    Rect rect = new Rect();
                    rect.left = this.widthSize / 2 - hintW / 2;
                    rect.top = RangeSeekBar.this.defaultPaddingTop;
                    rect.right = rect.left + hintW;
                    rect.bottom = rect.top + hintH;
                    this.drawNinePath(canvas, RangeSeekBar.this.mProgressHintBG, rect);
                    RangeSeekBar.this.mCursorPaint.setColor(-1);
                    int x = (int)((float)(this.widthSize / 2) - RangeSeekBar.this.mCursorPaint.measureText(text2Draw) / 2.0f);
                    int y = hintH / 3 + RangeSeekBar.this.defaultPaddingTop + RangeSeekBar.this.mCursorTextHeight / 2;
                    canvas.drawText(text2Draw, (float)x, (float)y, RangeSeekBar.this.mCursorPaint);
                }
                this.drawDefault(canvas);
            }
            canvas.restore();
        }

        public void drawNinePath(Canvas c, Bitmap bmp, Rect rect) {
            NinePatch patch = new NinePatch(bmp, bmp.getNinePatchChunk(), null);
            patch.draw(c, rect);
        }

        private void drawDefault(Canvas canvas) {
            int centerX = this.widthSize / 2;
            int centerY = RangeSeekBar.this.lineBottom - RangeSeekBar.this.mSeekBarHeight / 2;
            int radius = (int)((float)this.widthSize * 0.5f);
            this.defaultPaint.setStyle(Paint.Style.FILL);
            canvas.save();
            canvas.translate(0.0f, (float)radius * 0.25f);
            canvas.scale(1.0f + 0.1f * this.material, 1.0f + 0.1f * this.material, (float)centerX, (float)centerY);
            this.defaultPaint.setShader((Shader)this.shadowGradient);
            canvas.drawCircle((float)centerX, (float)centerY, (float)radius, this.defaultPaint);
            this.defaultPaint.setShader(null);
            canvas.restore();
            this.defaultPaint.setStyle(Paint.Style.FILL);
            if (this.isPrimary.booleanValue()) {
                if (RangeSeekBar.this.colorPrimary == 0) {
                    this.defaultPaint.setColor(((Integer)this.te.evaluate(this.material, (Object)-1, (Object)-1579033)).intValue());
                } else {
                    this.defaultPaint.setColor(RangeSeekBar.this.colorPrimary);
                }
            } else if (RangeSeekBar.this.colorSecondary == 0) {
                this.defaultPaint.setColor(((Integer)this.te.evaluate(this.material, (Object)-1, (Object)-1579033)).intValue());
            } else {
                this.defaultPaint.setColor(RangeSeekBar.this.colorSecondary);
            }
            canvas.drawCircle((float)centerX, (float)centerY, (float)radius, this.defaultPaint);
            this.defaultPaint.setStyle(Paint.Style.STROKE);
            this.defaultPaint.setColor(-2631721);
            canvas.drawCircle((float)centerX, (float)centerY, (float)radius, this.defaultPaint);
        }

        protected boolean collide(MotionEvent event) {
            float x = event.getX();
            float y = event.getY();
            int offset = (int)((float)this.lineWidth * this.currPercent);
            return x > (float)(this.left + offset) && x < (float)(this.right + offset) && y > (float)this.top && y < (float)this.bottom;
        }

        private void slide(float percent) {
            if (percent < 0.0f) {
                percent = 0.0f;
            } else if (percent > 1.0f) {
                percent = 1.0f;
            }
            this.currPercent = percent;
        }

        private void materialRestore() {
            if (this.anim != null) {
                this.anim.cancel();
            }
            this.anim = ValueAnimator.ofFloat((float[])new float[]{this.material, 0.0f});
            this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    SeekBar.this.material = ((Float)animation.getAnimatedValue()).floatValue();
                    RangeSeekBar.this.invalidate();
                }
            });
            this.anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    SeekBar.this.material = 0.0f;
                    RangeSeekBar.this.invalidate();
                }
            });
            this.anim.start();
        }

        public void setProgressHint(String hint) {
            this.mHintText2Draw = hint;
        }
    }
}

