/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.jaygoo.widget.R;
import com.jaygoo.widget.RangeSeekBar;

public class VerticalRangeSeekBar
extends RangeSeekBar {
    public static final int DICTION_LEFT = -1;
    public static final int DICTION_RIGHT = 1;
    private int orientation;

    public VerticalRangeSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.RangeSeekBar);
        this.orientation = t.getInt(R.styleable.RangeSeekBar_rsb_orientation, -1);
        t.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(h, w, oldh, oldw);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.orientation == -1) {
            canvas.rotate(-90.0f);
            canvas.translate((float)(-this.getHeight()), 0.0f);
        } else {
            canvas.rotate(90.0f);
            canvas.translate(0.0f, (float)(-this.getWidth()));
        }
        super.onDraw(canvas);
    }

    @Override
    protected float getEventX(MotionEvent event) {
        if (this.orientation == -1) {
            return (float)this.getHeight() - event.getY();
        }
        return event.getY();
    }

    @Override
    protected float getEventY(MotionEvent event) {
        if (this.orientation == -1) {
            return event.getX();
        }
        return -event.getX() + (float)this.getWidth();
    }
}

