/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

public class Utils {
    public static Bitmap drawableToBitmap(int size, Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable2 instanceof BitmapDrawable && (bitmap = (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap()) != null && bitmap.getHeight() > 0) {
            Matrix matrix = new Matrix();
            float scaleHeight = (float)size * 1.0f / (float)bitmapDrawable.getIntrinsicHeight();
            matrix.postScale(scaleHeight, scaleHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            return bitmap;
        }
        bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static void drawNinePath(Canvas canvas, Bitmap bmp, Rect rect) {
        NinePatch patch = new NinePatch(bmp, bmp.getNinePatchChunk(), null);
        patch.draw(canvas, rect);
    }

    public static int dp2px(Context context, float dpValue) {
        if (context == null || Utils.compareFloat(0.0f, dpValue) == 0) {
            return 0;
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int compareFloat(float a, float b) {
        int tb;
        int ta = Math.round(a * 100000.0f);
        if (ta > (tb = Math.round(b * 100000.0f))) {
            return 1;
        }
        if (ta < tb) {
            return -1;
        }
        return 0;
    }
}

