/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.res.TypedArray;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.StyleableRes;
import com.noober.background.R;
import com.noober.background.drawable.ICreateDrawable;

public class AnimationDrawableCreator
implements ICreateDrawable {
    private TypedArray animationTa;
    private int duration = 0;
    private AnimationDrawable drawable = new AnimationDrawable();

    public AnimationDrawableCreator(TypedArray animationTa) {
        this.animationTa = animationTa;
    }

    @Override
    public Drawable create() throws Exception {
        Drawable itemDrawable;
        for (int i = 0; i < this.animationTa.getIndexCount(); ++i) {
            int attr2 = this.animationTa.getIndex(i);
            if (attr2 == R.styleable.bl_anim_bl_duration) {
                this.duration = this.animationTa.getInt(attr2, 0);
                continue;
            }
            if (attr2 != R.styleable.bl_anim_bl_oneshot) continue;
            this.drawable.setOneShot(this.animationTa.getBoolean(attr2, false));
        }
        if (this.animationTa.hasValue(R.styleable.bl_anim_bl_frame_drawable_item0) && (itemDrawable = this.animationTa.getDrawable(R.styleable.bl_anim_bl_frame_drawable_item0)) != null) {
            if (this.animationTa.hasValue(R.styleable.bl_anim_bl_duration_item0)) {
                this.drawable.addFrame(itemDrawable, this.animationTa.getInt(R.styleable.bl_anim_bl_duration_item0, 0));
            } else {
                this.drawable.addFrame(itemDrawable, this.duration);
            }
        }
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item0, R.styleable.bl_anim_bl_duration_item0);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item1, R.styleable.bl_anim_bl_duration_item1);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item2, R.styleable.bl_anim_bl_duration_item2);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item3, R.styleable.bl_anim_bl_duration_item3);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item4, R.styleable.bl_anim_bl_duration_item4);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item5, R.styleable.bl_anim_bl_duration_item5);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item6, R.styleable.bl_anim_bl_duration_item6);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item7, R.styleable.bl_anim_bl_duration_item7);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item8, R.styleable.bl_anim_bl_duration_item8);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item9, R.styleable.bl_anim_bl_duration_item9);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item10, R.styleable.bl_anim_bl_duration_item10);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item11, R.styleable.bl_anim_bl_duration_item11);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item12, R.styleable.bl_anim_bl_duration_item12);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item13, R.styleable.bl_anim_bl_duration_item13);
        this.addFrame(R.styleable.bl_anim_bl_frame_drawable_item14, R.styleable.bl_anim_bl_duration_item14);
        return this.drawable;
    }

    private void addFrame(@StyleableRes int itemDrawableId, @StyleableRes int itemDurationId) {
        Drawable itemDrawable;
        if (this.animationTa.hasValue(itemDrawableId) && (itemDrawable = this.animationTa.getDrawable(itemDrawableId)) != null) {
            if (this.animationTa.hasValue(itemDurationId)) {
                this.drawable.addFrame(itemDrawable, this.animationTa.getInt(itemDurationId, 0));
            } else {
                this.drawable.addFrame(itemDrawable, this.duration);
            }
        }
    }
}

