/*
 * Decompiled with CFR 0.152.
 */
package com.devzone.fillprogresslayout;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.LinearLayout;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.devzone.fillprogresslayout.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0014\u0018\u0000 l2\u00020\u0001:\u0001lB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00103\u001a\u00020#H\u0002J\u0012\u00104\u001a\u00020#2\b\u00105\u001a\u0004\u0018\u000106H\u0014J\u0012\u00107\u001a\u00020#2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00108\u001a\u00020#2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\fH\u0002J\b\u0010;\u001a\u00020\tH\u0002J\b\u0010<\u001a\u00020\tH\u0002J\b\u0010=\u001a\u00020#H\u0002J\u001a\u0010>\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020\tH\u0002J\u0010\u0010A\u001a\u00020#2\u0006\u0010B\u001a\u00020CH\u0002J\b\u0010D\u001a\u00020#H\u0014J\u0012\u0010E\u001a\u00020#2\b\u00105\u001a\u0004\u0018\u000106H\u0014J(\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020\t2\u0006\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020\t2\u0006\u0010J\u001a\u00020\tH\u0014J\u0012\u0010K\u001a\u00020#2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0010\u0010N\u001a\u00020#2\u0006\u0010O\u001a\u00020\tH\u0016J\u0012\u0010P\u001a\u00020#2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0010\u0010Q\u001a\u00020#2\u0006\u0010R\u001a\u00020\tH\u0016J\u000e\u0010S\u001a\u00020#2\u0006\u0010T\u001a\u00020\u0014J)\u0010U\u001a\u00020#2!\u0010V\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020#0\u001eJ\u000e\u0010W\u001a\u00020#2\u0006\u0010X\u001a\u00020YJ\u000e\u0010Z\u001a\u00020#2\u0006\u0010[\u001a\u00020\tJ\u000e\u0010\\\u001a\u00020#2\u0006\u0010[\u001a\u00020\tJ\u000e\u0010]\u001a\u00020#2\u0006\u0010^\u001a\u00020\u0019J\u0018\u0010_\u001a\u00020#2\u0006\u0010`\u001a\u00020\t2\b\b\u0002\u0010a\u001a\u00020\u0019J\u0010\u0010b\u001a\u00020#2\b\b\u0001\u0010c\u001a\u00020\tJ\u0010\u0010d\u001a\u00020#2\b\b\u0001\u0010c\u001a\u00020\tJ\u001a\u0010e\u001a\u00020#2\b\b\u0001\u0010f\u001a\u00020,2\b\b\u0002\u0010g\u001a\u00020\u0019J\u000e\u0010h\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0019J\u000e\u0010i\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0019J\u0010\u0010j\u001a\u00020#2\u0006\u0010k\u001a\u00020\fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R+\u0010\u001d\u001a\u001f\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020#\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/devzone/fillprogresslayout/FillProgressLayout;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backRectF", "Landroid/graphics/RectF;", "backgroundPaint", "Landroid/graphics/Paint;", "clipPath", "Landroid/graphics/Path;", "currentProgress", "defBackgroundColor", "defCornerRadius", "", "defDirection", "defDuration", "defDurationFactor", "defGradientMovement", "", "defIsRestart", "defIsRounded", "defProgressColor", "doOnProgressEnd", "Lkotlin/Function1;", "Landroid/view/View;", "Lkotlin/ParameterName;", "name", "v", "", "gradientMovement", "isRestart", "isRounded", "mBackgroundColor", "mCornerRadius", "mDirection", "mDurationFactor", "mGradientColors", "", "mGradientDirection", "mProgressColor", "maxProgress", "oldProgress", "progressPaint", "progressRectF", "applyGradientIfAny", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "drawNormalProgress", "drawRoundedProgress", "getGradientRect", "progressRect", "getProgress", "getSize", "initPaint", "initUI", "isValidRes", "res", "log", "logValue", "", "onDetachedFromWindow", "onDraw", "onSizeChanged", "w", "h", "oldw", "oldh", "setBackground", "background", "Landroid/graphics/drawable/Drawable;", "setBackgroundColor", "color", "setBackgroundDrawable", "setBackgroundResource", "resid", "setCornerRadius", "radius", "setDoOnProgressEnd", "listener", "setDuration", "duration", "", "setFillDirection", "direction", "setGradientDirection", "setGradientMovement", "gradMovement", "setProgress", "inputProgress", "animated", "setProgressBackgroundColor", "resId", "setProgressColor", "setProgressColors", "resIds", "extractResColor", "setRoundedCorners", "shouldStartFromZero", "updateRect", "rectF", "Companion", "fillprogresslayout_release"})
public final class FillProgressLayout
extends LinearLayout {
    private final int maxProgress = 100;
    private final int defDurationFactor = 30;
    private final int defDuration = 3000;
    private final float defCornerRadius = 20.0f;
    private final int defDirection = 0;
    private final int defBackgroundColor = -3355444;
    private final int defProgressColor = -7829368;
    private final boolean defIsRestart = false;
    private final boolean defIsRounded = false;
    private final boolean defGradientMovement = false;
    private boolean isRounded;
    private boolean isRestart;
    private boolean gradientMovement;
    private int mDurationFactor;
    private int mDirection;
    private float mCornerRadius;
    private int mBackgroundColor;
    private int mProgressColor;
    private int mGradientDirection;
    private int[] mGradientColors;
    private int oldProgress;
    private int currentProgress;
    private Paint progressPaint;
    private Paint backgroundPaint;
    private final Path clipPath;
    private RectF progressRectF;
    private RectF backRectF;
    private Function1<? super View, Unit> doOnProgressEnd;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final int TOP_TO_BOTTOM = 2;
    public static final int BOTTOM_TO_TOP = 3;
    public static final int TOP_LEFT_TO_BOTTOM_RIGHT = 4;
    public static final int TOP_RIGHT_TO_BOTTOM_LEFT = 5;
    public static final int BOTTOM_RIGHT_TO_TOP_LEFT = 6;
    public static final int BOTTOM_LEFT_TO_TOP_RIGHT = 7;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void initUI(Context context, AttributeSet attrs) {
        this.setWillNotDraw(false);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            TypedArray typedArray = context.obtainStyledAttributes(it, R.styleable.FillProgressLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026eable.FillProgressLayout)");
            TypedArray array = typedArray;
            if (array.length() > 0) {
                this.mBackgroundColor = array.getColor(R.styleable.FillProgressLayout_fpl_backgroundColor, this.defBackgroundColor);
                this.mProgressColor = array.getColor(R.styleable.FillProgressLayout_fpl_progressColor, this.defProgressColor);
                boolean restart = array.getBoolean(R.styleable.FillProgressLayout_fpl_shouldRestart, this.defIsRestart);
                this.shouldStartFromZero(restart);
                float cornerRadius = array.getFloat(R.styleable.FillProgressLayout_fpl_roundedCornerRadius, this.defCornerRadius);
                this.setCornerRadius(cornerRadius);
                boolean isRounded = array.getBoolean(R.styleable.FillProgressLayout_fpl_isRounded, this.defIsRounded);
                this.setRoundedCorners(isRounded);
                int duration = array.getInt(R.styleable.FillProgressLayout_fpl_progressDuration, this.defDuration);
                this.setDuration(duration);
                int direction = array.getInt(R.styleable.FillProgressLayout_fpl_progressDirection, this.defDirection);
                this.setFillDirection(direction);
                int progress = array.getInt(R.styleable.FillProgressLayout_fpl_progress, this.currentProgress);
                FillProgressLayout.setProgress$default(this, progress, false, 2, null);
                int gradDirection = array.getInt(R.styleable.FillProgressLayout_fpl_gradientDirection, this.defDirection);
                this.setGradientDirection(gradDirection);
                boolean gradMovement = array.getBoolean(R.styleable.FillProgressLayout_fpl_gradientMovement, this.defGradientMovement);
                this.setGradientMovement(gradMovement);
                try {
                    int[] gradColors;
                    int colorsId = array.getResourceId(R.styleable.FillProgressLayout_fpl_gradientColors, 0);
                    int[] nArray = array.getResources().getIntArray(colorsId);
                    Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"array.resources.getIntArray(colorsId)");
                    int[] nArray2 = gradColors = nArray;
                    boolean bl4 = false;
                    int[] nArray3 = nArray2;
                    boolean bl5 = false;
                    if (!(nArray3.length == 0)) {
                        this.setProgressColors(gradColors, false);
                    }
                }
                catch (Exception e) {
                    this.log("Error setting Gradient colors! Use @array/colors or int array of R.color.colorName values");
                }
            }
            array.recycle();
        }
        this.initPaint();
    }

    private final void initPaint() {
        Paint paint = this.backgroundPaint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.mBackgroundColor);
        paint = this.progressPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setStyle(Paint.Style.FILL);
        int[] nArray = this.mGradientColors;
        Paint paint2 = $this$apply;
        boolean bl5 = false;
        boolean bl6 = nArray.length == 0;
        paint2.setColor(bl6 ? this.mProgressColor : -16777216);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.backRectF = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.progressRectF = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.progressRectF.bottom = h;
        this.updateRect(this.progressRectF);
        if (this.isRounded) {
            this.clipPath.addRoundRect(this.backRectF, this.mCornerRadius, this.mCornerRadius, Path.Direction.CW);
            this.clipPath.close();
        }
    }

    private final int getProgress() {
        return this.getSize() * this.currentProgress / 100;
    }

    private final int getSize() {
        return this.mDirection == 0 || this.mDirection == 1 ? this.getWidth() : this.getHeight();
    }

    private final void updateRect(RectF rectF) {
        switch (this.mDirection) {
            case 0: {
                rectF.right = this.getProgress();
                break;
            }
            case 1: {
                rectF.left = (float)this.getSize() - (float)this.getProgress();
                break;
            }
            case 2: {
                rectF.bottom = this.getProgress();
                break;
            }
            case 3: {
                rectF.top = (float)this.getSize() - (float)this.getProgress();
            }
        }
    }

    protected void onDraw(@Nullable Canvas canvas) {
        if (this.isRounded) {
            this.drawRoundedProgress(canvas);
        } else {
            this.drawNormalProgress(canvas);
        }
        super.onDraw(canvas);
    }

    private final void drawNormalProgress(Canvas canvas) {
        block0: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            Canvas canvas3 = canvas2;
            boolean bl = false;
            boolean bl2 = false;
            Canvas $this$apply = canvas3;
            boolean bl3 = false;
            $this$apply.drawRect(this.backRectF, this.backgroundPaint);
            this.applyGradientIfAny();
            $this$apply.drawRect(this.progressRectF, this.progressPaint);
        }
    }

    private final void drawRoundedProgress(Canvas canvas) {
        block0: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            Canvas canvas3 = canvas2;
            boolean bl = false;
            boolean bl2 = false;
            Canvas $this$apply = canvas3;
            boolean bl3 = false;
            $this$apply.save();
            $this$apply.drawRoundRect(this.backRectF, this.mCornerRadius, this.mCornerRadius, this.backgroundPaint);
            $this$apply.clipPath(this.clipPath);
            this.applyGradientIfAny();
            $this$apply.drawRect(this.progressRectF, this.progressPaint);
            $this$apply.restore();
        }
    }

    private final void applyGradientIfAny() {
        int[] nArray = this.mGradientColors;
        boolean bl = false;
        int[] nArray2 = nArray;
        boolean bl2 = false;
        if (!(nArray2.length == 0)) {
            RectF gradientRect = this.getGradientRect(this.gradientMovement ? this.progressRectF : this.backRectF);
            this.progressPaint.setShader((Shader)new LinearGradient(gradientRect.left, gradientRect.top, gradientRect.right, gradientRect.bottom, this.mGradientColors, null, Shader.TileMode.MIRROR));
        }
    }

    private final boolean isValidRes(int res) {
        return res != -1;
    }

    protected void onDetachedFromWindow() {
        this.clearAnimation();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(@Nullable Canvas canvas) {
        if (this.isRounded) {
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.clipPath(this.clipPath);
            }
        }
        super.dispatchDraw(canvas);
    }

    public final void setProgress(int inputProgress, boolean animated) {
        int n = inputProgress;
        if (0 <= n && this.maxProgress >= n) {
            this.clearAnimation();
            if (animated) {
                ValueAnimator animator;
                ValueAnimator valueAnimator = animator = ValueAnimator.ofInt((int[])new int[]{this.oldProgress, inputProgress});
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
                valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                    final /* synthetic */ FillProgressLayout this$0;

                    public final void onAnimationUpdate(ValueAnimator anm) {
                        ValueAnimator valueAnimator = anm;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"anm");
                        Object object = valueAnimator.getAnimatedValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                        }
                        FillProgressLayout.access$setCurrentProgress$p(this.this$0, (Integer)object);
                        FillProgressLayout.access$updateRect(this.this$0, FillProgressLayout.access$getProgressRectF$p(this.this$0));
                        ViewCompat.postInvalidateOnAnimation((View)((View)this.this$0));
                    }
                    {
                        this.this$0 = fillProgressLayout;
                    }
                });
                Animator $this$doOnEnd$iv = (Animator)animator;
                boolean $i$f$doOnEnd = false;
                Animator $this$addListener$iv$iv = $this$doOnEnd$iv;
                boolean $i$f$addListener = false;
                Animator.AnimatorListener listener$iv$iv = new Animator.AnimatorListener(this, inputProgress){
                    final /* synthetic */ FillProgressLayout this$0;
                    final /* synthetic */ int $inputProgress$inlined;
                    {
                        this.this$0 = fillProgressLayout;
                        this.$inputProgress$inlined = n;
                    }

                    public void onAnimationRepeat(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                    }

                    public void onAnimationEnd(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                        boolean bl = false;
                        Function1 function1 = FillProgressLayout.access$getDoOnProgressEnd$p(this.this$0);
                        if (function1 != null) {
                            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)((Object)this.this$0));
                        }
                        if (!FillProgressLayout.access$isRestart$p(this.this$0)) {
                            FillProgressLayout.access$setOldProgress$p(this.this$0, this.$inputProgress$inlined);
                        }
                    }

                    public void onAnimationCancel(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                    }

                    public void onAnimationStart(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                    }
                };
                $this$addListener$iv$iv.addListener(listener$iv$iv);
                int n2 = inputProgress - this.oldProgress;
                ValueAnimator valueAnimator2 = animator;
                boolean bl = false;
                int n3 = Math.abs(n2);
                valueAnimator2.setDuration((long)(n3 * this.mDurationFactor)).start();
            } else {
                this.currentProgress = inputProgress;
                this.updateRect(this.progressRectF);
                Function1<? super View, Unit> function1 = this.doOnProgressEnd;
                if (function1 != null) {
                    Unit cfr_ignored_1 = (Unit)function1.invoke((Object)this);
                }
                ViewCompat.postInvalidateOnAnimation((View)((View)this));
            }
        }
    }

    public static /* synthetic */ void setProgress$default(FillProgressLayout fillProgressLayout, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        fillProgressLayout.setProgress(n, bl);
    }

    public final void setProgressBackgroundColor(@ColorRes int resId) {
        if (this.isValidRes(resId)) {
            this.mBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)resId);
            this.initPaint();
        }
    }

    public final void setProgressColor(@ColorRes int resId) {
        if (this.isValidRes(resId)) {
            this.mProgressColor = ContextCompat.getColor((Context)this.getContext(), (int)resId);
            this.initPaint();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setProgressColors(@ColorRes @NotNull int[] resIds, boolean extractResColor) {
        Intrinsics.checkParameterIsNotNull((Object)resIds, (String)"resIds");
        try {
            void $this$filterTo$iv$iv;
            int[] $this$filter$iv = resIds;
            boolean $i$f$filter = false;
            int[] nArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (int element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                if (!this.isValidRes((int)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filtered = (List)destination$iv$iv;
            this.mGradientColors = new int[filtered.size()];
            Iterable $this$forEachIndexed$iv = filtered;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void i;
                int element$iv$iv;
                int n = index$iv++;
                int n2 = 0;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n3 = n;
                element$iv$iv = ((Number)item$iv).intValue();
                int index = n3;
                boolean bl = false;
                this.mGradientColors[index] = extractResColor ? ContextCompat.getColor((Context)this.getContext(), (int)i) : i;
            }
            this.initPaint();
        }
        catch (Exception e) {
            this.log("Cannot use current color values!! Use integer array of R.color.colorName values");
        }
    }

    public static /* synthetic */ void setProgressColors$default(FillProgressLayout fillProgressLayout, int[] nArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        fillProgressLayout.setProgressColors(nArray, bl);
    }

    public final void setCornerRadius(float radius) {
        float f = this.maxProgress;
        float f2 = radius;
        if (f2 >= 0.0f && f2 <= f) {
            this.setRoundedCorners(true);
            this.mCornerRadius = radius;
        }
    }

    public final void setRoundedCorners(boolean isRounded) {
        this.isRounded = isRounded;
    }

    public final void setGradientMovement(boolean gradMovement) {
        this.gradientMovement = gradMovement;
    }

    public final void setDuration(long duration) {
        if ((int)duration == 0 || duration < 0L) {
            return;
        }
        this.mDurationFactor = (int)(duration / (long)100);
    }

    public final void shouldStartFromZero(boolean isRestart) {
        this.isRestart = isRestart;
    }

    public final void setFillDirection(int direction) {
        int n = direction;
        this.mDirection = 0 <= n && 3 >= n ? direction : this.defDirection;
    }

    public final void setGradientDirection(int direction) {
        int n = direction;
        this.mGradientDirection = 0 <= n && 7 >= n ? direction : this.defDirection;
    }

    public final void setDoOnProgressEnd(@NotNull Function1<? super View, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.doOnProgressEnd = listener;
    }

    private final RectF getGradientRect(RectF progressRect) {
        RectF outRect = new RectF(progressRect);
        switch (this.mGradientDirection) {
            case 0: {
                outRect.left = progressRect.left;
                outRect.top = progressRect.centerY();
                outRect.right = progressRect.right;
                outRect.bottom = progressRect.centerY();
                break;
            }
            case 2: {
                outRect.left = progressRect.centerX();
                outRect.top = progressRect.top;
                outRect.right = progressRect.centerX();
                outRect.bottom = progressRect.bottom;
                break;
            }
            case 1: {
                outRect.left = progressRect.right;
                outRect.top = progressRect.centerY();
                outRect.right = progressRect.left;
                outRect.bottom = progressRect.centerY();
                break;
            }
            case 3: {
                outRect.left = progressRect.centerX();
                outRect.top = progressRect.bottom;
                outRect.right = progressRect.centerX();
                outRect.bottom = progressRect.top;
                break;
            }
            case 4: {
                outRect.left = progressRect.left;
                outRect.top = progressRect.top;
                outRect.right = progressRect.right;
                outRect.bottom = progressRect.bottom;
                break;
            }
            case 5: {
                outRect.left = progressRect.right;
                outRect.top = progressRect.top;
                outRect.right = progressRect.left;
                outRect.bottom = progressRect.bottom;
                break;
            }
            case 6: {
                outRect.left = progressRect.right;
                outRect.top = progressRect.bottom;
                outRect.right = progressRect.left;
                outRect.bottom = progressRect.top;
                break;
            }
            case 7: {
                outRect.left = progressRect.left;
                outRect.top = progressRect.bottom;
                outRect.right = progressRect.right;
                outRect.bottom = progressRect.top;
            }
        }
        return outRect;
    }

    public void setBackground(@Nullable Drawable background) {
    }

    public void setBackgroundColor(int color) {
    }

    public void setBackgroundResource(int resid) {
    }

    public void setBackgroundDrawable(@Nullable Drawable background) {
    }

    private final void log(String logValue) {
    }

    public FillProgressLayout(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.maxProgress = 100;
        this.defDurationFactor = 30;
        this.defDuration = this.defDurationFactor * 100;
        this.defCornerRadius = 20.0f;
        this.defBackgroundColor = -3355444;
        this.defProgressColor = -7829368;
        this.isRounded = this.defIsRounded;
        this.isRestart = this.defIsRestart;
        this.gradientMovement = this.defGradientMovement;
        this.mDurationFactor = this.defDurationFactor;
        this.mDirection = this.defDirection;
        this.mCornerRadius = this.defCornerRadius;
        this.mBackgroundColor = this.defBackgroundColor;
        this.mProgressColor = this.defProgressColor;
        this.mGradientDirection = this.defDirection;
        this.mGradientColors = new int[0];
        this.progressPaint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        this.clipPath = new Path();
        this.progressRectF = new RectF();
        this.backRectF = new RectF();
        this.initUI(context, null);
    }

    public FillProgressLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.maxProgress = 100;
        this.defDurationFactor = 30;
        this.defDuration = this.defDurationFactor * 100;
        this.defCornerRadius = 20.0f;
        this.defBackgroundColor = -3355444;
        this.defProgressColor = -7829368;
        this.isRounded = this.defIsRounded;
        this.isRestart = this.defIsRestart;
        this.gradientMovement = this.defGradientMovement;
        this.mDurationFactor = this.defDurationFactor;
        this.mDirection = this.defDirection;
        this.mCornerRadius = this.defCornerRadius;
        this.mBackgroundColor = this.defBackgroundColor;
        this.mProgressColor = this.defProgressColor;
        this.mGradientDirection = this.defDirection;
        this.mGradientColors = new int[0];
        this.progressPaint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        this.clipPath = new Path();
        this.progressRectF = new RectF();
        this.backRectF = new RectF();
        this.initUI(context, attrs);
    }

    public FillProgressLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.maxProgress = 100;
        this.defDurationFactor = 30;
        this.defDuration = this.defDurationFactor * 100;
        this.defCornerRadius = 20.0f;
        this.defBackgroundColor = -3355444;
        this.defProgressColor = -7829368;
        this.isRounded = this.defIsRounded;
        this.isRestart = this.defIsRestart;
        this.gradientMovement = this.defGradientMovement;
        this.mDurationFactor = this.defDurationFactor;
        this.mDirection = this.defDirection;
        this.mCornerRadius = this.defCornerRadius;
        this.mBackgroundColor = this.defBackgroundColor;
        this.mProgressColor = this.defProgressColor;
        this.mGradientDirection = this.defDirection;
        this.mGradientColors = new int[0];
        this.progressPaint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        this.clipPath = new Path();
        this.progressRectF = new RectF();
        this.backRectF = new RectF();
        this.initUI(context, attrs);
    }

    public static final /* synthetic */ int access$getCurrentProgress$p(FillProgressLayout $this) {
        return $this.currentProgress;
    }

    public static final /* synthetic */ void access$setCurrentProgress$p(FillProgressLayout $this, int n) {
        $this.currentProgress = n;
    }

    public static final /* synthetic */ void access$updateRect(FillProgressLayout $this, RectF rectF) {
        $this.updateRect(rectF);
    }

    public static final /* synthetic */ RectF access$getProgressRectF$p(FillProgressLayout $this) {
        return $this.progressRectF;
    }

    public static final /* synthetic */ void access$setProgressRectF$p(FillProgressLayout $this, RectF rectF) {
        $this.progressRectF = rectF;
    }

    public static final /* synthetic */ Function1 access$getDoOnProgressEnd$p(FillProgressLayout $this) {
        return $this.doOnProgressEnd;
    }

    public static final /* synthetic */ void access$setDoOnProgressEnd$p(FillProgressLayout $this, Function1 function1) {
        $this.doOnProgressEnd = function1;
    }

    public static final /* synthetic */ boolean access$isRestart$p(FillProgressLayout $this) {
        return $this.isRestart;
    }

    public static final /* synthetic */ void access$setRestart$p(FillProgressLayout $this, boolean bl) {
        $this.isRestart = bl;
    }

    public static final /* synthetic */ int access$getOldProgress$p(FillProgressLayout $this) {
        return $this.oldProgress;
    }

    public static final /* synthetic */ void access$setOldProgress$p(FillProgressLayout $this, int n) {
        $this.oldProgress = n;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/devzone/fillprogresslayout/FillProgressLayout$Companion;", "", "()V", "BOTTOM_LEFT_TO_TOP_RIGHT", "", "BOTTOM_RIGHT_TO_TOP_LEFT", "BOTTOM_TO_TOP", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "TOP_LEFT_TO_BOTTOM_RIGHT", "TOP_RIGHT_TO_BOTTOM_LEFT", "TOP_TO_BOTTOM", "fillprogresslayout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

