/*
 * Decompiled with CFR 0.152.
 */
package com.intrusoft.scatter;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.intrusoft.scatter.ChartData;
import com.intrusoft.scatter.ChartHelper;
import com.intrusoft.scatter.ChartUtils;
import com.intrusoft.scatter.R;
import java.util.List;

public class SimpleChart
extends View {
    private final String LOGTAG = "Scatter";
    private List<ChartData> chartData;
    private float width;
    private float height;
    private List<ChartUtils> chartUtils;
    private Paint paint;
    private Paint textPaint;
    private float cx;
    private float cy;
    private int color;
    private int textColor;
    private float side;
    private int alpha = 255;
    private float animateValue = -1.0f;
    private boolean withPercent;
    private String aboutChart;
    private int aboutTextColor;

    public SimpleChart(Context context) {
        super(context);
        this.init(context, null);
    }

    public SimpleChart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SimpleChart(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.PieChart);
            try {
                this.textColor = array.getColor(R.styleable.PieChart_textColor, -12303292);
                this.color = array.getColor(R.styleable.PieChart_chartColor, -3355444);
                this.aboutChart = array.getString(R.styleable.PieChart_aboutChart);
                this.withPercent = !array.getBoolean(R.styleable.PieChart_equalPartition, false);
                this.aboutTextColor = array.getInt(R.styleable.PieChart_aboutTextColor, -12303292);
            }
            finally {
                array.recycle();
            }
        }
        this.paint = new Paint(1);
        this.textPaint = new Paint(1);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.width = this.getMeasuredWidth();
        this.height = this.getMeasuredHeight();
        this.side = Math.min(this.width, this.height);
        this.cx = this.width / 2.0f;
        this.cy = this.height / 2.0f;
        if (this.chartData != null) {
            this.chartUtils = this.withPercent ? ChartHelper.generateSimpleRadiusWithPercent(this.chartData, (int)this.side) : ChartHelper.generateSimpleRadius(this.chartData, (int)this.side);
            this.alpha = 255 / this.chartData.size();
            this.color = Color.argb((int)this.alpha, (int)Color.red((int)this.color), (int)Color.green((int)this.color), (int)Color.blue((int)this.color));
        } else {
            Log.e((String)"Scatter", (String)"Simple Pie chart must have chart Data");
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.chartData != null && this.chartData.size() != 0) {
            if (this.animateValue >= 0.0f) {
                for (int i = this.chartData.size() - 1; i >= 0; --i) {
                    this.textPaint.setTextSize(this.chartUtils.get(i).getTextSize());
                    if (this.chartData.get(i).getBackgroundColor() != 0) {
                        this.paint.setColor(this.chartData.get(i).getBackgroundColor());
                    } else {
                        this.paint.setColor(this.color);
                    }
                    if (this.chartData.get(i).getTextColor() != 0) {
                        this.textPaint.setColor(this.chartData.get(i).getTextColor());
                    } else {
                        this.textPaint.setColor(this.textColor);
                    }
                    if (this.animateValue <= this.chartUtils.get(i).getRadius()) {
                        canvas.drawCircle(this.cx, this.cy, this.animateValue, this.paint);
                        if (i == this.chartData.size() - 1 && this.animateValue == this.chartUtils.get(i).getRadius()) {
                            canvas.drawTextOnPath(this.chartData.get(i).getDisplayText(), this.getPath(this.chartUtils.get(i).getRadius()), 0.0f, this.chartUtils.get(i).getOffset(), this.textPaint);
                        }
                    } else {
                        canvas.drawCircle(this.cx, this.cy, this.chartUtils.get(i).getRadius(), this.paint);
                        canvas.drawTextOnPath(this.chartData.get(i).getDisplayText(), this.getPath(this.chartUtils.get(i).getRadius()), 0.0f, this.chartUtils.get(i).getOffset(), this.textPaint);
                    }
                    if (this.aboutChart == null) continue;
                    this.textPaint.setColor(this.aboutTextColor);
                    this.textPaint.setTextSize(this.chartUtils.get(0).getTextSize());
                    canvas.drawText(this.aboutChart, this.cx, this.cy, this.textPaint);
                }
            } else {
                this.animateChart();
            }
        }
    }

    private Path getPath(float radius) {
        RectF oval = new RectF(this.cx - radius, this.cy - radius, this.cx + radius, this.cy + radius);
        Path path = new Path();
        path.addArc(oval, 90.0f, 350.0f);
        return path;
    }

    public void animateChart() {
        this.animateValue = 0.0f;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.chartUtils.get(this.chartData.size() - 1).getRadius()});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SimpleChart.this.animateValue = ((Float)animation.getAnimatedValue()).floatValue();
                SimpleChart.this.invalidate();
            }
        });
        animator.setDuration(1000L);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.start();
    }

    public List<ChartData> getChartData() {
        return this.chartData;
    }

    public int getColor() {
        return this.color;
    }

    public void setChartData(List<ChartData> chartData) {
        this.chartData = chartData;
        this.animateValue = -1.0f;
        this.invalidate();
    }

    public void setChartColor(int color) {
        this.color = color;
        this.invalidate();
    }

    public void setTextColor(int color) {
        this.textColor = color;
        this.invalidate();
    }

    public void setTextTypeFace(Typeface typeFace) {
        this.textPaint.setTypeface(typeFace);
        this.invalidate();
    }

    public void partitionWithPercent(boolean withPercent) {
        this.withPercent = withPercent;
        this.chartUtils = withPercent ? ChartHelper.generateSimpleRadiusWithPercent(this.chartData, (int)this.side) : ChartHelper.generateSimpleRadius(this.chartData, (int)this.side);
        this.animateValue = -1.0f;
        this.invalidate();
    }
}

