/*
 * Decompiled with CFR 0.152.
 */
package com.intrusoft.scatter;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.intrusoft.scatter.ChartData;
import com.intrusoft.scatter.ChartHelper;
import com.intrusoft.scatter.ChartUtils;
import com.intrusoft.scatter.R;
import java.util.List;

public class PieChart
extends View {
    private List<ChartData> chartData;
    private List<ChartUtils> chartUtils;
    private Paint paint;
    private Paint textPaint;
    private float cx;
    private float cy;
    private int color;
    private int textColor;
    private int centerColor;
    private float textSize;
    private float side;
    private int alpha = 255;
    private int aboutTextColor;
    private float animateValue = -1.0f;
    private boolean withPercent;
    private String aboutChart;
    private float aboutTextSize;

    public PieChart(Context context) {
        super(context);
        this.init(context, null);
    }

    public PieChart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PieChart(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.PieChart);
            try {
                this.textColor = array.getColor(R.styleable.PieChart_textColor, -12303292);
                this.color = array.getColor(R.styleable.PieChart_chartColor, -3355444);
                this.centerColor = array.getColor(R.styleable.PieChart_centerColor, -1);
                this.aboutChart = array.getString(R.styleable.PieChart_aboutChart);
                this.textSize = array.getFloat(R.styleable.PieChart_textSize, 25.0f);
                this.aboutTextSize = array.getFloat(R.styleable.PieChart_aboutTextSize, 20.0f);
                this.withPercent = !array.getBoolean(R.styleable.PieChart_equalPartition, false);
                this.aboutTextColor = array.getInt(R.styleable.PieChart_aboutTextColor, -12303292);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                array.recycle();
            }
        }
        this.paint = new Paint(1);
        this.textPaint = new Paint(1);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float width = this.getMeasuredWidth();
        float height = this.getMeasuredHeight();
        this.side = Math.min(width, height);
        this.cx = width / 2.0f;
        this.cy = height / 2.0f;
        String LOGCAT = "Scatter";
        this.paint.setColor(this.centerColor);
        if (this.chartData != null) {
            if (this.withPercent) {
                int i;
                float value = 0.0f;
                for (i = 0; i < this.chartData.size() && !((value += this.chartData.get(i).getPartInPercent()) > 100.0f); ++i) {
                }
                if (i < this.chartData.size()) {
                    Log.e((String)LOGCAT, (String)"Invalid Chart Data. Sum of data percent must be less than or equal to 100");
                } else {
                    this.chartUtils = ChartHelper.generateArcWithPercent(this.chartData);
                }
            } else {
                this.chartUtils = ChartHelper.generateArc(this.chartData);
            }
            this.alpha = 255 / this.chartData.size();
            this.textPaint.setTextSize(this.textSize);
        } else {
            Log.e((String)LOGCAT, (String)"Simple Pie chart must have chart Data");
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.chartUtils != null && this.chartUtils.size() != 0) {
            float r = this.side / 2.0f;
            RectF rectF = new RectF(this.cx - r, this.cy - r, this.cx + r, this.cy + r);
            RectF rectC = new RectF(this.cx - r * 0.4f, this.cy - r * 0.4f, this.cx + r * 0.4f, this.cy + r * 0.4f);
            RectF rectC1 = new RectF(this.cx - r * 0.5f, this.cy - r * 0.5f, this.cx + r * 0.5f, this.cy + r * 0.5f);
            if (this.animateValue >= 0.0f) {
                for (int i = this.chartData.size() - 1; i >= 0; --i) {
                    int y;
                    int x;
                    double rad;
                    double per;
                    int color = Color.argb((int)this.alpha, (int)Color.red((int)this.color), (int)Color.green((int)this.color), (int)Color.blue((int)this.color));
                    int textColor = this.textColor;
                    if (this.chartData.get(i).getBackgroundColor() != 0) {
                        this.paint.setColor(this.chartData.get(i).getBackgroundColor());
                    } else {
                        this.paint.setColor(color);
                    }
                    if (this.chartData.get(i).getTextColor() != 0) {
                        this.textPaint.setColor(this.chartData.get(i).getTextColor());
                    } else {
                        this.textPaint.setColor(textColor);
                    }
                    if (this.animateValue <= this.chartUtils.get(i).getRadius()) {
                        canvas.drawArc(rectF, 0.0f, this.animateValue, true, this.paint);
                        if (i == this.chartUtils.size() - 1 && this.animateValue == this.chartUtils.get(i).getRadius()) {
                            per = this.withPercent ? (double)(this.chartUtils.get(i).getRadius() - this.chartData.get(i).getPartInPercent() * 1.8f) : (double)(this.chartUtils.get(i).getRadius() - (float)(100 / this.chartData.size()) * 1.8f);
                            rad = per * Math.PI / 180.0;
                            x = (int)((double)this.cx + (double)r * 0.7 * Math.cos(rad));
                            y = (int)((double)this.cy + (double)r * 0.7 * Math.sin(rad));
                            Log.d((String)("x: " + x + " ,y: " + per), (String)("i: " + i + " ->" + this.chartUtils.get(i).getRadius()));
                            canvas.drawText(this.chartData.get(i).getDisplayText(), (float)x, (float)y, this.textPaint);
                        }
                    } else {
                        canvas.drawArc(rectF, 0.0f, this.chartUtils.get(i).getRadius(), true, this.paint);
                        per = this.withPercent ? (double)(this.chartUtils.get(i).getRadius() - this.chartData.get(i).getPartInPercent() * 1.8f) : (double)(this.chartUtils.get(i).getRadius() - (float)(100 / this.chartData.size()) * 1.8f);
                        rad = per * Math.PI / 180.0;
                        x = (int)((double)this.cx + (double)r * 0.7 * Math.cos(rad));
                        y = (int)((double)this.cy + (double)r * 0.7 * Math.sin(rad));
                        Log.d((String)("x: " + x + " ,y: " + per), (String)("i: " + i + " ->" + this.chartUtils.get(i).getRadius()));
                        canvas.drawText(this.chartData.get(i).getDisplayText(), (float)x, (float)y, this.textPaint);
                    }
                    this.paint.setColor(Color.argb((int)88, (int)Color.red((int)this.centerColor), (int)Color.green((int)this.centerColor), (int)Color.blue((int)this.centerColor)));
                    canvas.drawArc(rectC1, 0.0f, this.animateValue, true, this.paint);
                    this.paint.setColor(Color.rgb((int)Color.red((int)this.centerColor), (int)Color.green((int)this.centerColor), (int)Color.blue((int)this.centerColor)));
                    canvas.drawArc(rectC, 0.0f, this.animateValue, true, this.paint);
                    if (this.aboutChart == null) continue;
                    this.textPaint.setTextSize(this.aboutTextSize);
                    this.textPaint.setColor(this.aboutTextColor);
                    canvas.drawText(this.aboutChart, this.cx, this.cy, this.textPaint);
                }
            } else {
                this.animateChart();
            }
        }
    }

    public void animateChart() {
        this.animateValue = 0.0f;
        if (this.chartUtils != null) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.chartUtils.get(this.chartUtils.size() - 1).getRadius()});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    PieChart.this.animateValue = ((Float)animation.getAnimatedValue()).floatValue();
                    PieChart.this.invalidate();
                }
            });
            animator.setDuration(1000L);
            animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            animator.start();
        }
    }

    public void setChartData(List<ChartData> chartData) {
        this.chartData = chartData;
        this.animateValue = -1.0f;
        this.invalidate();
    }

    public void setChartColor(int color) {
        this.color = color;
        this.invalidate();
    }

    public void setTextColor(int color) {
        this.textColor = color;
        this.invalidate();
    }

    public void setTextTypeFace(Typeface typeFace) {
        this.textPaint.setTypeface(typeFace);
        this.invalidate();
    }

    public void partitionWithPercent(boolean withPercent) {
        this.withPercent = withPercent;
        this.chartUtils = withPercent ? ChartHelper.generateArcWithPercent(this.chartData) : ChartHelper.generateArc(this.chartData);
        this.animateValue = -1.0f;
        this.invalidate();
    }

    public void setCenterCircleColor(int color) {
        this.centerColor = color;
    }

    public void setAboutChart(String aboutChart) {
        this.aboutChart = aboutChart;
    }
}

