/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview.scroll;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.infomaniak.lib.pdfview.PDFView;
import com.infomaniak.lib.pdfview.R;
import com.infomaniak.lib.pdfview.scroll.ScrollHandle;
import com.infomaniak.lib.pdfview.util.TouchUtils;
import com.infomaniak.lib.pdfview.util.Util;

public class DefaultScrollHandle
extends RelativeLayout
implements ScrollHandle {
    private static final int HANDLE_WIDTH = 65;
    private static final int HANDLE_HEIGHT = 40;
    private static final int NO_ALIGN = -1;
    private static final int TOUCH_POINTER_COUNT = 1;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final boolean inverted;
    private final Runnable hidePageScrollerRunnable = this::hide;
    protected TextView pageIndicator;
    protected Context context;
    private float relativeHandlerMiddle = 0.0f;
    private PDFView pdfView;
    private float currentPos;
    private Drawable handleBackgroundDrawable;
    private View handleView;
    private int handleAlign;
    private int handleWidth = 65;
    private int handleHeight = 40;
    private int handlePaddingLeft = 0;
    private int handlePaddingTop = 0;
    private int handlePaddingRight = 0;
    private int handlePaddingBottom = 0;
    private int hideHandleDelayMillis = 1000;
    private boolean hasStartedDragging = false;
    private int textColorResId = -1;
    private int textSize = -1;

    public DefaultScrollHandle(Context context) {
        this(context, false);
    }

    public DefaultScrollHandle(Context context, boolean inverted) {
        super(context);
        this.context = context;
        this.inverted = inverted;
    }

    @Override
    public void setupLayout(PDFView pdfView) {
        this.setHandleRelativePosition(pdfView);
        this.setHandleView();
        pdfView.addView((View)this);
        this.pdfView = pdfView;
    }

    private void setHandleRelativePosition(PDFView pdfView) {
        if (pdfView.isSwipeVertical()) {
            this.handleAlign = this.inverted ? 9 : 11;
        } else {
            int tempWidth = this.handleWidth;
            this.handleWidth = this.handleHeight;
            this.handleHeight = tempWidth;
            this.handleAlign = this.inverted ? 10 : 12;
        }
    }

    private void setHandleView() {
        if (this.handleView != null) {
            this.initViewWithCustomView();
        } else {
            this.initDefaultView(this.handleBackgroundDrawable);
        }
        this.setVisibility(4);
        if (this.pageIndicator != null) {
            if (this.textColorResId != -1) {
                this.pageIndicator.setTextColor(this.textColorResId);
            }
            if (this.textSize != -1) {
                this.pageIndicator.setTextSize(1, (float)this.textSize);
            }
        }
    }

    private void initDefaultView(Drawable drawable2) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        View view = layoutInflater.inflate(R.layout.default_handle, null);
        this.pageIndicator = (TextView)view.findViewById(R.id.pageIndicator);
        this.pageIndicator.setBackground(drawable2 != null ? drawable2 : this.getDefaultHandleBackgroundDrawable());
        this.addView(view, (ViewGroup.LayoutParams)this.getCustomViewLayoutParams());
        this.setRootLayoutParams();
    }

    private RelativeLayout.LayoutParams getCustomViewLayoutParams() {
        return this.getLayoutParams(Util.getDP(this.context, this.handleWidth), Util.getDP(this.context, this.handleHeight), -1, true);
    }

    private void initViewWithCustomView() {
        if (this.handleView.getParent() != null) {
            this.removeView(this.handleView);
        }
        this.addView(this.handleView, (ViewGroup.LayoutParams)this.getCustomViewLayoutParams());
        this.setRootLayoutParams();
    }

    private Drawable getDefaultHandleBackgroundDrawable() {
        int drawableResId = switch (this.handleAlign) {
            case 9 -> R.drawable.default_scroll_handle_left;
            case 11 -> R.drawable.default_scroll_handle_right;
            case 10 -> R.drawable.default_scroll_handle_top;
            default -> R.drawable.default_scroll_handle_bottom;
        };
        return this.getDrawable(drawableResId);
    }

    private RelativeLayout.LayoutParams getLayoutParams(int width, int height, int align, boolean withPadding) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(width, height);
        if (align != -1) {
            layoutParams.addRule(align);
        }
        if (withPadding) {
            layoutParams.setMargins(Util.getDP(this.context, this.handlePaddingLeft), Util.getDP(this.context, this.handlePaddingTop), Util.getDP(this.context, this.handlePaddingRight), Util.getDP(this.context, this.handlePaddingBottom));
        }
        return layoutParams;
    }

    private void setRootLayoutParams() {
        this.setLayoutParams((ViewGroup.LayoutParams)this.getLayoutParams(-2, -2, this.handleAlign, false));
    }

    private Drawable getDrawable(int resDrawable) {
        return ContextCompat.getDrawable((Context)this.context, (int)resDrawable);
    }

    @Override
    public void destroyLayout() {
        this.pdfView.removeView((View)this);
    }

    @Override
    public void setScroll(float position) {
        if (!this.shown()) {
            this.show();
        } else {
            this.handler.removeCallbacks(this.hidePageScrollerRunnable);
        }
        if (this.pdfView != null) {
            this.setPosition((float)(this.pdfView.isSwipeVertical() ? this.pdfView.getHeight() : this.pdfView.getWidth()) * position);
        }
    }

    private void setPosition(float pos) {
        int handleSize;
        float pdfViewSize;
        if (Float.isInfinite(pos) || Float.isNaN(pos)) {
            return;
        }
        if (this.pdfView.isSwipeVertical()) {
            pdfViewSize = this.pdfView.getHeight();
            handleSize = this.handleHeight;
        } else {
            pdfViewSize = this.pdfView.getWidth();
            handleSize = this.handleWidth;
        }
        pos -= this.relativeHandlerMiddle;
        float maxBound = pdfViewSize - (float)Util.getDP(this.context, handleSize) - (float)this.getPaddings();
        if (pos < 0.0f) {
            pos = 0.0f;
        } else if (pos > maxBound) {
            pos = maxBound;
        }
        if (this.pdfView.isSwipeVertical()) {
            this.setY(pos);
        } else {
            this.setX(pos);
        }
        this.calculateMiddle();
        this.invalidate();
    }

    private int getPaddings() {
        int paddings = switch (this.handleAlign) {
            case 9, 11 -> this.handlePaddingTop + this.handlePaddingBottom;
            case 10, 12 -> this.handlePaddingLeft + this.handlePaddingRight;
            default -> 0;
        };
        return Util.getDP(this.context, paddings);
    }

    private void calculateMiddle() {
        float pdfViewSize;
        float viewSize;
        float pos;
        if (this.pdfView.isSwipeVertical()) {
            pos = this.getY();
            viewSize = this.getHeight();
            pdfViewSize = this.pdfView.getHeight();
        } else {
            pos = this.getX();
            viewSize = this.getWidth();
            pdfViewSize = this.pdfView.getWidth();
        }
        this.relativeHandlerMiddle = (pos + this.relativeHandlerMiddle) / pdfViewSize * viewSize;
    }

    @Override
    public void hideDelayed() {
        this.handler.postDelayed(this.hidePageScrollerRunnable, (long)this.hideHandleDelayMillis);
    }

    @Override
    public void setPageNum(int pageNum) {
        String text = String.valueOf(pageNum);
        if (this.pageIndicator != null && !this.pageIndicator.getText().equals(text)) {
            this.pageIndicator.setText((CharSequence)text);
        }
    }

    @Override
    public boolean shown() {
        return this.getVisibility() == 0;
    }

    @Override
    public void show() {
        this.setVisibility(0);
    }

    @Override
    public void hide() {
        this.setVisibility(4);
    }

    public void setTextColor(int color) {
        this.textColorResId = color;
    }

    public void setTextSize(int size) {
        this.textSize = size;
    }

    public void setPageHandleBackground(Drawable handleBackgroundDrawable) {
        this.handleBackgroundDrawable = handleBackgroundDrawable;
    }

    public void setPageHandleView(View handleView, TextView pageIndicator) {
        this.handleView = handleView;
        this.pageIndicator = pageIndicator;
    }

    public void setHandleSize(int handleWidth, int handleHeight) {
        this.handleWidth = handleWidth;
        this.handleHeight = handleHeight;
    }

    public void setHandlePaddings(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.handlePaddingLeft = paddingLeft;
        this.handlePaddingTop = paddingTop;
        this.handlePaddingRight = paddingRight;
        this.handlePaddingBottom = paddingBottom;
    }

    public void setHideHandleDelay(int hideHandleDelayMillis) {
        this.hideHandleDelayMillis = hideHandleDelayMillis;
    }

    private boolean isPDFViewReady() {
        return this.pdfView != null && this.pdfView.getPageCount() > 0 && !this.pdfView.documentFitsView();
    }

    private View getTouchedView(MotionEvent event) {
        int x = Math.round(event.getX());
        int y = Math.round(event.getY());
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (x <= child.getLeft() || x >= child.getRight() || y <= child.getTop() || y >= child.getBottom()) continue;
            return child;
        }
        return null;
    }

    private boolean shouldIgnoreTouch(MotionEvent event) {
        View touchedView = this.getTouchedView(event);
        if (this.hasStartedDragging) {
            return false;
        }
        if (touchedView != null) {
            Object tag = touchedView.getTag();
            return tag != null && !tag.toString().equals("rootHandle");
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isPDFViewReady() || this.shouldIgnoreTouch(event)) {
            return super.onTouchEvent(event);
        }
        this.hasStartedDragging = true;
        TouchUtils.handleTouchPriority(event, (View)this, 1, false, this.pdfView.isZooming());
        switch (event.getAction()) {
            case 0: 
            case 5: {
                this.pdfView.stopFling();
                this.handler.removeCallbacks(this.hidePageScrollerRunnable);
                this.currentPos = this.pdfView.isSwipeVertical() ? event.getRawY() - this.getY() : event.getRawX() - this.getX();
                return true;
            }
            case 2: {
                if (this.pdfView.isSwipeVertical()) {
                    this.setPosition(event.getRawY() - this.currentPos + this.relativeHandlerMiddle);
                    this.pdfView.setPositionOffset(this.relativeHandlerMiddle / (float)this.getHeight(), false);
                } else {
                    this.setPosition(event.getRawX() - this.currentPos + this.relativeHandlerMiddle);
                    this.pdfView.setPositionOffset(this.relativeHandlerMiddle / (float)this.getWidth(), false);
                }
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                this.hideDelayed();
                this.pdfView.performPageSnap();
                this.hasStartedDragging = false;
                return true;
            }
        }
        return super.onTouchEvent(event);
    }
}

