/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview;

import android.graphics.PointF;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.annotation.NonNull;
import com.infomaniak.lib.pdfview.AnimationManager;
import com.infomaniak.lib.pdfview.PDFView;
import com.infomaniak.lib.pdfview.PdfFile;
import com.infomaniak.lib.pdfview.model.LinkTapEvent;
import com.infomaniak.lib.pdfview.scroll.ScrollHandle;
import com.infomaniak.lib.pdfview.util.SnapEdge;
import com.infomaniak.lib.pdfview.util.TouchUtils;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.util.SizeF;

class DragPinchManager
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener,
View.OnTouchListener {
    private static final float MIN_TRIGGER_DELTA_X_TOUCH_PRIORITY = 150.0f;
    private static final float MIN_TRIGGER_DELTA_Y_TOUCH_PRIORITY = 100.0f;
    private static final float STARTING_TOUCH_POSITION_NOT_INITIALIZED = -1.0f;
    private static final int TOUCH_POINTER_COUNT = 2;
    private final PDFView pdfView;
    private final AnimationManager animationManager;
    private final GestureDetector gestureDetector;
    private final ScaleGestureDetector scaleGestureDetector;
    private boolean scrolling = false;
    private boolean scaling = false;
    private boolean enabled = false;
    private boolean hasTouchPriority = false;
    private float startingScrollingXPosition = -1.0f;
    private float startingTouchXPosition = -1.0f;
    private float startingTouchYPosition = -1.0f;

    DragPinchManager(PDFView pdfView, AnimationManager animationManager) {
        this.pdfView = pdfView;
        this.animationManager = animationManager;
        this.gestureDetector = new GestureDetector(pdfView.getContext(), (GestureDetector.OnGestureListener)this);
        this.scaleGestureDetector = new ScaleGestureDetector(pdfView.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
        pdfView.setOnTouchListener(this);
    }

    void enable() {
        this.enabled = true;
    }

    void disable() {
        this.enabled = false;
    }

    boolean hasTouchPriority() {
        return this.hasTouchPriority;
    }

    void setHasTouchPriority(boolean hasTouchPriority) {
        this.hasTouchPriority = hasTouchPriority;
    }

    void disableLongPress() {
        this.gestureDetector.setIsLongpressEnabled(false);
    }

    public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
        ScrollHandle ps;
        boolean onTapHandled = this.pdfView.callbacks.callOnTap(e);
        boolean linkTapped = this.checkLinkTapped(e.getX(), e.getY());
        if (!(onTapHandled || linkTapped || (ps = this.pdfView.getScrollHandle()) == null || this.pdfView.documentFitsView())) {
            if (!ps.shown()) {
                ps.show();
            } else {
                ps.hide();
            }
        }
        this.pdfView.performClick();
        return true;
    }

    private boolean checkLinkTapped(float x, float y) {
        int pageY;
        int pageX;
        PdfFile pdfFile = this.pdfView.pdfFile;
        if (pdfFile == null) {
            return false;
        }
        float mappedX = -this.pdfView.getCurrentXOffset() + x;
        float mappedY = -this.pdfView.getCurrentYOffset() + y;
        int page = pdfFile.getPageAtOffset(this.pdfView.isSwipeVertical() ? mappedY : mappedX, this.pdfView.getZoom());
        SizeF pageSize = pdfFile.getScaledPageSize(page, this.pdfView.getZoom());
        if (this.pdfView.isSwipeVertical()) {
            pageX = (int)pdfFile.getSecondaryPageOffset(page, this.pdfView.getZoom());
            pageY = (int)pdfFile.getPageOffset(page, this.pdfView.getZoom());
        } else {
            pageY = (int)pdfFile.getSecondaryPageOffset(page, this.pdfView.getZoom());
            pageX = (int)pdfFile.getPageOffset(page, this.pdfView.getZoom());
        }
        for (PdfDocument.Link link : pdfFile.getPageLinks(page)) {
            RectF mapped = pdfFile.mapRectToDevice(page, pageX, pageY, (int)pageSize.getWidth(), (int)pageSize.getHeight(), link.getBounds());
            mapped.sort();
            if (!mapped.contains(mappedX, mappedY)) continue;
            this.pdfView.callbacks.callLinkHandler(new LinkTapEvent(x, y, mappedX, mappedY, mapped, link));
            return true;
        }
        return false;
    }

    private void startPageFling(MotionEvent downEvent, MotionEvent ev, float velocityX, float velocityY) {
        if (!this.checkDoPageFling(velocityX, velocityY)) {
            return;
        }
        int direction = this.pdfView.isSwipeVertical() ? (velocityY > 0.0f ? -1 : 1) : (velocityX > 0.0f ? -1 : 1);
        float delta = this.pdfView.isSwipeVertical() ? ev.getY() - downEvent.getY() : ev.getX() - downEvent.getX();
        float offsetX = this.pdfView.getCurrentXOffset() - delta * this.pdfView.getZoom();
        float offsetY = this.pdfView.getCurrentYOffset() - delta * this.pdfView.getZoom();
        int startingPage = this.pdfView.findFocusPage(offsetX, offsetY);
        int targetPage = Math.max(0, Math.min(this.pdfView.getPageCount() - 1, startingPage + direction));
        SnapEdge edge = this.pdfView.findSnapEdge(targetPage);
        float offset = this.pdfView.snapOffsetForPage(targetPage, edge);
        this.animationManager.startPageFlingAnimation(-offset);
    }

    public boolean onDoubleTap(@NonNull MotionEvent e) {
        if (!this.pdfView.isDoubleTapEnabled()) {
            return false;
        }
        if (this.pdfView.getZoom() < this.pdfView.getMidZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMidZoom());
        } else if (this.pdfView.getZoom() < this.pdfView.getMaxZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMaxZoom());
        } else {
            this.pdfView.resetZoomWithAnimation();
        }
        return true;
    }

    public boolean onDoubleTapEvent(@NonNull MotionEvent e) {
        return false;
    }

    public boolean onDown(@NonNull MotionEvent e) {
        this.animationManager.stopFling();
        return true;
    }

    public void onShowPress(@NonNull MotionEvent e) {
    }

    public boolean onSingleTapUp(@NonNull MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
        this.scrolling = true;
        if (this.pdfView.isZooming() || this.pdfView.isSwipeEnabled()) {
            this.pdfView.moveRelativeTo(-distanceX, -distanceY);
        }
        if (!this.scaling || this.pdfView.doRenderDuringScale()) {
            this.pdfView.loadPageByOffset();
        }
        return true;
    }

    private void onScrollEnd() {
        this.pdfView.loadPages();
        this.hideHandle();
        if (!this.animationManager.isFlinging()) {
            this.pdfView.performPageSnap();
        }
    }

    public void onLongPress(@NonNull MotionEvent e) {
        this.pdfView.callbacks.callOnLongPress(e);
    }

    public boolean onFling(MotionEvent e1, @NonNull MotionEvent e2, float velocityX, float velocityY) {
        float minY;
        float minX;
        if (!this.pdfView.isSwipeEnabled()) {
            return false;
        }
        if (this.pdfView.isPageFlingEnabled()) {
            if (this.pdfView.pageFillsScreen()) {
                this.onBoundedFling(velocityX, velocityY);
            } else {
                this.startPageFling(e1, e2, velocityX, velocityY);
            }
            return true;
        }
        int xOffset = (int)this.pdfView.getCurrentXOffset();
        int yOffset = (int)this.pdfView.getCurrentYOffset();
        PdfFile pdfFile = this.pdfView.pdfFile;
        if (this.pdfView.isSwipeVertical()) {
            minX = -(this.pdfView.toCurrentScale(pdfFile.getMaxPageWidth()) - (float)this.pdfView.getWidth());
            minY = -(pdfFile.getDocLen(this.pdfView.getZoom()) - (float)this.pdfView.getHeight());
        } else {
            minX = -(pdfFile.getDocLen(this.pdfView.getZoom()) - (float)this.pdfView.getWidth());
            minY = -(this.pdfView.toCurrentScale(pdfFile.getMaxPageHeight()) - (float)this.pdfView.getHeight());
        }
        this.animationManager.startFlingAnimation(xOffset, yOffset, (int)velocityX, (int)velocityY, (int)minX, 0, (int)minY, 0);
        return true;
    }

    private void onBoundedFling(float velocityX, float velocityY) {
        float maxY;
        float maxX;
        float minY;
        float minX;
        int xOffset = (int)this.pdfView.getCurrentXOffset();
        int yOffset = (int)this.pdfView.getCurrentYOffset();
        PdfFile pdfFile = this.pdfView.pdfFile;
        float pageStart = -pdfFile.getPageOffset(this.pdfView.getCurrentPage(), this.pdfView.getZoom());
        float pageEnd = pageStart - pdfFile.getPageLength(this.pdfView.getCurrentPage(), this.pdfView.getZoom());
        if (this.pdfView.isSwipeVertical()) {
            minX = -(this.pdfView.toCurrentScale(pdfFile.getMaxPageWidth()) - (float)this.pdfView.getWidth());
            minY = pageEnd + (float)this.pdfView.getHeight();
            maxX = 0.0f;
            maxY = pageStart;
        } else {
            minX = pageEnd + (float)this.pdfView.getWidth();
            minY = -(this.pdfView.toCurrentScale(pdfFile.getMaxPageHeight()) - (float)this.pdfView.getHeight());
            maxX = pageStart;
            maxY = 0.0f;
        }
        this.animationManager.startFlingAnimation(xOffset, yOffset, (int)velocityX, (int)velocityY, (int)minX, (int)maxX, (int)minY, (int)maxY);
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float dr = detector.getScaleFactor();
        float wantedZoom = this.pdfView.getZoom() * dr;
        float minZoom = Math.min(0.3f, this.pdfView.getMinZoom());
        float maxZoom = Math.max(100.0f, this.pdfView.getMaxZoom());
        if (wantedZoom < minZoom) {
            dr = minZoom / this.pdfView.getZoom();
        } else if (wantedZoom > maxZoom) {
            dr = maxZoom / this.pdfView.getZoom();
        }
        this.pdfView.zoomCenteredRelativeTo(dr, new PointF(detector.getFocusX(), detector.getFocusY()));
        return true;
    }

    public boolean onScaleBegin(@NonNull ScaleGestureDetector detector) {
        this.scaling = true;
        return true;
    }

    public void onScaleEnd(@NonNull ScaleGestureDetector detector) {
        this.pdfView.loadPages();
        this.hideHandle();
        this.scaling = false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.enabled) {
            return false;
        }
        boolean retVal = this.scaleGestureDetector.onTouchEvent(event);
        boolean bl = retVal = this.gestureDetector.onTouchEvent(event) || retVal;
        if (event.getAction() == 2 && event.getPointerCount() >= 2) {
            this.startingScrollingXPosition = -1.0f;
            this.startingTouchXPosition = -1.0f;
            this.startingTouchYPosition = -1.0f;
        }
        if (event.getAction() == 1 && this.scrolling) {
            this.startingScrollingXPosition = -1.0f;
            this.startingTouchXPosition = -1.0f;
            this.startingTouchYPosition = -1.0f;
            this.scrolling = false;
            this.onScrollEnd();
        }
        if (this.hasTouchPriority) {
            TouchUtils.handleTouchPriority(event, v, 2, this.shouldOverrideTouchPriority(v, event), this.pdfView.isZooming());
        }
        return retVal;
    }

    private boolean shouldOverrideTouchPriority(View v, MotionEvent event) {
        boolean isScrollingBlocked;
        boolean canScrollHorizontally;
        if (event.getAction() == 0) {
            this.handleActionDownEvent(v, event);
        }
        boolean canScrollLeft = v.canScrollHorizontally(-1);
        boolean canScrollRight = v.canScrollHorizontally(1);
        boolean bl = canScrollHorizontally = canScrollLeft && canScrollRight;
        if (event.getAction() == 2) {
            this.handleActionMoveEvent(event, canScrollHorizontally);
        }
        int scrollDirection = this.getScrollingDirection(event.getX());
        boolean bl2 = isScrollingBlocked = !canScrollRight && scrollDirection == -1 || !canScrollLeft && scrollDirection == 1;
        if (!isScrollingBlocked || this.startingTouchXPosition == -1.0f) {
            return false;
        }
        float deltaX = Math.abs(event.getX() - this.startingTouchXPosition);
        float deltaY = Math.abs(event.getY() - this.startingTouchYPosition);
        return deltaX >= 150.0f && deltaY < 100.0f;
    }

    private void handleActionMoveEvent(MotionEvent event, boolean canScrollHorizontally) {
        if (canScrollHorizontally) {
            this.startingTouchXPosition = -1.0f;
        } else if (this.startingTouchXPosition == -1.0f) {
            this.startingTouchXPosition = event.getX();
        }
    }

    private void handleActionDownEvent(View v, MotionEvent event) {
        this.startingScrollingXPosition = event.getX();
        this.startingTouchXPosition = !v.canScrollHorizontally(-1) || !v.canScrollHorizontally(1) ? event.getX() : -1.0f;
        this.startingTouchYPosition = event.getY();
    }

    private int getScrollingDirection(float x) {
        if (x > this.startingScrollingXPosition) {
            return 1;
        }
        return -1;
    }

    private void hideHandle() {
        ScrollHandle scrollHandle = this.pdfView.getScrollHandle();
        if (scrollHandle != null && scrollHandle.shown()) {
            scrollHandle.hideDelayed();
        }
    }

    private boolean checkDoPageFling(float velocityX, float velocityY) {
        float absX = Math.abs(velocityX);
        float absY = Math.abs(velocityY);
        return this.pdfView.isSwipeVertical() ? absY > absX : absX > absY;
    }
}

