/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.view.animation.DecelerateInterpolator;
import android.widget.OverScroller;
import com.infomaniak.lib.pdfview.PDFView;

class AnimationManager {
    private PDFView pdfView;
    private ValueAnimator animation;
    private OverScroller scroller;
    private boolean flinging = false;
    private boolean pageFlinging = false;

    public AnimationManager(PDFView pdfView) {
        this.pdfView = pdfView;
        this.scroller = new OverScroller(pdfView.getContext());
    }

    public void startXAnimation(float xFrom, float xTo) {
        this.stopAll();
        this.animation = ValueAnimator.ofFloat((float[])new float[]{xFrom, xTo});
        XAnimation xAnimation = new XAnimation();
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)xAnimation);
        this.animation.addListener((Animator.AnimatorListener)xAnimation);
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startYAnimation(float yFrom, float yTo) {
        this.stopAll();
        this.animation = ValueAnimator.ofFloat((float[])new float[]{yFrom, yTo});
        YAnimation yAnimation = new YAnimation();
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)yAnimation);
        this.animation.addListener((Animator.AnimatorListener)yAnimation);
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startZoomAnimation(float centerX, float centerY, float zoomFrom, float zoomTo) {
        this.stopAll();
        this.animation = ValueAnimator.ofFloat((float[])new float[]{zoomFrom, zoomTo});
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ZoomAnimation zoomAnim = new ZoomAnimation(centerX, centerY);
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)zoomAnim);
        this.animation.addListener((Animator.AnimatorListener)zoomAnim);
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startFlingAnimation(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        this.stopAll();
        this.flinging = true;
        this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
    }

    public void startPageFlingAnimation(float targetOffset) {
        if (this.pdfView.isSwipeVertical()) {
            this.startYAnimation(this.pdfView.getCurrentYOffset(), targetOffset);
        } else {
            this.startXAnimation(this.pdfView.getCurrentXOffset(), targetOffset);
        }
        this.pageFlinging = true;
    }

    void computeFling() {
        if (this.scroller.computeScrollOffset()) {
            if (this.shouldHandleScrollerValue()) {
                this.pdfView.moveTo(this.scroller.getCurrX(), this.scroller.getCurrY());
                this.pdfView.loadPageByOffset();
            }
        } else if (this.flinging) {
            this.flinging = false;
            this.pdfView.loadPages();
            this.hideHandle();
            this.pdfView.performPageSnap();
        }
    }

    private boolean shouldHandleScrollerValue() {
        if (this.pdfView.isSwipeVertical()) {
            return this.scroller.getCurrY() != 0 && this.scroller.getCurrY() != this.pdfView.getDocumentLength();
        }
        return this.scroller.getCurrX() != 0 && this.scroller.getCurrX() != this.pdfView.getDocumentLength();
    }

    public void stopAll() {
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        this.stopFling();
    }

    public void stopFling() {
        this.flinging = false;
        this.scroller.forceFinished(true);
    }

    public boolean isFlinging() {
        return this.flinging || this.pageFlinging;
    }

    private void hideHandle() {
        if (this.pdfView.getScrollHandle() != null) {
            this.pdfView.getScrollHandle().hideDelayed();
        }
    }

    class XAnimation
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        XAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float offset = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.moveTo(offset, AnimationManager.this.pdfView.getCurrentYOffset());
            AnimationManager.this.pdfView.loadPageByOffset();
        }

        public void onAnimationCancel(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.pageFlinging = false;
            AnimationManager.this.hideHandle();
        }

        public void onAnimationEnd(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.pageFlinging = false;
            AnimationManager.this.hideHandle();
        }
    }

    class YAnimation
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        YAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float offset = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.moveTo(AnimationManager.this.pdfView.getCurrentXOffset(), offset);
            AnimationManager.this.pdfView.loadPageByOffset();
        }

        public void onAnimationCancel(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.pageFlinging = false;
            AnimationManager.this.hideHandle();
        }

        public void onAnimationEnd(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.pageFlinging = false;
            AnimationManager.this.hideHandle();
        }
    }

    class ZoomAnimation
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        private final float centerX;
        private final float centerY;

        public ZoomAnimation(float centerX, float centerY) {
            this.centerX = centerX;
            this.centerY = centerY;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float zoom = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.zoomCenteredTo(zoom, new PointF(this.centerX, this.centerY));
        }

        public void onAnimationCancel(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.hideHandle();
        }

        public void onAnimationEnd(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.pdfView.performPageSnap();
            AnimationManager.this.hideHandle();
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationStart(Animator animation) {
        }
    }
}

