/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rengwuxian.materialedittext.validation.METValidator;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.maps.LocationPart;
import com.vijay.jsonwizard.maps.LocationTextWatcher;
import com.vijay.jsonwizard.maps.LocationValueReporter;
import com.vijay.jsonwizard.maps.MapsUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.edittext.EqualsValidator;
import com.vijay.jsonwizard.validators.edittext.RequiredValidator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationPickerFactory
implements FormWidgetFactory {
    public static final String KEY_SUFFIX_LATITUDE = "_latitude";
    public static final String KEY_SUFFIX_LONGITUDE = "_longitude";
    public static final String KEY_SUFFIX_ACCURACY = "_accuracy";
    private static final String TAG = "JsonFormActivity";
    private static final int INPUT_TYPE_DECIMAL_NUMBER = 12290;

    public static ValidationStatus validate(MaterialEditText editText) {
        boolean validate = editText.validate();
        if (!validate) {
            return new ValidationStatus(false, editText.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws Exception {
        List<View> views;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle, resolver, resourceResolver);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, listener, bundle, resolver, resourceResolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver) throws JSONException {
        String requiredValue;
        String readonlyValue = jsonObject.optString("readonly");
        boolean readonly = false;
        if (resolver.isValidExpression(readonlyValue)) {
            JSONObject currentValues = this.getCurrentValues(context);
            readonly = resolver.existsExpression(readonlyValue, currentValues);
        } else {
            readonly = Boolean.TRUE.toString().equalsIgnoreCase(readonlyValue);
        }
        if (readonly) {
            return this.getReadOnlyViewsFromJson(context, jsonObject, bundle, resolver, resourceResolver);
        }
        String jsonKey = jsonObject.getString("key");
        String jsonInputType = jsonObject.getString("type");
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        parentView.setTag(R.id.key, (Object)jsonKey);
        parentView.setTag(R.id.type, (Object)jsonInputType);
        this.loadMapConfig(context, jsonObject, resolver, parentView);
        boolean accuracyEnabled = jsonObject.has("accuracy") && jsonObject.getBoolean("accuracy");
        parentView.setTag(R.id.accuracy, (Object)accuracyEnabled);
        if (jsonObject.has("icon")) {
            String customIcon = jsonObject.getString("icon");
            customIcon = resourceResolver.resolvePath(context, customIcon);
            parentView.setTag(R.id.custom_icon, (Object)customIcon);
        }
        View mapContainer = parentView.findViewById(R.id.map_container);
        mapContainer.setId(View.generateViewId());
        mapContainer.setTag((Object)R.id.map_container);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        TextView label = (TextView)parentView.findViewById(R.id.location_label);
        label.setText((CharSequence)hint);
        View inputContainer = parentView.findViewById(R.id.value_container);
        inputContainer.setTag(R.id.key, (Object)jsonKey);
        inputContainer.setTag(R.id.type, (Object)jsonInputType);
        boolean editable = jsonObject.optBoolean("editable");
        MaterialEditText etLatitude = (MaterialEditText)parentView.findViewById(R.id.location_latitude);
        etLatitude.setId(ViewUtil.generateViewId());
        etLatitude.setEnabled(editable);
        etLatitude.setInputType(12290);
        etLatitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LATITUDE));
        etLatitude.setTag(R.id.type, (Object)jsonInputType);
        MaterialEditText etLongitude = (MaterialEditText)parentView.findViewById(R.id.location_longitude);
        etLongitude.setId(ViewUtil.generateViewId());
        etLongitude.setEnabled(editable);
        etLongitude.setInputType(12290);
        etLongitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LONGITUDE));
        etLongitude.setTag(R.id.type, (Object)jsonInputType);
        MaterialEditText etAccuracy = (MaterialEditText)parentView.findViewById(R.id.location_accuracy);
        etAccuracy.setId(ViewUtil.generateViewId());
        etAccuracy.setInputType(12290);
        etAccuracy.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_ACCURACY));
        etAccuracy.setTag(R.id.type, (Object)jsonInputType);
        if (accuracyEnabled) {
            etAccuracy.setEnabled(editable);
            etAccuracy.setVisibility(0);
        } else {
            etAccuracy.setVisibility(8);
        }
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        String key = jsonKey;
        imageView.setTag(R.id.key, (Object)jsonKey);
        imageView.setTag(R.id.type, (Object)jsonInputType);
        String customIconInput = jsonObject.optString("icon_input");
        if (!TextUtils.isEmpty((CharSequence)customIconInput)) {
            String customIconPath = resourceResolver.resolvePath(context, customIconInput);
            Bitmap bitmap = BitmapFactory.decodeFile((String)customIconPath);
            imageView.setImageBitmap(bitmap);
        }
        View.OnClickListener onClickListenerWithValue = this.getOnClickListenerWithValue(parentView, (EditText)etLatitude, (EditText)etLongitude, (EditText)etAccuracy, listener, accuracyEnabled);
        imageView.setOnClickListener(onClickListenerWithValue);
        mapContainer.setOnClickListener(onClickListenerWithValue);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.fillDefaultValue(parentView, etLatitude, etLongitude, etAccuracy, value);
            mapContainer.findViewById(R.id.map_placeholder).setVisibility(8);
        } else {
            mapContainer.findViewById(R.id.map_placeholder).setVisibility(0);
        }
        JSONObject requiredObject = jsonObject.optJSONObject("v_required");
        if (requiredObject != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = this.getCurrentValues(context);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                etLatitude.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                etLongitude.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                if (accuracyEnabled) {
                    etAccuracy.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                }
            }
        }
        JSONObject accuracyValidator = jsonObject.optJSONObject("v_exact_position");
        if (accuracyEnabled && accuracyValidator != null) {
            etAccuracy.addValidator((METValidator)new EqualsValidator("-1", bundle.resolveKey(accuracyValidator.getString("err")), true));
        }
        LocationValueReporter valueReporter = TextUtils.isEmpty((CharSequence)value) ? new LocationValueReporter(stepName, parentView, accuracyEnabled) : new LocationValueReporter(stepName, parentView, value, accuracyEnabled);
        etLatitude.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.LATITUDE, valueReporter));
        etLongitude.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.LONGITUDE, valueReporter));
        if (accuracyEnabled) {
            etAccuracy.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.ACCURACY, valueReporter));
        }
        views.add(parentView);
        return views;
    }

    private void loadMapConfig(Context context, JSONObject jsonObject, JsonExpressionResolver resolver, View parentView) throws JSONException {
        if (jsonObject.has("map_config")) {
            JSONObject mapConfig;
            String expression = jsonObject.optString("map_config");
            if (resolver.isValidExpression(expression)) {
                JSONObject currentValues = this.getCurrentValues(context);
                mapConfig = resolver.resolveAsObject(expression, currentValues);
            } else {
                mapConfig = jsonObject.getJSONObject("map_config");
            }
            parentView.setTag(R.id.map_min_zoom, (Object)mapConfig.optDouble("min_zoom", 8.0));
            parentView.setTag(R.id.map_max_zoom, (Object)mapConfig.optDouble("max_zoom", 18.0));
            parentView.setTag(R.id.map_default_zoom, (Object)mapConfig.optDouble("default_zoom"));
        }
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver) throws JSONException {
        String value;
        boolean accuracyEnabled;
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        String jsonKey = jsonObject.getString("key");
        String jsonType = jsonObject.getString("type");
        parentView.setTag(R.id.key, (Object)jsonKey);
        parentView.setTag(R.id.type, (Object)jsonType);
        this.loadMapConfig(context, jsonObject, resolver, parentView);
        View mapContainer = parentView.findViewById(R.id.map_container);
        mapContainer.setId(View.generateViewId());
        mapContainer.setTag((Object)R.id.map_container);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        TextView label = (TextView)parentView.findViewById(R.id.location_label);
        label.setText((CharSequence)hint);
        MaterialEditText etLatitude = (MaterialEditText)parentView.findViewById(R.id.location_latitude);
        etLatitude.setId(ViewUtil.generateViewId());
        etLatitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LATITUDE));
        etLatitude.setTag(R.id.type, (Object)jsonType);
        etLatitude.setEnabled(false);
        MaterialEditText etLongitude = (MaterialEditText)parentView.findViewById(R.id.location_longitude);
        etLongitude.setId(ViewUtil.generateViewId());
        etLongitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LONGITUDE));
        etLongitude.setTag(R.id.type, (Object)jsonType);
        etLongitude.setEnabled(false);
        MaterialEditText etAccuracy = (MaterialEditText)parentView.findViewById(R.id.location_accuracy);
        etAccuracy.setId(ViewUtil.generateViewId());
        etAccuracy.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_ACCURACY));
        etAccuracy.setTag(R.id.type, (Object)jsonType);
        etAccuracy.setEnabled(false);
        boolean bl = accuracyEnabled = jsonObject.has("accuracy") && jsonObject.getBoolean("accuracy");
        if (accuracyEnabled) {
            etAccuracy.setVisibility(0);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = jsonObject.optString("value")))) {
            this.fillDefaultValue(parentView, etLatitude, etLongitude, etAccuracy, value);
        } else {
            mapContainer.setVisibility(8);
            FrameLayout containerParent = (FrameLayout)mapContainer.getParent();
            containerParent.setVisibility(8);
        }
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        imageView.setClickable(false);
        imageView.setEnabled(false);
        imageView.setVisibility(8);
        views.add(parentView);
        return views;
    }

    private void fillDefaultValue(View parentView, MaterialEditText etLatitude, MaterialEditText etLongitude, MaterialEditText etAccuracy, String value) {
        parentView.setTag(R.id.value, (Object)value);
        String[] parts = value.split(",");
        if (parts.length > 0) {
            etLatitude.setText((CharSequence)parts[0].trim());
        }
        if (parts.length > 1) {
            etLongitude.setText((CharSequence)parts[1].trim());
        }
        if (parts.length > 2) {
            etAccuracy.setText((CharSequence)parts[2].trim());
        }
    }

    private View.OnClickListener getOnClickListenerWithValue(final View parentView, final EditText etLatitude, final EditText etLongitude, final EditText etAccuracy, final CommonListener listener, final boolean accuracy) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                String value = accuracy ? MapsUtils.toString(etLatitude.getText().toString(), etLongitude.getText().toString(), etAccuracy.getText().toString()) : MapsUtils.toString(etLatitude.getText().toString(), etLongitude.getText().toString());
                parentView.setTag(R.id.value, (Object)value);
                listener.onClick(parentView);
            }
        };
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }
}

