/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.FormUtils;
import com.vijay.jsonwizard.widgets.WidgetFactoryRegistry;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EditGroupFactory
implements FormWidgetFactory {
    private static final String TAG = "EditGroupFactory";

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject parentJson, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        ArrayList<View> viewsFromJson = new ArrayList<View>();
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(0);
        linearLayout.setTag(R.id.key, (Object)parentJson.getString("key"));
        linearLayout.setTag(R.id.type, (Object)"edit_group");
        String groupTitle = bundle.resolveKey(parentJson.optString("title"));
        if (!TextUtils.isEmpty((CharSequence)groupTitle)) {
            viewsFromJson.add((View)FormUtils.getTextViewWith(context, 16, groupTitle, parentJson.getString("key"), parentJson.getString("type"), FormUtils.getLayoutParams(-1, -2, 0, 0, 0, 0), "font/Roboto-Bold.ttf"));
        }
        try {
            JSONArray fields = parentJson.getJSONArray("fields");
            long optNumber = parentJson.getLong("optNumber");
            linearLayout.setWeightSum((float)optNumber);
            int i = 0;
            while ((long)i < optNumber) {
                JSONObject childJson = fields.getJSONObject(i);
                try {
                    List<View> views = WidgetFactoryRegistry.getWidgetFactory(childJson.getString("type")).getViewsFromJson(stepName, context, childJson, listener, bundle, resolver, resourceResolver, visualizationMode);
                    for (View v : views) {
                        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
                        layoutParams.setMargins(0, 0, 10, 0);
                        v.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        linearLayout.addView(v);
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Exception occurred in making child view at index : " + i + " : Exception is : " + e.getMessage()));
                }
                ++i;
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Json exception occurred : " + e.getMessage()));
        }
        if (linearLayout.getChildCount() > 0) {
            viewsFromJson.add((View)linearLayout);
        }
        return viewsFromJson;
    }
}

