/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.maps;

import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import android.view.View;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.maps.LocationPart;
import com.vijay.jsonwizard.maps.MapsUtils;
import org.json.JSONException;

public class LocationValueReporter {
    private static final String TAG = "JsonFormActivity";
    private final String mStepName;
    private final View mView;
    private final boolean mAccuracyEnabled;
    private String mLatitude = "";
    private String mLongitude = "";
    private String mAccuracy = "";

    public LocationValueReporter(String stepName, View view, boolean accuracyEnabled) {
        this.mStepName = stepName;
        this.mView = view;
        this.mAccuracyEnabled = accuracyEnabled;
    }

    public LocationValueReporter(String stepName, View view, String initialValue, boolean accuracyEnabled) {
        this.mStepName = stepName;
        this.mView = view;
        this.mAccuracyEnabled = accuracyEnabled;
        String[] parts = initialValue.split(",");
        if (parts.length > 0) {
            this.mLatitude = parts[0].trim();
        }
        if (parts.length > 1) {
            this.mLongitude = parts[1].trim();
        }
        if (parts.length > 2) {
            this.mAccuracy = parts[2].trim();
        }
    }

    public void reportValue(String partialText, LocationPart locationComponent) {
        JsonApi api;
        switch (locationComponent) {
            case LATITUDE: {
                this.mLatitude = partialText;
                break;
            }
            case LONGITUDE: {
                this.mLongitude = partialText;
                break;
            }
            case ACCURACY: {
                this.mAccuracy = partialText;
            }
        }
        String text = this.mAccuracyEnabled ? MapsUtils.toString(this.mLatitude, this.mLongitude, this.mAccuracy) : MapsUtils.toString(this.mLatitude, this.mLongitude);
        Context ctx = this.mView.getContext();
        if (ctx instanceof JsonApi) {
            api = (JsonApi)ctx;
        } else if (ctx instanceof ContextWrapper) {
            ContextWrapper contextWrapper = (ContextWrapper)ctx;
            api = (JsonApi)contextWrapper.getBaseContext();
        } else {
            throw new RuntimeException("Could not fetch context");
        }
        String key = (String)this.mView.getTag(R.id.key);
        try {
            api.writeValue(this.mStepName, key, text);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }
}

