/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.i18n;

import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFormBundle {
    private static final String TAG = "JsonFormBundle";
    private static final String BUNDLE_KEY_PREFIX = "${";
    private static final String BUNDLE_KEY_SUFIX = "}";
    private static final String BUNDLE_DEFAULT_PROPERTY = "default";
    private final Map<String, String> mBundle = new HashMap<String, String>();

    public JsonFormBundle(JSONObject form, Locale locale) throws JSONException {
        if (form.has("bundle")) {
            this.loadBundle(form.getJSONObject("bundle"), locale.getLanguage());
        }
    }

    public String resolveKey(String key) {
        String finalKey;
        if (!TextUtils.isEmpty((CharSequence)key) && key.startsWith(BUNDLE_KEY_PREFIX) && key.endsWith(BUNDLE_KEY_SUFIX) && this.mBundle.containsKey(finalKey = key.substring(2, key.length() - 1))) {
            return this.mBundle.get(finalKey);
        }
        return key;
    }

    private void loadBundle(JSONObject bundle, String country) throws JSONException {
        String lang = country;
        if (!bundle.has(lang)) {
            lang = this.getDefaultLang(bundle);
        }
        if (!"".equals(lang)) {
            JSONObject translations = bundle.getJSONObject(lang);
            Iterator transIter = translations.keys();
            while (transIter.hasNext()) {
                String key = (String)transIter.next();
                this.mBundle.put(key, translations.getString(key));
            }
        }
    }

    private String getDefaultLang(JSONObject bundle) {
        String defLang = "";
        for (int i = 0; i < bundle.names().length(); ++i) {
            try {
                JSONObject translations;
                String currentLang = bundle.names().getString(i);
                if ("".equals(defLang)) {
                    defLang = currentLang;
                }
                if (!(translations = bundle.getJSONObject(currentLang)).optBoolean(BUNDLE_DEFAULT_PROPERTY)) continue;
                return currentLang;
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return defLang;
    }
}

