/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.images.Size;
import com.vijay.jsonwizard.barcode.common.CameraSource;
import com.vijay.jsonwizard.barcode.common.GraphicOverlay;
import java.io.IOException;

public class CameraSourcePreview
extends ViewGroup {
    private static final String TAG = "MIDemoApp:Preview";
    private Context context;
    private SurfaceView surfaceView;
    private boolean startRequested;
    private boolean surfaceAvailable;
    private CameraSource cameraSource;
    private GraphicOverlay overlay;

    public CameraSourcePreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.startRequested = false;
        this.surfaceAvailable = false;
        this.surfaceView = new SurfaceView(context);
        this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.surfaceView);
    }

    public void start(CameraSource cameraSource) throws IOException {
        if (cameraSource == null) {
            this.stop();
        }
        this.cameraSource = cameraSource;
        if (this.cameraSource != null) {
            this.startRequested = true;
            this.startIfReady();
        }
    }

    public void start(CameraSource cameraSource, GraphicOverlay overlay) throws IOException {
        this.overlay = overlay;
        this.start(cameraSource);
    }

    public void stop() {
        if (this.cameraSource != null) {
            this.cameraSource.stop();
        }
    }

    public void release() {
        if (this.cameraSource != null) {
            this.cameraSource.release();
            this.cameraSource = null;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void startIfReady() throws IOException {
        if (this.startRequested && this.surfaceAvailable) {
            this.cameraSource.start();
            if (this.overlay != null) {
                Size size = this.cameraSource.getPreviewSize();
                int min = Math.min(size.getWidth(), size.getHeight());
                int max = Math.max(size.getWidth(), size.getHeight());
                if (this.isPortraitMode()) {
                    this.overlay.setCameraInfo(min, max, this.cameraSource.getCameraFacing());
                } else {
                    this.overlay.setCameraInfo(max, min, this.cameraSource.getCameraFacing());
                }
                this.overlay.clear();
            }
            this.startRequested = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        Size size;
        int width = 320;
        int height = 240;
        if (this.cameraSource != null && (size = this.cameraSource.getPreviewSize()) != null) {
            width = size.getWidth();
            height = size.getHeight();
        }
        if (this.isPortraitMode()) {
            int tmp = width;
            width = height;
            height = tmp;
        }
        int layoutWidth = right - left;
        int layoutHeight = bottom - top;
        int childWidth = layoutWidth;
        int childHeight = (int)((float)layoutWidth / (float)width * (float)height);
        if (childHeight > layoutHeight) {
            childHeight = layoutHeight;
            childWidth = (int)((float)layoutHeight / (float)height * (float)width);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(0, 0, childWidth, childHeight);
            Log.d((String)TAG, (String)("Assigned view: " + i));
        }
        try {
            this.startIfReady();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Could not start camera source.", (Throwable)e);
        }
    }

    private boolean isPortraitMode() {
        int orientation = this.context.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return false;
        }
        if (orientation == 1) {
            return true;
        }
        Log.d((String)TAG, (String)"isPortraitMode returning false by default");
        return false;
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surface) {
            CameraSourcePreview.this.surfaceAvailable = true;
            try {
                CameraSourcePreview.this.startIfReady();
            }
            catch (IOException e) {
                Log.e((String)CameraSourcePreview.TAG, (String)"Could not start camera source.", (Throwable)e);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surface) {
            CameraSourcePreview.this.surfaceAvailable = false;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }
    }
}

