/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rengwuxian.materialedittext.validation.METValidator;
import com.rengwuxian.materialedittext.validation.RegexpValidator;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.GenericTextWatcher;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.edittext.MaxLengthValidator;
import com.vijay.jsonwizard.validators.edittext.MinLengthValidator;
import com.vijay.jsonwizard.validators.edittext.RequiredValidator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class EditTextFactory
implements FormWidgetFactory {
    public static ValidationStatus validate(MaterialEditText editText) {
        boolean validate = editText.validate();
        if (!validate) {
            return new ValidationStatus(false, editText.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, bundle, resolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        String editType;
        String numericValue;
        JSONObject numericObject;
        String urlValue;
        JSONObject urlObject;
        String emailValue;
        JSONObject emailObject;
        String regexValue;
        JSONObject regexObject;
        String maxLengthValue;
        JSONObject maxLengthObject;
        String minLengthValue;
        JSONObject minLengthObject;
        String requiredValue;
        JSONObject requiredObject;
        String readonlyValue = jsonObject.optString("readonly");
        boolean readonly = false;
        if (resolver.isValidExpression(readonlyValue)) {
            JSONObject currentValues = this.getCurrentValues(context);
            readonly = resolver.existsExpression(readonlyValue, currentValues);
        } else {
            readonly = Boolean.TRUE.toString().equalsIgnoreCase(readonlyValue);
        }
        if (readonly) {
            return this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
        }
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setId(ViewUtil.generateViewId());
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            editText.setText((CharSequence)value);
        }
        if (!TextUtils.isEmpty((CharSequence)jsonObject.optString("lines"))) {
            editText.setSingleLine(false);
            editText.setLines(jsonObject.optInt("lines"));
        }
        if ((requiredObject = jsonObject.optJSONObject("v_required")) != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = this.getCurrentValues(context);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                editText.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
            }
        }
        if ((minLengthObject = jsonObject.optJSONObject("v_min_length")) != null && !TextUtils.isEmpty((CharSequence)(minLengthValue = minLengthObject.optString("value")))) {
            int minLength = Integer.parseInt(minLengthValue);
            editText.addValidator((METValidator)new MinLengthValidator(bundle.resolveKey(minLengthObject.getString("err")), Integer.parseInt(minLengthValue)));
            editText.setMinCharacters(minLength);
        }
        if ((maxLengthObject = jsonObject.optJSONObject("v_max_length")) != null && !TextUtils.isEmpty((CharSequence)(maxLengthValue = maxLengthObject.optString("value")))) {
            int maxLength = Integer.parseInt(maxLengthValue);
            editText.addValidator((METValidator)new MaxLengthValidator(bundle.resolveKey(maxLengthObject.getString("err")), Integer.parseInt(maxLengthValue)));
            editText.setMaxCharacters(maxLength);
        }
        if ((regexObject = jsonObject.optJSONObject("v_regex")) != null && !TextUtils.isEmpty((CharSequence)(regexValue = regexObject.optString("value")))) {
            editText.addValidator((METValidator)new RegexpValidator(bundle.resolveKey(regexObject.getString("err")), regexValue));
        }
        if ((emailObject = jsonObject.optJSONObject("v_email")) != null && !TextUtils.isEmpty((CharSequence)(emailValue = emailObject.optString("value"))) && Boolean.TRUE.toString().equalsIgnoreCase(emailValue)) {
            editText.addValidator((METValidator)new RegexpValidator(bundle.resolveKey(emailObject.getString("err")), Patterns.EMAIL_ADDRESS.toString()));
        }
        if ((urlObject = jsonObject.optJSONObject("v_url")) != null && !TextUtils.isEmpty((CharSequence)(urlValue = urlObject.optString("value"))) && Boolean.TRUE.toString().equalsIgnoreCase(urlValue)) {
            editText.addValidator((METValidator)new RegexpValidator(bundle.resolveKey(urlObject.getString("err")), Patterns.WEB_URL.toString()));
        }
        if ((numericObject = jsonObject.optJSONObject("v_numeric")) != null && !TextUtils.isEmpty((CharSequence)(numericValue = numericObject.optString("value"))) && Boolean.TRUE.toString().equalsIgnoreCase(numericValue)) {
            editText.addValidator((METValidator)new RegexpValidator(bundle.resolveKey(numericObject.getString("err")), "[0-9]+"));
        }
        if (!TextUtils.isEmpty((CharSequence)(editType = jsonObject.optString("edit_type"))) && editType.equals("number")) {
            editText.setRawInputType(8194);
        }
        editText.addTextChangedListener((TextWatcher)new GenericTextWatcher(stepName, (View)editText));
        views.add((View)editText);
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        editText.setId(ViewUtil.generateViewId());
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        editText.setText((CharSequence)jsonObject.optString("value"));
        if (!TextUtils.isEmpty((CharSequence)jsonObject.optString("lines"))) {
            editText.setSingleLine(false);
            editText.setLines(jsonObject.optInt("lines"));
        }
        editText.setEnabled(false);
        views.add((View)editText);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }
}

