/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rey.material.app.DatePickerDialog;
import com.rey.material.app.Dialog;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.DateUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class DatePickerFactory
implements FormWidgetFactory {
    private static final String TAG = "DatePickerFactory";

    public static ValidationStatus validate(MaterialEditText editText) {
        boolean validate = editText.validate();
        if (!validate) {
            return new ValidationStatus(false, editText.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(context, jsonObject, bundle);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        String minDate = jsonObject.optString("minDate");
        String maxDate = jsonObject.optString("maxDate");
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setId(ViewUtil.generateViewId());
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        editText.setTag(R.id.v_pattern, (Object)bundle.resolveKey(jsonObject.getString("pattern")));
        editText.setTag(R.id.minDate, (Object)minDate);
        editText.setTag(R.id.maxDate, (Object)maxDate);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            Date date = DateUtils.parseJSONDate(value);
            editText.setText((CharSequence)SimpleDateFormat.getInstance().format(date));
        }
        DatePickerListener datePickerListener = new DatePickerListener(editText);
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)datePickerListener);
        editText.setOnClickListener((View.OnClickListener)datePickerListener);
        editText.setInputType(0);
        views.add((View)editText);
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setId(ViewUtil.generateViewId());
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String widgetPattern = bundle.resolveKey(jsonObject.getString("pattern"));
        editText.setTag(R.id.v_pattern, (Object)widgetPattern);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            Date date = DateUtils.parseJSONDate(value);
            SimpleDateFormat widgetDateFormat = new SimpleDateFormat(widgetPattern);
            editText.setText((CharSequence)widgetDateFormat.format(date));
        }
        editText.setEnabled(false);
        views.add((View)editText);
        return views;
    }

    private class DatePickerListener
    implements View.OnFocusChangeListener,
    View.OnClickListener {
        private Dialog d;
        private MaterialEditText dateText;

        public DatePickerListener(MaterialEditText editText) {
            this.dateText = editText;
        }

        public void onFocusChange(View view, boolean focus) {
            if (focus) {
                this.openDatePicker(view);
            }
        }

        public void onClick(View view) {
            this.openDatePicker(view);
        }

        private void openDatePicker(View view) {
            Date date = new Date();
            String dateStr = this.dateText.getText().toString();
            if (dateStr != null && !"".equals(dateStr)) {
                try {
                    date = SimpleDateFormat.getDateInstance().parse(dateStr);
                }
                catch (ParseException e) {
                    Log.e((String)DatePickerFactory.TAG, (String)("Error parsing " + dateStr + ": " + e.getMessage()));
                }
            }
            String minDateStr = (String)view.getTag(R.id.minDate);
            String maxDateStr = (String)view.getTag(R.id.maxDate);
            String pattern = (String)this.dateText.getTag(R.id.v_pattern);
            Date minDate = this.resolveDate(minDateStr, pattern);
            Date maxDate = this.resolveDate(maxDateStr, pattern);
            DatePickerDialog.Builder builder = new DatePickerDialog.Builder(R.style.Material_App_Dialog_DatePicker).date(date.getTime());
            if (minDate != null && maxDate != null) {
                builder.dateRange(minDate.getTime(), maxDate.getTime());
            }
            this.d = builder.build(view.getContext());
            this.d.positiveActionClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Date date = new Date(((DatePickerDialog)DatePickerListener.this.d).getDate());
                    DatePickerListener.this.dateText.setText((CharSequence)DateUtils.formatDate(date, (String)DatePickerListener.this.dateText.getTag(R.id.v_pattern)));
                    DatePickerListener.this.d.hide();
                }
            });
            this.d.negativeActionClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DatePickerListener.this.d.hide();
                }
            });
            this.d.positiveAction((CharSequence)"OK").negativeAction((CharSequence)"CANCEL");
            this.d.show();
        }

        private Date resolveDate(String dateStr, String pattern) {
            DateFormat sdf = TextUtils.isEmpty((CharSequence)pattern) ? SimpleDateFormat.getDateInstance() : new SimpleDateFormat(pattern);
            try {
                return sdf.parse(dateStr);
            }
            catch (ParseException e) {
                Log.e((String)DatePickerFactory.TAG, (String)("Error parsing " + dateStr + ": " + e.getMessage()));
                return null;
            }
        }
    }
}

