/*
 * Decompiled with CFR 0.152.
 */
package com.hyperion.methodmonitor.business;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.KeyEvent;
import android.widget.EditText;
import android.widget.TextView;
import com.hyperion.methodmonitor.business.MethodTimeAdapter;
import com.hyperion.methodmonitor.business.MethodTimeInfo;
import com.hyperion.methodmonitor.business.MethodTimeManager;
import com.hyperion.methodmonitor.business.R;
import com.hyperion.methodmonitor.business.Utils;
import java.util.ArrayList;
import java.util.List;

public class MethodTimeActivity
extends Activity {
    private RecyclerView mRecyclerView;
    private MethodTimeAdapter mAdapter;
    private EditText mEditText;
    private List<String> mPackagePartNameList = new ArrayList<String>();
    private int mCurrentLevel = 0;
    private long mExecTime = -1L;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MethodTimeManager.getInstance().setOpen(false);
        this.setContentView(R.layout.activity_method_time);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.mAdapter = new MethodTimeAdapter((Context)this);
        this.mAdapter.setOnOperateCallback(new MethodTimeAdapter.OnOperateCallback(){

            @Override
            public void onBack() {
                if (MethodTimeActivity.this.mCurrentLevel > 0) {
                    MethodTimeActivity.this.mCurrentLevel--;
                }
                if (MethodTimeActivity.this.mPackagePartNameList.size() > 1) {
                    MethodTimeActivity.this.mPackagePartNameList.remove(MethodTimeActivity.this.mPackagePartNameList.size() - 1);
                }
                MethodTimeActivity.this.mAdapter.setMethodTimeInfos(MethodTimeActivity.this.loadMethodTimeInfos(MethodTimeActivity.this.mExecTime));
            }

            @Override
            public void onNext(MethodTimeInfo current) {
                if (current == null) {
                    return;
                }
                MethodTimeActivity.this.mCurrentLevel++;
                MethodTimeActivity.this.mPackagePartNameList.add(current.mPackagePartName);
                MethodTimeActivity.this.mAdapter.setMethodTimeInfos(MethodTimeActivity.this.loadMethodTimeInfos(MethodTimeActivity.this.mExecTime));
            }
        });
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mEditText = (EditText)this.findViewById(R.id.editText);
        this.mEditText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                long execTime;
                if (actionId == 6 && (execTime = Utils.parse(MethodTimeActivity.this.mEditText.getText().toString())) > 0L) {
                    MethodTimeActivity.this.mExecTime = execTime;
                    MethodTimeActivity.this.reset();
                    MethodTimeActivity.this.mAdapter.setMethodTimeInfos(MethodTimeActivity.this.loadMethodTimeInfos(execTime));
                }
                return false;
            }
        });
        this.reset();
    }

    protected void onDestroy() {
        MethodTimeManager.getInstance().setOpen(true);
        super.onDestroy();
    }

    private void reset() {
        this.mCurrentLevel = 0;
        this.mPackagePartNameList.clear();
        this.mPackagePartNameList.add("");
    }

    private List<MethodTimeInfo> loadMethodTimeInfos(long execTime) {
        String parentPackageName = null;
        if (this.mCurrentLevel < this.mPackagePartNameList.size()) {
            parentPackageName = this.mPackagePartNameList.get(this.mCurrentLevel);
        }
        return MethodTimeManager.getInstance().getMethodTimeInfo(this.mCurrentLevel, parentPackageName, execTime);
    }
}

