/*
 * Decompiled with CFR 0.152.
 */
package com.hendrix.pdfmyxml;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.hendrix.pdfmyxml.interfaces.IDisposable;
import com.hendrix.pdfmyxml.utils.BitmapUtils;
import com.hendrix.pdfmyxml.viewRenderer.AbstractViewRenderer;
import com.pdfjet.A4;
import com.pdfjet.Image;
import com.pdfjet.PDF;
import com.pdfjet.Page;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class PdfDocument
implements IDisposable {
    public static final String TAG_PDF_MY_XML = "PDF_MY_XML";
    private static final String sDefault_Filename_prefix = "pdf_";
    private Context _ctx = null;
    private A4_MODE _orientation = A4_MODE.LANDSCAPE;
    private String file_name;
    private File file;
    private File save_directory;
    private boolean _isWorking = false;
    private boolean _inflateOnMainThread = true;
    private ProgressDialog _ringProgressDialog;
    private String _txtProgressMessage = "Generating Pdf..";
    private String _txtProgressTitle = "Please wait";
    protected ArrayList<InputStream> _pages_rendered = null;
    protected ArrayList<AbstractViewRenderer> _pages = null;
    private Handler _handler = new Handler();
    private Thread _thread = null;
    private Exception _error = null;
    private int _renderWidth = 0;
    private int _renderHeight = 0;
    private Callback _listener = null;

    public PdfDocument(Context ctx) {
        this.setContext(ctx);
        this._pages = new ArrayList();
        this._pages_rendered = new ArrayList();
    }

    public void addPage(AbstractViewRenderer page) {
        if (this._inflateOnMainThread) {
            this.renderView(page);
        } else {
            this._pages.add(page);
        }
    }

    public void addPage(Bitmap page) {
        ByteArrayInputStream stream = BitmapUtils.bitmapToPngInputStream(page);
        this._pages_rendered.add(stream);
    }

    public void clearPages() {
        this._pages.clear();
        this._pages_rendered.clear();
    }

    public void setRenderWidth(int value) {
        this._renderWidth = value;
    }

    public void setRenderHeight(int value) {
        this._renderHeight = value;
    }

    public void setContext(Context ctx) {
        this._ctx = ctx;
    }

    public A4_MODE getOrientation() {
        return this._orientation;
    }

    public void setOrientation(A4_MODE orientation) {
        this._orientation = orientation;
    }

    public void setProgressMessage(int resId) {
        this._txtProgressMessage = this._ctx.getString(resId);
    }

    public void setProgressTitle(int resId) {
        this._txtProgressTitle = this._ctx.getString(resId);
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setFileName(String fileName) {
        this.file_name = fileName;
    }

    public void setSaveDirectory(File directory) {
        this.save_directory = directory;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isWorking() {
        return this._isWorking;
    }

    public void setInflateOnMainThread(boolean enabled) {
        this._inflateOnMainThread = enabled;
    }

    public void createPdf(Context window) {
        if (this.isWorking()) {
            return;
        }
        Resources res = this._ctx.getResources();
        if (window != null) {
            if (this._ringProgressDialog != null) {
                this._ringProgressDialog.dismiss();
            }
            this._ringProgressDialog = ProgressDialog.show((Context)window, (CharSequence)this._txtProgressTitle, (CharSequence)this._txtProgressMessage, (boolean)true);
            if (!this._ringProgressDialog.isShowing()) {
                this._ringProgressDialog.show();
            }
        }
        this._thread = new Thread(new Runnable(){

            @Override
            public void run() {
                PdfDocument.this._isWorking = true;
                if (!PdfDocument.this._inflateOnMainThread) {
                    for (AbstractViewRenderer view : PdfDocument.this._pages) {
                        Log.i((String)PdfDocument.TAG_PDF_MY_XML, (String)"render page");
                        PdfDocument.this.renderView(view);
                    }
                }
                PdfDocument.this.internal_generatePdf();
                Log.i((String)PdfDocument.TAG_PDF_MY_XML, (String)"pdf 1");
                PdfDocument.this.clearPages();
                Log.i((String)PdfDocument.TAG_PDF_MY_XML, (String)"pdf 2");
                PdfDocument.this._handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PdfDocument.this._ringProgressDialog != null) {
                            PdfDocument.this._ringProgressDialog.dismiss();
                        }
                        if (PdfDocument.this._listener != null) {
                            if (PdfDocument.this._error != null) {
                                PdfDocument.this._listener.onError(PdfDocument.this._error);
                            } else {
                                PdfDocument.this._listener.onComplete(PdfDocument.this.file);
                            }
                        }
                        Log.i((String)PdfDocument.TAG_PDF_MY_XML, (String)"pdf 3");
                        PdfDocument.this.release();
                    }
                });
            }
        });
        this._thread.setPriority(10);
        this._thread.start();
    }

    public void setListener(Callback listener) {
        this._listener = listener;
    }

    private void internal_generatePdf() {
        String name = this.file_name == null ? sDefault_Filename_prefix + System.currentTimeMillis() : this.file_name;
        this.file_name = name + ".pdf";
        File dir = this.save_directory == null ? this._ctx.getExternalFilesDir(null) : this.save_directory;
        this.file = new File(dir, this.file_name);
        this._error = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            PDF pdf = new PDF((OutputStream)fos);
            for (InputStream inputStream : this._pages_rendered) {
                Page page = new Page(pdf, this._orientation.A4());
                Image image = new Image(pdf, inputStream, 1);
                Log.i((String)TAG_PDF_MY_XML, (String)"add page");
                inputStream.close();
                float ar = page.getWidth() / image.getWidth();
                image.scaleBy(ar);
                image.drawOn(page);
            }
            pdf.flush();
            fos.close();
        }
        catch (Exception exc) {
            this._error = exc;
        }
    }

    private void renderView(AbstractViewRenderer page) {
        page.attachContext(this._ctx);
        if ((this._renderWidth == 0 || this._renderHeight == 0) && Build.VERSION.SDK_INT <= 17) {
            Log.e((String)TAG_PDF_MY_XML, (String)"_renderWidth,_renderHeight==0 on API <= 17 can lead to bad behaviour with RelativeLayout and may crash, please use explicit values!!!");
        }
        Bitmap bmp = page.render(this._renderWidth, this._renderHeight);
        ByteArrayInputStream stream = BitmapUtils.bitmapToPngInputStream(bmp);
        page.disposeBitmap();
        this._pages_rendered.add(stream);
    }

    private void release() {
        this._pages.clear();
        this._pages_rendered.clear();
        this._error = null;
        this._isWorking = false;
        this.file_name = null;
        this.file = null;
        if (this._ringProgressDialog != null) {
            this._ringProgressDialog.dismiss();
            this._ringProgressDialog = null;
        }
    }

    @Override
    public void dispose() {
        this.release();
        this._listener = null;
        this._handler = null;
        this._thread = null;
        this._ringProgressDialog = null;
    }

    public static class Builder {
        private PdfDocument _doc = null;

        public Builder(Context ctx) {
            this._doc = new PdfDocument(ctx);
        }

        public PdfDocument create() {
            return this._doc;
        }

        public Builder addPage(AbstractViewRenderer page) {
            this._doc.addPage(page);
            return this;
        }

        public Builder renderWidth(int value) {
            this._doc.setRenderWidth(value);
            return this;
        }

        public Builder renderHeight(int value) {
            this._doc.setRenderHeight(value);
            return this;
        }

        public Builder addPage(Bitmap page) {
            this._doc.addPage(page);
            return this;
        }

        public Builder filename(String name) {
            this._doc.setFileName(name);
            return this;
        }

        public Builder saveDirectory(File directory) {
            this._doc.setSaveDirectory(directory);
            return this;
        }

        public Builder inflateOnMainThread(boolean enabled) {
            this._doc.setInflateOnMainThread(enabled);
            return this;
        }

        public Builder listener(Callback listener) {
            this._doc.setListener(listener);
            return this;
        }

        public Builder orientation(A4_MODE mode) {
            this._doc.setOrientation(mode);
            return this;
        }

        public Builder progressMessage(int resId) {
            this._doc.setProgressMessage(resId);
            return this;
        }

        public Builder progressTitle(int resId) {
            this._doc.setProgressTitle(resId);
            return this;
        }
    }

    public static interface Callback {
        public void onComplete(File var1);

        public void onError(Exception var1);
    }

    public static enum A4_MODE {
        PORTRAIT(0.707f, A4.PORTRAIT),
        LANDSCAPE(1.41f, A4.LANDSCAPE);

        private float _ar;
        private float[] _a4 = null;

        private A4_MODE(float ar, float[] mode) {
            this._ar = ar;
            this._a4 = mode;
        }

        public float aspectRatio() {
            return this._ar;
        }

        public float[] A4() {
            return this._a4;
        }
    }
}

