/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Font;
import com.pdfjet.Page;
import com.pdfjet.Paragraph;
import com.pdfjet.TextLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text {
    private List<Paragraph> paragraphs;
    private Font font;
    private Font fallbackFont;
    private float x;
    private float y;
    private float w;
    private float x_text;
    private float y_text;
    private float leading;
    private float paragraphLeading;
    private List<float[]> beginParagraphPoints;
    private List<float[]> endParagraphPoints;
    private float spaceBetweenTextLines;

    public Text(List<Paragraph> list) throws Exception {
        this.paragraphs = list;
        this.font = list.get((int)0).list.get(0).getFont();
        this.fallbackFont = list.get((int)0).list.get(0).getFallbackFont();
        this.leading = this.font.getBodyHeight();
        this.paragraphLeading = 2.0f * this.leading;
        this.beginParagraphPoints = new ArrayList<float[]>();
        this.endParagraphPoints = new ArrayList<float[]>();
        this.spaceBetweenTextLines = this.font.stringWidth(this.fallbackFont, " ");
    }

    public Text setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Text setWidth(float f) {
        this.w = f;
        return this;
    }

    public Text setLeading(float f) {
        this.leading = f;
        return this;
    }

    public Text setParagraphLeading(float f) {
        this.paragraphLeading = f;
        return this;
    }

    public List<float[]> getBeginParagraphPoints() {
        return this.beginParagraphPoints;
    }

    public List<float[]> getEndParagraphPoints() {
        return this.endParagraphPoints;
    }

    public Text setSpaceBetweenTextLines(float f) {
        this.spaceBetweenTextLines = f;
        return this;
    }

    public float[] drawOn(Page page) throws Exception {
        return this.drawOn(page, true);
    }

    public float[] drawOn(Page page, boolean bl) throws Exception {
        this.x_text = this.x;
        this.y_text = this.y + this.font.getAscent();
        for (Paragraph paragraph : this.paragraphs) {
            TextLine textLine;
            int n;
            int n2 = paragraph.list.size();
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < n2; ++n) {
                textLine = paragraph.list.get(n);
                stringBuilder.append(textLine.getText());
            }
            for (n = 0; n < n2; ++n) {
                textLine = paragraph.list.get(n);
                if (n == 0) {
                    this.beginParagraphPoints.add(new float[]{this.x_text, this.y_text});
                }
                textLine.setAltDescription(n == 0 ? stringBuilder.toString() : " ");
                textLine.setActualText(n == 0 ? stringBuilder.toString() : " ");
                float[] fArray = this.drawTextLine(page, this.x_text, this.y_text, textLine, bl);
                if (n == n2 - 1) {
                    this.endParagraphPoints.add(new float[]{fArray[0], fArray[1]});
                }
                this.x_text = fArray[0] + this.spaceBetweenTextLines;
                this.y_text = fArray[1];
            }
            this.x_text = this.x;
            this.y_text += this.paragraphLeading;
        }
        return new float[]{this.x_text, this.y_text + this.font.getDescent()};
    }

    public float[] drawTextLine(Page page, float f, float f2, TextLine textLine, boolean bl) throws Exception {
        Font font = textLine.getFont();
        Font font2 = textLine.getFallbackFont();
        int n = textLine.getColor();
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = textLine.getText().split("\\s+");
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = string = i == 0 ? stringArray[i] : " " + stringArray[i];
            if (font.stringWidth(font2, string) < this.w - (f - this.x)) {
                stringBuilder.append(string);
                f += font.stringWidth(font2, string);
                continue;
            }
            if (bl) {
                new TextLine(font, stringBuilder.toString()).setFallbackFont(font2).setLocation(f - font.stringWidth(font2, stringBuilder.toString()), f2).setColor(n).setUnderline(textLine.getUnderline()).setStrikeout(textLine.getStrikeout()).setLanguage(textLine.getLanguage()).setAltDescription(bl2 ? textLine.getAltDescription() : " ").setActualText(bl2 ? textLine.getActualText() : " ").drawOn(page);
                bl2 = false;
            }
            f = this.x + font.stringWidth(font2, stringArray[i]);
            f2 += this.leading;
            stringBuilder.setLength(0);
            stringBuilder.append(stringArray[i]);
        }
        if (bl) {
            new TextLine(font, stringBuilder.toString()).setFallbackFont(font2).setLocation(f - font.stringWidth(font2, stringBuilder.toString()), f2).setColor(n).setUnderline(textLine.getUnderline()).setStrikeout(textLine.getStrikeout()).setLanguage(textLine.getLanguage()).setAltDescription(bl2 ? textLine.getAltDescription() : " ").setActualText(bl2 ? textLine.getActualText() : " ").drawOn(page);
            bl2 = false;
        }
        return new float[]{f, f2};
    }
}

