/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Drawable;
import com.pdfjet.Page;
import com.pdfjet.Point;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Drawable {
    private int color = 0;
    private float width = 0.3f;
    private String pattern = "[] 0";
    private boolean fill_shape = false;
    private boolean close_path = false;
    private List<Point> points = new ArrayList<Point>();
    private float box_x;
    private float box_y;
    private int lineCapStyle = 0;
    private int lineJoinStyle = 0;

    public void add(Point point) {
        this.points.add(point);
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setWidth(double d) {
        this.width = (float)d;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public void setClosePath(boolean bl) {
        this.close_path = bl;
    }

    public void setFillShape(boolean bl) {
        this.fill_shape = bl;
    }

    public void setLineCapStyle(int n) {
        this.lineCapStyle = n;
    }

    public int getLineCapStyle() {
        return this.lineCapStyle;
    }

    public void setLineJoinStyle(int n) {
        this.lineJoinStyle = n;
    }

    public int getLineJoinStyle() {
        return this.lineJoinStyle;
    }

    public void placeIn(Box box) throws Exception {
        this.placeIn(box, 0.0f, 0.0f);
    }

    public void placeIn(Box box, double d, double d2) throws Exception {
        this.placeIn(box, (float)d, (float)d2);
    }

    public void placeIn(Box box, float f, float f2) throws Exception {
        this.box_x = box.x + f;
        this.box_y = box.y + f2;
    }

    public void scaleBy(double d) throws Exception {
        this.scaleBy((float)d);
    }

    public void scaleBy(float f) throws Exception {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = this.points.get(i);
            point.x *= f;
            point.y *= f;
        }
    }

    public static List<Point> getCurvePoints(float f, float f2, float f3, float f4, int n) throws Exception {
        float f5 = 0.551784f;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (n == 0) {
            arrayList.add(new Point(f, f2 - f4));
            arrayList.add(new Point(f + f5 * f3, f2 - f4, true));
            arrayList.add(new Point(f + f3, f2 - f5 * f4, true));
            arrayList.add(new Point(f + f3, f2));
        } else if (n == 1) {
            arrayList.add(new Point(f + f3, f2));
            arrayList.add(new Point(f + f3, f2 + f5 * f4, true));
            arrayList.add(new Point(f + f5 * f3, f2 + f4, true));
            arrayList.add(new Point(f, f2 + f4));
        } else if (n == 2) {
            arrayList.add(new Point(f, f2 + f4));
            arrayList.add(new Point(f - f5 * f3, f2 + f4, true));
            arrayList.add(new Point(f - f3, f2 + f5 * f4, true));
            arrayList.add(new Point(f - f3, f2));
        } else if (n == 3) {
            arrayList.add(new Point(f - f3, f2));
            arrayList.add(new Point(f - f3, f2 - f5 * f4, true));
            arrayList.add(new Point(f - f5 * f3, f2 - f4, true));
            arrayList.add(new Point(f, f2 - f4));
        }
        return arrayList;
    }

    @Override
    public void drawOn(Page page) throws Exception {
        Point point;
        int n;
        if (this.fill_shape) {
            page.setBrushColor(this.color);
        } else {
            page.setPenColor(this.color);
        }
        page.setPenWidth(this.width);
        page.setLinePattern(this.pattern);
        page.setLineCapStyle(this.lineCapStyle);
        page.setLineJoinStyle(this.lineJoinStyle);
        for (n = 0; n < this.points.size(); ++n) {
            point = this.points.get(n);
            point.x += this.box_x;
            point.y += this.box_y;
        }
        if (this.fill_shape) {
            page.drawPath(this.points, 'f');
        } else if (this.close_path) {
            page.drawPath(this.points, 's');
        } else {
            page.drawPath(this.points, 'S');
        }
        for (n = 0; n < this.points.size(); ++n) {
            point = this.points.get(n);
            point.x -= this.box_x;
            point.y -= this.box_y;
        }
    }
}

