/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.BMPImage;
import com.pdfjet.Box;
import com.pdfjet.Drawable;
import com.pdfjet.JPGImage;
import com.pdfjet.PDF;
import com.pdfjet.PNGImage;
import com.pdfjet.Page;
import java.io.InputStream;

public class Image
implements Drawable {
    protected int objNumber;
    protected float x;
    protected float y;
    protected float w;
    protected float h;
    protected long size;
    protected String uri;
    protected String key;
    private float box_x;
    private float box_y;
    private boolean rotate90 = false;
    private String language = null;
    private String altDescription = " ";
    private String actualText = " ";

    public Image(PDF pDF, InputStream inputStream, int n) throws Exception {
        if (n == 0) {
            JPGImage jPGImage = new JPGImage(inputStream);
            byte[] byArray = jPGImage.getData();
            this.w = jPGImage.getWidth();
            this.h = jPGImage.getHeight();
            if (jPGImage.getColorComponents() == 1) {
                this.addImage(pDF, byArray, null, n, "DeviceGray", 8);
            } else if (jPGImage.getColorComponents() == 3) {
                this.addImage(pDF, byArray, null, n, "DeviceRGB", 8);
            } else if (jPGImage.getColorComponents() == 4) {
                this.addImage(pDF, byArray, null, n, "DeviceCMYK", 8);
            }
        } else if (n == 1) {
            PNGImage pNGImage = new PNGImage(inputStream);
            byte[] byArray = pNGImage.getData();
            this.w = pNGImage.getWidth();
            this.h = pNGImage.getHeight();
            if (pNGImage.getColorType() == 0) {
                this.addImage(pDF, byArray, null, n, "DeviceGray", pNGImage.getBitDepth());
            } else if (pNGImage.getBitDepth() == 16) {
                this.addImage(pDF, byArray, null, n, "DeviceRGB", 16);
            } else {
                this.addImage(pDF, byArray, pNGImage.getAlpha(), n, "DeviceRGB", 8);
            }
        } else if (n == 2) {
            BMPImage bMPImage = new BMPImage(inputStream);
            byte[] byArray = bMPImage.getData();
            this.w = bMPImage.getWidth();
            this.h = bMPImage.getHeight();
            this.addImage(pDF, byArray, null, n, "DeviceRGB", 8);
        } else if (n == 3) {
            this.addImage(pDF, inputStream);
        }
        inputStream.close();
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void scaleBy(double d) {
        this.scaleBy((float)d, (float)d);
    }

    public void scaleBy(float f) {
        this.scaleBy(f, f);
    }

    public void scaleBy(float f, float f2) {
        this.w *= f;
        this.h *= f2;
    }

    public void placeIn(Box box) throws Exception {
        this.box_x = box.x;
        this.box_y = box.y;
    }

    public void setURIAction(String string) {
        this.uri = string;
    }

    public void setGoToAction(String string) {
        this.key = string;
    }

    public void setRotateCW90(boolean bl) {
        this.rotate90 = bl;
    }

    public Image setAltDescription(String string) {
        this.altDescription = string;
        return this;
    }

    public Image setActualText(String string) {
        this.actualText = string;
        return this;
    }

    public void drawOn(Page page) throws Exception {
        page.addBMC("Span", this.language, this.altDescription, this.actualText);
        this.x += this.box_x;
        this.y += this.box_y;
        page.append("q\n");
        if (this.rotate90) {
            page.append(this.h);
            page.append(' ');
            page.append(0.0f);
            page.append(' ');
            page.append(0.0f);
            page.append(' ');
            page.append(this.w);
            page.append(' ');
            page.append(this.x);
            page.append(' ');
            page.append(page.height - this.y);
            page.append(" cm\n");
            page.append("0.7071067811 -0.7071067811 0.7071067811 0.7071067811 0.0 0.0 cm\n");
            page.append("0.7071067811 -0.7071067811 0.7071067811 0.7071067811 0.0 0.0 cm\n");
        } else {
            page.append(this.w);
            page.append(' ');
            page.append(0.0f);
            page.append(' ');
            page.append(0.0f);
            page.append(' ');
            page.append(this.h);
            page.append(' ');
            page.append(this.x);
            page.append(' ');
            page.append(page.height - (this.y + this.h));
            page.append(" cm\n");
        }
        page.append("/Im");
        page.append(this.objNumber);
        page.append(" Do\n");
        page.append("Q\n");
        page.addEMC();
        if (this.uri != null || this.key != null) {
            page.addAnnotation(new Annotation(this.uri, this.key, this.x, page.height - this.y, this.x + this.w, page.height - (this.y + this.h), this.language, this.altDescription, this.actualText));
        }
    }

    public float getWidth() {
        return this.w;
    }

    public float getHeight() {
        return this.h;
    }

    private void addSoftMask(PDF pDF, byte[] byArray, String string, int n) throws Exception {
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /XObject\n");
        pDF.append("/Subtype /Image\n");
        pDF.append("/Filter /FlateDecode\n");
        pDF.append("/Width ");
        pDF.append((int)this.w);
        pDF.append('\n');
        pDF.append("/Height ");
        pDF.append((int)this.h);
        pDF.append('\n');
        pDF.append("/ColorSpace /");
        pDF.append(string);
        pDF.append('\n');
        pDF.append("/BitsPerComponent ");
        pDF.append(n);
        pDF.append('\n');
        pDF.append("/Length ");
        pDF.append(byArray.length);
        pDF.append('\n');
        pDF.append(">>\n");
        pDF.append("stream\n");
        pDF.append(byArray, 0, byArray.length);
        pDF.append("\nendstream\n");
        pDF.endobj();
        this.objNumber = pDF.objNumber;
    }

    private void addImage(PDF pDF, byte[] byArray, byte[] byArray2, int n, String string, int n2) throws Exception {
        if (byArray2 != null) {
            this.addSoftMask(pDF, byArray2, "DeviceGray", 8);
        }
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /XObject\n");
        pDF.append("/Subtype /Image\n");
        if (n == 0) {
            pDF.append("/Filter /DCTDecode\n");
        } else if (n == 1 || n == 2) {
            pDF.append("/Filter /FlateDecode\n");
            if (byArray2 != null) {
                pDF.append("/SMask ");
                pDF.append(this.objNumber);
                pDF.append(" 0 R\n");
            }
        }
        pDF.append("/Width ");
        pDF.append((int)this.w);
        pDF.append('\n');
        pDF.append("/Height ");
        pDF.append((int)this.h);
        pDF.append('\n');
        pDF.append("/ColorSpace /");
        pDF.append(string);
        pDF.append('\n');
        pDF.append("/BitsPerComponent ");
        pDF.append(n2);
        pDF.append('\n');
        if (string.equals("DeviceCMYK")) {
            pDF.append("/Decode [1.0 0.0 1.0 0.0 1.0 0.0 1.0 0.0]\n");
        }
        pDF.append("/Length ");
        pDF.append(byArray.length);
        pDF.append('\n');
        pDF.append(">>\n");
        pDF.append("stream\n");
        pDF.append(byArray, 0, byArray.length);
        pDF.append("\nendstream\n");
        pDF.endobj();
        pDF.images.add(this);
        this.objNumber = pDF.objNumber;
    }

    private void addImage(PDF pDF, InputStream inputStream) throws Exception {
        int n;
        this.w = this.getInt(inputStream);
        this.h = this.getInt(inputStream);
        byte by = (byte)inputStream.read();
        byte by2 = (byte)inputStream.read();
        if (by2 != 0) {
            pDF.newobj();
            pDF.append("<<\n");
            pDF.append("/Type /XObject\n");
            pDF.append("/Subtype /Image\n");
            pDF.append("/Filter /FlateDecode\n");
            pDF.append("/Width ");
            pDF.append(this.w);
            pDF.append('\n');
            pDF.append("/Height ");
            pDF.append(this.h);
            pDF.append('\n');
            pDF.append("/ColorSpace /DeviceGray\n");
            pDF.append("/BitsPerComponent 8\n");
            int n2 = this.getInt(inputStream);
            pDF.append("/Length ");
            pDF.append(n2);
            pDF.append('\n');
            pDF.append(">>\n");
            pDF.append("stream\n");
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            pDF.append(byArray, 0, n2);
            pDF.append("\nendstream\n");
            pDF.endobj();
            this.objNumber = pDF.objNumber;
        }
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /XObject\n");
        pDF.append("/Subtype /Image\n");
        pDF.append("/Filter /FlateDecode\n");
        if (by2 != 0) {
            pDF.append("/SMask ");
            pDF.append(this.objNumber);
            pDF.append(" 0 R\n");
        }
        pDF.append("/Width ");
        pDF.append(this.w);
        pDF.append('\n');
        pDF.append("/Height ");
        pDF.append(this.h);
        pDF.append('\n');
        pDF.append("/ColorSpace /");
        if (by == 1) {
            pDF.append("DeviceGray");
        } else if (by == 3 || by == 6) {
            pDF.append("DeviceRGB");
        }
        pDF.append('\n');
        pDF.append("/BitsPerComponent 8\n");
        pDF.append("/Length ");
        pDF.append(this.getInt(inputStream));
        pDF.append('\n');
        pDF.append(">>\n");
        pDF.append("stream\n");
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            pDF.append(byArray, 0, n);
        }
        pDF.append("\nendstream\n");
        pDF.endobj();
        pDF.images.add(this);
        this.objNumber = pDF.objNumber;
    }

    private int getInt(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.read(byArray, 0, 4);
        int n = 0;
        n |= byArray[0] & 0xFF;
        n <<= 8;
        n |= byArray[1] & 0xFF;
        n <<= 8;
        n |= byArray[2] & 0xFF;
        n <<= 8;
        return n |= byArray[3] & 0xFF;
    }
}

