/*
 * Decompiled with CFR 0.152.
 */
package at.huber.youtubeExtractor;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import at.huber.youtubeExtractor.Format;
import at.huber.youtubeExtractor.VideoMeta;
import at.huber.youtubeExtractor.YtFile;
import com.evgenii.jsevaluator.JsEvaluator;
import com.evgenii.jsevaluator.interfaces.JsCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class YouTubeExtractor
extends AsyncTask<String, Void, SparseArray<YtFile>> {
    private static final boolean CACHING = true;
    static boolean LOGGING = false;
    private static final String LOG_TAG = "YouTubeExtractor";
    private static final String CACHE_FILE_NAME = "decipher_js_funct";
    private WeakReference<Context> refContext;
    private String videoID;
    private VideoMeta videoMeta;
    private boolean includeWebM = true;
    private boolean useHttp = false;
    private String cacheDirPath;
    private volatile String decipheredSignature;
    private static String decipherJsFileName;
    private static String decipherFunctions;
    private static String decipherFunctionName;
    private final Lock lock = new ReentrantLock();
    private final Condition jsExecuting = this.lock.newCondition();
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.115 Safari/537.36";
    private static final Pattern patYouTubePageLink;
    private static final Pattern patYouTubeShortLink;
    private static final Pattern patTitle;
    private static final Pattern patAuthor;
    private static final Pattern patChannelId;
    private static final Pattern patLength;
    private static final Pattern patViewCount;
    private static final Pattern patShortDescript;
    private static final Pattern patStatusOk;
    private static final Pattern patHlsvp;
    private static final Pattern patHlsItag;
    private static final Pattern patItag;
    private static final Pattern patEncSig;
    private static final Pattern patUrl;
    private static final Pattern patCipher;
    private static final Pattern patCipherUrl;
    private static final Pattern patVariableFunction;
    private static final Pattern patFunction;
    private static final Pattern patDecryptionJsFile;
    private static final Pattern patSignatureDecFunction;
    private static final SparseArray<Format> FORMAT_MAP;

    public YouTubeExtractor(@NonNull Context con) {
        this.refContext = new WeakReference<Context>(con);
        this.cacheDirPath = con.getCacheDir().getAbsolutePath();
    }

    protected void onPostExecute(SparseArray<YtFile> ytFiles) {
        this.onExtractionComplete(ytFiles, this.videoMeta);
    }

    public void extract(String youtubeLink, boolean parseDashManifest, boolean includeWebM) {
        this.includeWebM = includeWebM;
        this.execute(new String[]{youtubeLink});
    }

    protected abstract void onExtractionComplete(SparseArray<YtFile> var1, VideoMeta var2);

    protected SparseArray<YtFile> doInBackground(String ... params) {
        this.videoID = null;
        String ytUrl = params[0];
        if (ytUrl == null) {
            return null;
        }
        Matcher mat = patYouTubePageLink.matcher(ytUrl);
        if (mat.find()) {
            this.videoID = mat.group(3);
        } else {
            mat = patYouTubeShortLink.matcher(ytUrl);
            if (mat.find()) {
                this.videoID = mat.group(3);
            } else if (ytUrl.matches("\\p{Graph}+?")) {
                this.videoID = ytUrl;
            }
        }
        if (this.videoID != null) {
            try {
                return this.getStreamUrls();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.e((String)LOG_TAG, (String)"Wrong YouTube link format");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparseArray<YtFile> getStreamUrls() throws IOException, InterruptedException {
        Matcher mat;
        String streamMap;
        String ytInfoUrl = this.useHttp ? "http://" : "https://";
        ytInfoUrl = ytInfoUrl + "www.youtube.com/get_video_info?video_id=" + this.videoID + "&eurl=" + URLEncoder.encode("https://youtube.googleapis.com/v/" + this.videoID, "UTF-8");
        BufferedReader reader = null;
        URL getUrl = new URL(ytInfoUrl);
        if (LOGGING) {
            Log.d((String)LOG_TAG, (String)("infoUrl: " + ytInfoUrl));
        }
        HttpURLConnection urlConnection = (HttpURLConnection)getUrl.openConnection();
        urlConnection.setRequestProperty("User-Agent", USER_AGENT);
        try {
            reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            streamMap = reader.readLine();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            urlConnection.disconnect();
        }
        SparseArray encSignatures = null;
        streamMap = URLDecoder.decode(streamMap, "UTF-8");
        streamMap = streamMap.replace("\\u0026", "&");
        this.parseVideoMeta(streamMap);
        if (this.videoMeta.isLiveStream()) {
            Matcher mat2 = patHlsvp.matcher(streamMap);
            if (mat2.find()) {
                String hlsvp = URLDecoder.decode(mat2.group(1), "UTF-8");
                SparseArray ytFiles = new SparseArray();
                getUrl = new URL(hlsvp);
                urlConnection = (HttpURLConnection)getUrl.openConnection();
                urlConnection.setRequestProperty("User-Agent", USER_AGENT);
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("https://") && !line.startsWith("http://") || !(mat2 = patHlsItag.matcher(line)).find()) continue;
                        int itag = Integer.parseInt(mat2.group(1));
                        YtFile newFile = new YtFile((Format)FORMAT_MAP.get(itag), line);
                        ytFiles.put(itag, (Object)newFile);
                    }
                }
                finally {
                    reader.close();
                    urlConnection.disconnect();
                }
                if (ytFiles.size() == 0) {
                    if (LOGGING) {
                        Log.d((String)LOG_TAG, (String)streamMap);
                    }
                    return null;
                }
                return ytFiles;
            }
            return null;
        }
        boolean sigEnc = true;
        boolean statusFail = false;
        if (!patCipher.matcher(streamMap).find()) {
            sigEnc = false;
            if (!patStatusOk.matcher(streamMap).find()) {
                statusFail = true;
            }
        }
        if (sigEnc || statusFail) {
            if (decipherJsFileName == null || decipherFunctions == null || decipherFunctionName == null) {
                this.readDecipherFunctFromCache();
            }
            if (LOGGING) {
                Log.d((String)LOG_TAG, (String)"Get from youtube page");
            }
            getUrl = new URL("https://youtube.com/watch?v=" + this.videoID);
            urlConnection = (HttpURLConnection)getUrl.openConnection();
            urlConnection.setRequestProperty("User-Agent", USER_AGENT);
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuilder sbStreamMap = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sbStreamMap.append(line.replace("\\\"", "\""));
                }
                streamMap = sbStreamMap.toString();
            }
            finally {
                reader.close();
                urlConnection.disconnect();
            }
            encSignatures = new SparseArray();
            mat = patDecryptionJsFile.matcher(streamMap);
            if (mat.find()) {
                String curJsFileName = mat.group(0).replace("\\/", "/");
                if (decipherJsFileName == null || !decipherJsFileName.equals(curJsFileName)) {
                    decipherFunctions = null;
                    decipherFunctionName = null;
                }
                decipherJsFileName = curJsFileName;
            }
        }
        SparseArray ytFiles = new SparseArray();
        mat = sigEnc ? patCipher.matcher(streamMap) : patUrl.matcher(streamMap);
        while (mat.find()) {
            Matcher mat2;
            String url;
            String sig = null;
            if (sigEnc) {
                String cipher = mat.group(1);
                Matcher mat22 = patCipherUrl.matcher(cipher);
                if (!mat22.find()) continue;
                url = URLDecoder.decode(mat22.group(1), "UTF-8");
                mat22 = patEncSig.matcher(cipher);
                if (!mat22.find()) continue;
                sig = URLDecoder.decode(mat22.group(1), "UTF-8");
            } else {
                url = mat.group(1);
            }
            if (!(mat2 = patItag.matcher(url)).find()) continue;
            int itag = Integer.parseInt(mat2.group(1));
            if (FORMAT_MAP.get(itag) == null) {
                if (!LOGGING) continue;
                Log.d((String)LOG_TAG, (String)("Itag not in list:" + itag));
                continue;
            }
            if (!this.includeWebM && ((Format)FORMAT_MAP.get(itag)).getExt().equals("webm") || url.contains("&source=yt_otf&")) continue;
            if (LOGGING) {
                Log.d((String)LOG_TAG, (String)("Itag found:" + itag));
            }
            if (sig != null) {
                encSignatures.append(itag, (Object)sig);
            }
            Format format = (Format)FORMAT_MAP.get(itag);
            YtFile newVideo = new YtFile(format, url);
            ytFiles.put(itag, (Object)newVideo);
        }
        if (encSignatures != null) {
            String signature;
            if (LOGGING) {
                Log.d((String)LOG_TAG, (String)("Decipher signatures: " + encSignatures.size() + ", videos: " + ytFiles.size()));
            }
            this.decipheredSignature = null;
            if (this.decipherSignature(encSignatures)) {
                this.lock.lock();
                try {
                    this.jsExecuting.await(7L, TimeUnit.SECONDS);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if ((signature = this.decipheredSignature) == null) {
                return null;
            }
            String[] sigs = signature.split("\n");
            for (int i = 0; i < encSignatures.size() && i < sigs.length; ++i) {
                int key = encSignatures.keyAt(i);
                String url = ((YtFile)ytFiles.get(key)).getUrl();
                url = url + "&sig=" + sigs[i];
                YtFile newFile = new YtFile((Format)FORMAT_MAP.get(key), url);
                ytFiles.put(key, (Object)newFile);
            }
        }
        if (ytFiles.size() == 0) {
            if (LOGGING) {
                Log.d((String)LOG_TAG, (String)streamMap);
            }
            return null;
        }
        return ytFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean decipherSignature(SparseArray<String> encSignatures) throws IOException {
        if (decipherFunctionName == null || decipherFunctions == null) {
            int i;
            int braces;
            String mainDecipherFunct;
            Pattern patMainVariable;
            Matcher mat;
            String javascriptFile;
            String decipherFunctUrl = "https://youtube.com" + decipherJsFileName;
            BufferedReader reader = null;
            URL url = new URL(decipherFunctUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("User-Agent", USER_AGENT);
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuilder sb = new StringBuilder("");
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append(" ");
                }
                javascriptFile = sb.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                urlConnection.disconnect();
            }
            if (LOGGING) {
                Log.d((String)LOG_TAG, (String)("Decipher FunctURL: " + decipherFunctUrl));
            }
            if (!(mat = patSignatureDecFunction.matcher(javascriptFile)).find()) return false;
            decipherFunctionName = mat.group(1);
            if (LOGGING) {
                Log.d((String)LOG_TAG, (String)("Decipher Functname: " + decipherFunctionName));
            }
            if ((mat = (patMainVariable = Pattern.compile("(var |\\s|,|;)" + decipherFunctionName.replace("$", "\\$") + "(=function\\((.{1,3})\\)\\{)")).matcher(javascriptFile)).find()) {
                mainDecipherFunct = "var " + decipherFunctionName + mat.group(2);
            } else {
                Pattern patMainFunction = Pattern.compile("function " + decipherFunctionName.replace("$", "\\$") + "(\\((.{1,3})\\)\\{)");
                mat = patMainFunction.matcher(javascriptFile);
                if (!mat.find()) {
                    return false;
                }
                mainDecipherFunct = "function " + decipherFunctionName + mat.group(2);
            }
            int startIndex = mat.end();
            int braces2 = 1;
            for (int i2 = startIndex; i2 < javascriptFile.length(); ++i2) {
                if (braces2 == 0 && startIndex + 5 < i2) {
                    mainDecipherFunct = mainDecipherFunct + javascriptFile.substring(startIndex, i2) + ";";
                    break;
                }
                if (javascriptFile.charAt(i2) == '{') {
                    ++braces2;
                    continue;
                }
                if (javascriptFile.charAt(i2) != '}') continue;
                --braces2;
            }
            decipherFunctions = mainDecipherFunct;
            mat = patVariableFunction.matcher(mainDecipherFunct);
            block5: while (mat.find()) {
                String variableDef = "var " + mat.group(2) + "={";
                if (decipherFunctions.contains(variableDef)) continue;
                startIndex = javascriptFile.indexOf(variableDef) + variableDef.length();
                braces = 1;
                for (i = startIndex; i < javascriptFile.length(); ++i) {
                    if (braces == 0) {
                        decipherFunctions = decipherFunctions + variableDef + javascriptFile.substring(startIndex, i) + ";";
                        continue block5;
                    }
                    if (javascriptFile.charAt(i) == '{') {
                        ++braces;
                        continue;
                    }
                    if (javascriptFile.charAt(i) != '}') continue;
                    --braces;
                }
            }
            mat = patFunction.matcher(mainDecipherFunct);
            block7: while (mat.find()) {
                String functionDef = "function " + mat.group(2) + "(";
                if (decipherFunctions.contains(functionDef)) continue;
                startIndex = javascriptFile.indexOf(functionDef) + functionDef.length();
                braces = 0;
                for (i = startIndex; i < javascriptFile.length(); ++i) {
                    if (braces == 0 && startIndex + 5 < i) {
                        decipherFunctions = decipherFunctions + functionDef + javascriptFile.substring(startIndex, i) + ";";
                        continue block7;
                    }
                    if (javascriptFile.charAt(i) == '{') {
                        ++braces;
                        continue;
                    }
                    if (javascriptFile.charAt(i) != '}') continue;
                    --braces;
                }
            }
            if (LOGGING) {
                Log.d((String)LOG_TAG, (String)("Decipher Function: " + decipherFunctions));
            }
            this.decipherViaWebView(encSignatures);
            this.writeDeciperFunctToChache();
            return true;
        }
        this.decipherViaWebView(encSignatures);
        return true;
    }

    private void parseVideoMeta(String getVideoInfo) {
        boolean isLiveStream = false;
        String title = null;
        String author = null;
        String channelId = null;
        String shortDescript = null;
        long viewCount = 0L;
        long length = 0L;
        Matcher mat = patTitle.matcher(getVideoInfo);
        if (mat.find()) {
            title = mat.group(1);
        }
        if ((mat = patHlsvp.matcher(getVideoInfo)).find()) {
            isLiveStream = true;
        }
        if ((mat = patAuthor.matcher(getVideoInfo)).find()) {
            author = mat.group(1);
        }
        if ((mat = patChannelId.matcher(getVideoInfo)).find()) {
            channelId = mat.group(1);
        }
        if ((mat = patShortDescript.matcher(getVideoInfo)).find()) {
            shortDescript = mat.group(1);
        }
        if ((mat = patLength.matcher(getVideoInfo)).find()) {
            length = Long.parseLong(mat.group(1));
        }
        if ((mat = patViewCount.matcher(getVideoInfo)).find()) {
            viewCount = Long.parseLong(mat.group(1));
        }
        this.videoMeta = new VideoMeta(this.videoID, title, author, channelId, length, viewCount, isLiveStream, shortDescript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDecipherFunctFromCache() {
        File cacheFile = new File(this.cacheDirPath + "/" + CACHE_FILE_NAME);
        if (cacheFile.exists() && System.currentTimeMillis() - cacheFile.lastModified() < 1209600000L) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cacheFile), "UTF-8"));
                decipherJsFileName = reader.readLine();
                decipherFunctionName = reader.readLine();
                decipherFunctions = reader.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void setParseDashManifest(boolean parseDashManifest) {
    }

    public void setIncludeWebM(boolean includeWebM) {
        this.includeWebM = includeWebM;
    }

    public void setDefaultHttpProtocol(boolean useHttp) {
        this.useHttp = useHttp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDeciperFunctToChache() {
        File cacheFile = new File(this.cacheDirPath + "/" + CACHE_FILE_NAME);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), "UTF-8"));
            writer.write(decipherJsFileName + "\n");
            writer.write(decipherFunctionName + "\n");
            writer.write(decipherFunctions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void decipherViaWebView(SparseArray<String> encSignatures) {
        final Context context = (Context)this.refContext.get();
        if (context == null) {
            return;
        }
        final StringBuilder stb = new StringBuilder(decipherFunctions + " function decipher(");
        stb.append("){return ");
        for (int i = 0; i < encSignatures.size(); ++i) {
            int key = encSignatures.keyAt(i);
            if (i < encSignatures.size() - 1) {
                stb.append(decipherFunctionName).append("('").append((String)encSignatures.get(key)).append("')+\"\\n\"+");
                continue;
            }
            stb.append(decipherFunctionName).append("('").append((String)encSignatures.get(key)).append("')");
        }
        stb.append("};decipher();");
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                new JsEvaluator(context).evaluate(stb.toString(), new JsCallback(){

                    public void onResult(String result) {
                        YouTubeExtractor.this.lock.lock();
                        try {
                            YouTubeExtractor.this.decipheredSignature = result;
                            YouTubeExtractor.this.jsExecuting.signal();
                        }
                        finally {
                            YouTubeExtractor.this.lock.unlock();
                        }
                    }

                    public void onError(String errorMessage) {
                        YouTubeExtractor.this.lock.lock();
                        try {
                            if (LOGGING) {
                                Log.e((String)YouTubeExtractor.LOG_TAG, (String)errorMessage);
                            }
                            YouTubeExtractor.this.jsExecuting.signal();
                        }
                        finally {
                            YouTubeExtractor.this.lock.unlock();
                        }
                    }
                });
            }
        });
    }

    static {
        patYouTubePageLink = Pattern.compile("(http|https)://(www\\.|m.|)youtube\\.com/watch\\?v=(.+?)( |\\z|&)");
        patYouTubeShortLink = Pattern.compile("(http|https)://(www\\.|)youtu.be/(.+?)( |\\z|&)");
        patTitle = Pattern.compile("\"title\"\\s*:\\s*\"(.*?)\"");
        patAuthor = Pattern.compile("\"author\"\\s*:\\s*\"(.+?)\"");
        patChannelId = Pattern.compile("\"channelId\"\\s*:\\s*\"(.+?)\"");
        patLength = Pattern.compile("\"lengthSeconds\"\\s*:\\s*\"(\\d+?)\"");
        patViewCount = Pattern.compile("\"viewCount\"\\s*:\\s*\"(\\d+?)\"");
        patShortDescript = Pattern.compile("\"shortDescription\"\\s*:\\s*\"(.+?)\"");
        patStatusOk = Pattern.compile("status=ok(&|,|\\z)");
        patHlsvp = Pattern.compile("hlsvp=(.+?)(&|\\z)");
        patHlsItag = Pattern.compile("/itag/(\\d+?)/");
        patItag = Pattern.compile("itag=([0-9]+?)(&|\\z)");
        patEncSig = Pattern.compile("s=(.{10,}?)(\\\\\\\\u0026|\\z)");
        patUrl = Pattern.compile("\"url\"\\s*:\\s*\"(.+?)\"");
        patCipher = Pattern.compile("\"cipher\"\\s*:\\s*\"(.+?)\"");
        patCipherUrl = Pattern.compile("url=(.+?)(\\\\\\\\u0026|\\z)");
        patVariableFunction = Pattern.compile("([{; =])([a-zA-Z$][a-zA-Z0-9$]{0,2})\\.([a-zA-Z$][a-zA-Z0-9$]{0,2})\\(");
        patFunction = Pattern.compile("([{; =])([a-zA-Z$_][a-zA-Z0-9$]{0,2})\\(");
        patDecryptionJsFile = Pattern.compile("\\\\/s\\\\/player\\\\/([^\"]+?)\\.js");
        patSignatureDecFunction = Pattern.compile("\\b([\\w$]{2})\\s*=\\s*function\\((\\w+)\\)\\{\\s*\\2=\\s*\\2\\.split\\(\"\"\\)\\s*;");
        FORMAT_MAP = new SparseArray();
        FORMAT_MAP.put(17, (Object)new Format(17, "3gp", 144, Format.VCodec.MPEG4, Format.ACodec.AAC, 24, false));
        FORMAT_MAP.put(36, (Object)new Format(36, "3gp", 240, Format.VCodec.MPEG4, Format.ACodec.AAC, 32, false));
        FORMAT_MAP.put(5, (Object)new Format(5, "flv", 240, Format.VCodec.H263, Format.ACodec.MP3, 64, false));
        FORMAT_MAP.put(43, (Object)new Format(43, "webm", 360, Format.VCodec.VP8, Format.ACodec.VORBIS, 128, false));
        FORMAT_MAP.put(18, (Object)new Format(18, "mp4", 360, Format.VCodec.H264, Format.ACodec.AAC, 96, false));
        FORMAT_MAP.put(22, (Object)new Format(22, "mp4", 720, Format.VCodec.H264, Format.ACodec.AAC, 192, false));
        FORMAT_MAP.put(160, (Object)new Format(160, "mp4", 144, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(133, (Object)new Format(133, "mp4", 240, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(134, (Object)new Format(134, "mp4", 360, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(135, (Object)new Format(135, "mp4", 480, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(136, (Object)new Format(136, "mp4", 720, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(137, (Object)new Format(137, "mp4", 1080, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(264, (Object)new Format(264, "mp4", 1440, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(266, (Object)new Format(266, "mp4", 2160, Format.VCodec.H264, Format.ACodec.NONE, true));
        FORMAT_MAP.put(298, (Object)new Format(298, "mp4", 720, Format.VCodec.H264, 60, Format.ACodec.NONE, true));
        FORMAT_MAP.put(299, (Object)new Format(299, "mp4", 1080, Format.VCodec.H264, 60, Format.ACodec.NONE, true));
        FORMAT_MAP.put(140, (Object)new Format(140, "m4a", Format.VCodec.NONE, Format.ACodec.AAC, 128, true));
        FORMAT_MAP.put(141, (Object)new Format(141, "m4a", Format.VCodec.NONE, Format.ACodec.AAC, 256, true));
        FORMAT_MAP.put(256, (Object)new Format(256, "m4a", Format.VCodec.NONE, Format.ACodec.AAC, 192, true));
        FORMAT_MAP.put(258, (Object)new Format(258, "m4a", Format.VCodec.NONE, Format.ACodec.AAC, 384, true));
        FORMAT_MAP.put(278, (Object)new Format(278, "webm", 144, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(242, (Object)new Format(242, "webm", 240, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(243, (Object)new Format(243, "webm", 360, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(244, (Object)new Format(244, "webm", 480, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(247, (Object)new Format(247, "webm", 720, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(248, (Object)new Format(248, "webm", 1080, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(271, (Object)new Format(271, "webm", 1440, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(313, (Object)new Format(313, "webm", 2160, Format.VCodec.VP9, Format.ACodec.NONE, true));
        FORMAT_MAP.put(302, (Object)new Format(302, "webm", 720, Format.VCodec.VP9, 60, Format.ACodec.NONE, true));
        FORMAT_MAP.put(308, (Object)new Format(308, "webm", 1440, Format.VCodec.VP9, 60, Format.ACodec.NONE, true));
        FORMAT_MAP.put(303, (Object)new Format(303, "webm", 1080, Format.VCodec.VP9, 60, Format.ACodec.NONE, true));
        FORMAT_MAP.put(315, (Object)new Format(315, "webm", 2160, Format.VCodec.VP9, 60, Format.ACodec.NONE, true));
        FORMAT_MAP.put(171, (Object)new Format(171, "webm", Format.VCodec.NONE, Format.ACodec.VORBIS, 128, true));
        FORMAT_MAP.put(249, (Object)new Format(249, "webm", Format.VCodec.NONE, Format.ACodec.OPUS, 48, true));
        FORMAT_MAP.put(250, (Object)new Format(250, "webm", Format.VCodec.NONE, Format.ACodec.OPUS, 64, true));
        FORMAT_MAP.put(251, (Object)new Format(251, "webm", Format.VCodec.NONE, Format.ACodec.OPUS, 160, true));
        FORMAT_MAP.put(91, (Object)new Format(91, "mp4", 144, Format.VCodec.H264, Format.ACodec.AAC, 48, false, true));
        FORMAT_MAP.put(92, (Object)new Format(92, "mp4", 240, Format.VCodec.H264, Format.ACodec.AAC, 48, false, true));
        FORMAT_MAP.put(93, (Object)new Format(93, "mp4", 360, Format.VCodec.H264, Format.ACodec.AAC, 128, false, true));
        FORMAT_MAP.put(94, (Object)new Format(94, "mp4", 480, Format.VCodec.H264, Format.ACodec.AAC, 128, false, true));
        FORMAT_MAP.put(95, (Object)new Format(95, "mp4", 720, Format.VCodec.H264, Format.ACodec.AAC, 256, false, true));
        FORMAT_MAP.put(96, (Object)new Format(96, "mp4", 1080, Format.VCodec.H264, Format.ACodec.AAC, 256, false, true));
    }
}

