/*
 * Decompiled with CFR 0.152.
 */
package com.ekn.gruzer.gaugelibrary;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.ekn.gruzer.gaugelibrary.FullGauge;
import com.ekn.gruzer.gaugelibrary.Range;
import java.util.ArrayList;
import java.util.List;

public class MultiGauge
extends FullGauge {
    private float distance = 30.0f;
    private float gaugeBGWidth = 20.0f;
    private double secondValue = 0.0;
    private double thirdValue = 0.0;
    private double secondMinValue = 0.0;
    private double thirdMinValue = 0.0;
    private double secondMaxValue = 100.0;
    private double thirdMaxValue = 100.0;
    private List<Range> secondRanges = new ArrayList<Range>();
    private List<Range> thirdRanges = new ArrayList<Range>();

    private RectF getSecondRect() {
        return new RectF(this.getRectLeft() + this.getPadding() + this.distance, this.getRectTop() + this.getPadding() + this.distance, this.getRectRight() - this.getPadding() - this.distance, this.getRectBottom() - this.getPadding() - this.distance);
    }

    private RectF getThirdRect() {
        return new RectF(this.getRectLeft() + this.getPadding() + this.distance * 2.0f, this.getRectTop() + this.getPadding() + this.distance * 2.0f, this.getRectRight() - this.getPadding() - this.distance * 2.0f, this.getRectBottom() - this.getPadding() - this.distance * 2.0f);
    }

    public MultiGauge(Context context) {
        super(context);
        this.init();
    }

    public MultiGauge(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MultiGauge(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MultiGauge(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void init() {
        this.getGaugeBackGround().setStrokeWidth(this.gaugeBGWidth);
        this.getGaugeBackGround().setColor(Color.parseColor((String)"#EAEAEA"));
        this.getTextPaint().setTextSize(35.0f);
        this.setPadding(20.0f);
        this.setDrawValueText(false);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBaseArc(canvas, this.getSecondRect(), this.getStartAngle(), this.getSweepAngle(), this.getGaugeBackGround(this.getSecondValue()));
        this.drawBaseArc(canvas, this.getThirdRect(), this.getStartAngle(), this.getSweepAngle(), this.getGaugeBackGround(this.getThirdValue()));
        this.drawValueArcOnCanvas(canvas, this.getSecondRect(), this.getStartAngle(), this.calculateSweepAngle(this.getSecondValue(), this.getSecondMinValue(), this.getSecondMaxValue()), this.getSecondValue(), this.getSecondRanges());
        this.drawValueArcOnCanvas(canvas, this.getThirdRect(), this.getStartAngle(), this.calculateSweepAngle(this.getThirdValue(), this.getThirdMinValue(), this.getThirdMaxValue()), this.getThirdValue(), this.getThirdRanges());
    }

    @Override
    protected void drawValuePoint(Canvas canvas) {
    }

    private Paint getRangePaint(double value, List<Range> ranges) {
        Paint color = new Paint(1);
        color.setStrokeWidth(this.gaugeBGWidth);
        color.setStyle(Paint.Style.STROKE);
        color.setColor(this.getGaugeBackGround().getColor());
        color.setStrokeCap(Paint.Cap.ROUND);
        for (Range range : ranges) {
            if (range.getTo() <= value) {
                color.setColor(range.getColor());
            }
            if (!(range.getFrom() <= value) || !(range.getTo() >= value)) continue;
            color.setColor(range.getColor());
        }
        return color;
    }

    public double getSecondValue() {
        return this.secondValue;
    }

    public void setSecondValue(double secondValue) {
        this.secondValue = secondValue;
        this.invalidate();
    }

    public double getThirdValue() {
        return this.thirdValue;
    }

    public void setThirdValue(double thirdValue) {
        this.thirdValue = thirdValue;
        this.invalidate();
    }

    public double getSecondMinValue() {
        return this.secondMinValue;
    }

    public void setSecondMinValue(double secondMinValue) {
        this.secondMinValue = secondMinValue;
    }

    public double getThirdMinValue() {
        return this.thirdMinValue;
    }

    public void setThirdMinValue(double thirdMinValue) {
        this.thirdMinValue = thirdMinValue;
    }

    public double getSecondMaxValue() {
        return this.secondMaxValue;
    }

    public void setSecondMaxValue(double secondMaxValue) {
        this.secondMaxValue = secondMaxValue;
    }

    public double getThirdMaxValue() {
        return this.thirdMaxValue;
    }

    public void setThirdMaxValue(double thirdMaxValue) {
        this.thirdMaxValue = thirdMaxValue;
    }

    public void addSecondRange(Range range) {
        this.secondRanges.add(range);
    }

    public void addThirdRange(Range range) {
        this.thirdRanges.add(range);
    }

    public List<Range> getSecondRanges() {
        return this.secondRanges;
    }

    public void setSeconRanges(List<Range> secondRanges) {
        this.secondRanges = secondRanges;
    }

    public List<Range> getThirdRanges() {
        return this.thirdRanges;
    }

    public void setThirdRanges(List<Range> thirdRanges) {
        this.thirdRanges = thirdRanges;
    }
}

