/*
 * Decompiled with CFR 0.152.
 */
package com.ekn.gruzer.gaugelibrary;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.util.AttributeSet;
import com.ekn.gruzer.gaugelibrary.AbstractGauge;
import com.ekn.gruzer.gaugelibrary.Range;

public class HalfGauge
extends AbstractGauge {
    private float needleStart = 30.0f;
    private float needleEnd = 150.0f;
    private float currentAngle = 30.0f;
    private float startAngle = 210.0f;
    private float sweepAngle = 120.0f;
    private Integer needleAngleNext;
    private Handler handler = new Handler();
    private boolean enableBackGroundShadow = true;
    private boolean enableNeedleShadow = true;
    private boolean enableAnimation = true;
    private int minValueTextColor = -7829368;
    private int maxValueTextColor = -7829368;
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            HalfGauge.this.invalidate();
        }
    };

    public HalfGauge(Context context) {
        super(context);
        this.init();
    }

    public HalfGauge(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public HalfGauge(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public HalfGauge(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.getGaugeBackGround().setStrokeWidth(100.0f);
        this.setPadding(20.0f);
    }

    private void drawShadow() {
        if (this.enableBackGroundShadow) {
            this.getGaugeBackGround().setShadowLayer(15.0f, 0.0f, 5.0f, 0x50000000);
            this.setLayerType(2, this.getGaugeBackGround());
        }
        if (this.enableNeedleShadow) {
            this.getNeedlePaint().setShadowLayer(10.0f, 0.0f, 5.0f, 0x50000000);
            this.setLayerType(2, this.getNeedlePaint());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (canvas == null) {
            return;
        }
        this.drawShadow();
        canvas.save();
        canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 50.0f * this.getScaleRatio().floatValue());
        canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
        canvas.drawArc(this.getRectF(), this.startAngle, this.sweepAngle, false, this.getGaugeBackGround());
        this.drawRange(canvas);
        canvas.restore();
        canvas.save();
        canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 50.0f * this.getScaleRatio().floatValue());
        canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
        canvas.rotate((float)this.getNeedleAngle(), this.getRectRight() / 2.0f, this.getRectBottom() / 2.0f);
        canvas.drawLine(-30.0f, 200.0f, 200.0f, 200.0f, this.getNeedlePaint());
        canvas.drawOval(190.0f, 190.0f, 210.0f, 210.0f, this.getNeedlePaint());
        canvas.restore();
        canvas.save();
        canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 50.0f * this.getScaleRatio().floatValue());
        canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
        canvas.drawText(this.getFormattedValue() + "", 200.0f, 240.0f, this.getTextPaint());
        canvas.restore();
        this.drawValueText(canvas);
        this.drawMinValue(canvas);
        this.drawMaxValue(canvas);
    }

    private void drawValueText(Canvas canvas) {
        canvas.save();
        canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 50.0f * this.getScaleRatio().floatValue());
        canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
        canvas.drawText(this.getFormattedValue() + "", 200.0f, 240.0f, this.getTextPaint());
        canvas.restore();
    }

    private void drawMinValue(Canvas canvas) {
        canvas.save();
        canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 50.0f * this.getScaleRatio().floatValue());
        canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
        canvas.rotate(26.0f, 10.0f, 130.0f);
        canvas.drawText(this.getFormattedValue(this.getMinValue()) + "", 10.0f + this.getPadding(), 130.0f, this.getRangeValue(this.getMinValueTextColor()));
        canvas.restore();
    }

    private void drawMaxValue(Canvas canvas) {
        canvas.save();
        canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 50.0f * this.getScaleRatio().floatValue());
        canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
        canvas.rotate(-26.0f, 390.0f, 130.0f);
        canvas.drawText(this.getFormattedValue(this.getMaxValue()) + "", 390.0f - this.getPadding(), 130.0f, this.getRangeValue(this.getMaxValueTextColor()));
        canvas.restore();
    }

    private void drawRange(Canvas canvas) {
        for (Range range : this.getRanges()) {
            float startAngle = this.calculateStartAngle(range.getFrom());
            float sweepAngle = this.calculateSweepAngle(range.getFrom(), range.getTo());
            canvas.drawArc(this.getRectF(), startAngle, sweepAngle, false, this.getRangePaint(range.getColor()));
        }
    }

    private float calculateStartAngle(double from) {
        return this.sweepAngle / 100.0f * (float)this.getCalculateValuePercentage(from) + this.startAngle;
    }

    private float calculateSweepAngle(double from, double to) {
        return this.sweepAngle / 100.0f * (float)this.getCalculateValuePercentage(to) - this.sweepAngle / 100.0f * (float)this.getCalculateValuePercentage(from) + 0.5f;
    }

    public int getNeedleAngle() {
        if (this.needleAngleNext != null && this.enableAnimation) {
            if ((float)this.needleAngleNext.intValue() != this.currentAngle) {
                this.currentAngle = (float)this.needleAngleNext.intValue() < this.currentAngle ? (this.currentAngle -= 1.0f) : (this.currentAngle += 1.0f);
                this.handler.postDelayed(this.runnable, 5L);
            }
        } else {
            this.currentAngle = (this.needleEnd - this.needleStart) / 100.0f * (float)this.getCalculateValuePercentage() + this.needleStart;
        }
        return (int)this.currentAngle;
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.needleAngleNext = (int)((this.needleEnd - this.needleStart) / 100.0f * (float)this.getCalculateValuePercentage() + this.needleStart);
    }

    protected Paint getRangePaint(int color) {
        Paint range = new Paint();
        range.setColor(color);
        range.setAntiAlias(true);
        range.setStyle(Paint.Style.STROKE);
        range.setStrokeWidth(this.getGaugeBackGround().getStrokeWidth());
        return range;
    }

    protected Paint getRangeValue(int color) {
        Paint textPaint = new Paint(1);
        textPaint.setColor(color);
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setTextSize(15.0f);
        textPaint.setTextAlign(Paint.Align.CENTER);
        return textPaint;
    }

    public boolean isEnableBackGroundShadow() {
        return this.enableBackGroundShadow;
    }

    public void setEnableBackGroundShadow(boolean enableBackGroundShadow) {
        this.enableBackGroundShadow = enableBackGroundShadow;
    }

    public boolean isEnableNeedleShadow() {
        return this.enableNeedleShadow;
    }

    public void setEnableNeedleShadow(boolean enableNeedleShadow) {
        this.enableNeedleShadow = enableNeedleShadow;
    }

    public void enableAnimation(boolean enableAnimation) {
        this.enableAnimation = enableAnimation;
    }

    public boolean isEnableAnimation() {
        return this.enableAnimation;
    }

    public void setMinValueTextColor(int minValueTextColor) {
        this.minValueTextColor = minValueTextColor;
    }

    public void setMaxValueTextColor(int maxValueTextColor) {
        this.maxValueTextColor = maxValueTextColor;
    }

    public int getMinValueTextColor() {
        return this.minValueTextColor;
    }

    public int getMaxValueTextColor() {
        return this.maxValueTextColor;
    }
}

