/*
 * Decompiled with CFR 0.152.
 */
package com.ekn.gruzer.gaugelibrary;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.ekn.gruzer.gaugelibrary.AbstractGauge;
import com.ekn.gruzer.gaugelibrary.Range;
import java.util.List;

public class FullGauge
extends AbstractGauge {
    private float sweepAngle = 360.0f;
    private float startAngle = 270.0f;
    private float gaugeBGWidth = 20.0f;
    private boolean displayValuePoint = false;
    protected boolean drawValueText = true;

    public FullGauge(Context context) {
        super(context);
        this.init();
    }

    public FullGauge(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FullGauge(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public FullGauge(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.getGaugeBackGround().setStrokeWidth(this.gaugeBGWidth);
        this.getTextPaint().setTextSize(35.0f);
        this.setPadding(20.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBaseArc(canvas);
        this.drawValueArcOnCanvas(canvas);
        this.drawValueText(canvas);
        this.drawValuePoint(canvas);
    }

    private void drawBaseArc(Canvas canvas) {
        this.drawBaseArc(canvas, this.getRectF(), this.startAngle, this.sweepAngle, this.getGaugeBackGround(this.getValue()));
    }

    protected void drawBaseArc(Canvas canvas, RectF rectF, float startAngle, float sweepAngle, Paint paint) {
        this.prepareCanvas(canvas);
        canvas.drawArc(rectF, startAngle, sweepAngle, false, paint);
        this.finishCanvas(canvas);
    }

    protected void drawValuePoint(Canvas canvas) {
        if (this.displayValuePoint) {
            this.prepareCanvas(canvas);
            float rotateValue = this.calculateSweepAngle(this.getValue(), this.getMinValue(), this.getMaxValue());
            canvas.rotate(rotateValue, this.getRectRight() / 2.0f, this.getRectBottom() / 2.0f);
            canvas.drawCircle(200.0f, this.getPadding(), 8.0f, this.getRangePaintForValue(this.getValue(), this.getRanges()));
            canvas.drawLine(197.0f, 11.0f, 206.0f, 19.0f, this.getArrowPaint());
            canvas.drawLine(206.0f, 20.0f, 197.0f, 27.0f, this.getArrowPaint());
            this.finishCanvas(canvas);
        }
    }

    private Paint getArrowPaint() {
        Paint color = new Paint(1);
        color.setStrokeWidth(4.0f);
        color.setStyle(Paint.Style.STROKE);
        color.setColor(-1);
        color.setStrokeCap(Paint.Cap.ROUND);
        return color;
    }

    protected void prepareCanvas(Canvas canvas) {
        canvas.save();
        canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 200.0f * this.getScaleRatio().floatValue());
        canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
    }

    protected void finishCanvas(Canvas canvas) {
        canvas.restore();
    }

    private void drawValueText(Canvas canvas) {
        if (this.drawValueText) {
            canvas.save();
            canvas.translate((float)this.getWidth() / 2.0f - this.getRectRight() / 2.0f * this.getScaleRatio().floatValue(), (float)this.getHeight() / 2.0f - 220.0f * this.getScaleRatio().floatValue());
            canvas.scale(this.getScaleRatio().floatValue(), this.getScaleRatio().floatValue());
            canvas.drawText(this.getFormattedValue() + "", 200.0f, 240.0f, this.getTextPaint());
            canvas.restore();
        }
    }

    protected Paint getRangePaintForValue(double value, List<Range> ranges) {
        Paint color = new Paint(1);
        color.setStrokeWidth(this.gaugeBGWidth);
        color.setStyle(Paint.Style.STROKE);
        color.setStrokeCap(Paint.Cap.ROUND);
        color.setColor(this.getRangeColorForValue(value, ranges));
        return color;
    }

    private void drawValueArcOnCanvas(Canvas canvas) {
        float sweepAngle = this.calculateSweepAngle(this.getValue(), this.getMinValue(), this.getMaxValue());
        this.drawValueArcOnCanvas(canvas, this.getRectF(), this.getStartAngle(), sweepAngle, this.getValue(), this.getRanges());
    }

    protected void drawValueArcOnCanvas(Canvas canvas, RectF rectF, float startAngle, float sweepAngle, double value, List<Range> ranges) {
        this.prepareCanvas(canvas);
        canvas.drawArc(rectF, startAngle, sweepAngle, false, this.getRangePaintForValue(value, ranges));
        this.finishCanvas(canvas);
    }

    protected float calculateSweepAngle(double to, double min, double max) {
        float valuePer = this.getCalculateValuePercentage(min, max, to);
        return this.sweepAngle / 100.0f * valuePer;
    }

    protected float getSweepAngle() {
        return this.sweepAngle;
    }

    protected void setSweepAngle(float sweepAngle) {
        this.sweepAngle = sweepAngle;
    }

    protected float getStartAngle() {
        return this.startAngle;
    }

    protected void setStartAngle(float startAngle) {
        this.startAngle = startAngle;
    }

    protected float getGaugeBGWidth() {
        return this.gaugeBGWidth;
    }

    protected void setGaugeBGWidth(float gaugeBGWidth) {
        this.gaugeBGWidth = gaugeBGWidth;
    }

    public boolean isDisplayValuePoint() {
        return this.displayValuePoint;
    }

    public void setDisplayValuePoint(boolean displayValuePoint) {
        this.displayValuePoint = displayValuePoint;
    }

    protected boolean isDrawValueText() {
        return this.drawValueText;
    }

    protected void setDrawValueText(boolean drawValueText) {
        this.drawValueText = drawValueText;
    }
}

