/*
 * Decompiled with CFR 0.152.
 */
package com.ekn.gruzer.gaugelibrary;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.ekn.gruzer.gaugelibrary.Range;
import com.ekn.gruzer.gaugelibrary.ValueFormatterImpl;
import com.ekn.gruzer.gaugelibrary.contract.ValueFormatter;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractGauge
extends View {
    private List<Range> ranges = new ArrayList<Range>();
    private double value = 0.0;
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private Paint needleColor;
    private Paint gaugeBackGround;
    private int gaugeBGColor = Color.parseColor((String)"#EAEAEA");
    private Paint textPaint;
    private float rectTop = 0.0f;
    private float rectLeft = 0.0f;
    private float rectRight = 400.0f;
    private float rectBottom = 400.0f;
    private float padding = 0.0f;
    private RectF rectF;
    private boolean useRangeBGColor = false;
    private ValueFormatter formatter = new ValueFormatterImpl();

    public AbstractGauge(Context context) {
        super(context);
    }

    public AbstractGauge(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AbstractGauge(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public AbstractGauge(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.getScaleRatio();
    }

    protected RectF getRectF() {
        if (this.rectF == null) {
            this.rectF = new RectF(this.rectLeft + this.padding, this.rectTop + this.padding, this.rectRight - this.padding, this.rectBottom - this.padding);
        }
        return this.rectF;
    }

    protected Float getScaleRatio() {
        int measuredHeight = this.getMeasuredHeight();
        int measuredWidth = this.getMeasuredWidth();
        float minSize = (float)Math.min(measuredHeight, measuredWidth) / 1.0f;
        float maxSize = (float)Math.max(measuredHeight, measuredWidth) / 1.0f;
        float f1 = minSize / 400.0f;
        float f2 = minSize / 200.0f;
        if (measuredWidth > measuredHeight) {
            if (f2 > f1) {
                return Float.valueOf(f1);
            }
        } else {
            return Float.valueOf(minSize / 400.0f);
        }
        return Float.valueOf(maxSize / 400.0f);
    }

    public void addRange(Range range) {
        if (range == null) {
            return;
        }
        this.ranges.add(range);
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<Range> ranges) {
        this.ranges = ranges;
    }

    protected Paint getNeedlePaint() {
        if (this.needleColor == null) {
            this.needleColor = new Paint();
            this.needleColor.setColor(-16777216);
            this.needleColor.setAntiAlias(true);
            this.needleColor.setStyle(Paint.Style.FILL_AND_STROKE);
            this.needleColor.setStrokeWidth(5.0f);
        }
        return this.needleColor;
    }

    protected Paint getGaugeBackGround() {
        if (this.gaugeBackGround == null) {
            this.gaugeBackGround = new Paint();
            this.gaugeBackGround.setColor(this.gaugeBGColor);
            this.gaugeBackGround.setAntiAlias(true);
            this.gaugeBackGround.setStyle(Paint.Style.STROKE);
        }
        return this.gaugeBackGround;
    }

    protected Paint getGaugeBackGround(double value) {
        if (this.useRangeBGColor) {
            this.getGaugeBackGround().setColor(this.getRangeColorForValue(value));
            this.getGaugeBackGround().setAlpha(20);
        }
        return this.getGaugeBackGround();
    }

    protected int getRangeColorForValue(double value) {
        return this.getRangeColorForValue(value, this.ranges);
    }

    protected int getRangeColorForValue(double value, List<Range> ranges) {
        int color = -7829368;
        for (Range range : ranges) {
            if (range.getTo() <= value) {
                color = range.getColor();
            }
            if (!(range.getFrom() <= value) || !(range.getTo() >= value)) continue;
            color = range.getColor();
        }
        return color;
    }

    protected int getCalculateValuePercentage() {
        int value = this.getCalculateValuePercentage(this.getValue());
        return value;
    }

    protected int getCalculateValuePercentage(double value) {
        return this.getCalculateValuePercentage(this.getMinValue(), this.getMaxValue(), value);
    }

    protected int getCalculateValuePercentageOld(double min, double max, double value) {
        if (min >= value) {
            return 0;
        }
        if (max <= value) {
            return 100;
        }
        return (int)((value - min) / (max - min) * 100.0);
    }

    protected int getCalculateValuePercentage(double min, double max, double value) {
        if (min < 0.0 && max < 0.0 && min < max) {
            return this.getCalculateValuePercentageUseCaseOne(min, max, value);
        }
        if (min < 0.0 && max < 0.0 && min > max) {
            return this.getCalculateValuePercentageUseCaseTwo(min, max, value);
        }
        if (min >= 0.0 && max < 0.0 || min < 0.0 && max >= 0.0) {
            if (min > max) {
                return this.getCalculateValuePercentageUseCaseThree(min, max, value);
            }
            if (min < max) {
                return this.getCalculateValuePercentageUseCaseFoure(min, max, value);
            }
        }
        return this.getCalculateValuePercentageOld(min, max, value);
    }

    private int getCalculateValuePercentageUseCaseOne(double min, double max, double value) {
        if (value <= Math.min(min, max)) {
            return 0;
        }
        if (value >= Math.max(min, max)) {
            return 100;
        }
        double available = Math.abs(Math.min(min, max)) - Math.abs(Math.max(min, max));
        double minValue = Math.min(min, max);
        double result = Math.abs((minValue - value) / available * 100.0);
        return (int)result;
    }

    private int getCalculateValuePercentageUseCaseTwo(double min, double max, double value) {
        if (value <= Math.min(min, max)) {
            return 100;
        }
        if (value >= Math.max(min, max)) {
            return 0;
        }
        double available = Math.abs(Math.min(min, max)) - Math.abs(Math.max(min, max));
        double maxValue = Math.max(min, max);
        double result = Math.abs((maxValue - value) / available * 100.0);
        return (int)result;
    }

    private int getCalculateValuePercentageUseCaseThree(double min, double max, double value) {
        double available = Math.abs(min) + Math.abs(max);
        if (value <= Math.min(min, max)) {
            return 100;
        }
        if (value >= Math.max(min, max)) {
            return 0;
        }
        double positive = Math.max(min, max);
        double result = Math.abs((positive - value) / available * 100.0);
        return (int)result;
    }

    private int getCalculateValuePercentageUseCaseFoure(double min, double max, double value) {
        double available = Math.abs(min) + Math.abs(max);
        if (value <= Math.min(min, max)) {
            return 0;
        }
        if (value >= Math.max(min, max)) {
            return 100;
        }
        double negative = Math.abs(Math.min(min, max));
        double result = Math.abs((negative + value) / available * 100.0);
        return (int)result;
    }

    public void setValueColor(int color) {
        this.getTextPaint().setColor(color);
    }

    public int getValueColor() {
        return this.getTextPaint().getColor();
    }

    protected Paint getTextPaint() {
        if (this.textPaint == null) {
            this.textPaint = new Paint(1);
            this.textPaint.setColor(-16777216);
            this.textPaint.setStyle(Paint.Style.FILL);
            this.textPaint.setTextSize(25.0f);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
        }
        return this.textPaint;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getValue() {
        return this.value;
    }

    protected String getFormattedValue(double value) {
        String formatted = this.formatter.getFormattedValue(value);
        if (formatted == null) {
            return new ValueFormatterImpl().getFormattedValue(value);
        }
        return formatted;
    }

    protected String getFormattedValue() {
        return this.getFormattedValue(this.getValue());
    }

    public void setValue(double value) {
        this.value = value;
        this.invalidate();
    }

    public void setFormatter(ValueFormatter formatter) {
        this.formatter = formatter;
    }

    public void setNeedleColor(int color) {
        this.getNeedlePaint().setColor(color);
    }

    protected float getRectTop() {
        return this.rectTop;
    }

    protected void setRectTop(float rectTop) {
        this.rectTop = rectTop;
    }

    protected float getRectLeft() {
        return this.rectLeft;
    }

    protected void setRectLeft(float rectLeft) {
        this.rectLeft = rectLeft;
    }

    protected float getRectRight() {
        return this.rectRight;
    }

    protected void setRectRight(float rectRight) {
        this.rectRight = rectRight;
    }

    protected float getRectBottom() {
        return this.rectBottom;
    }

    protected void setRectBottom(float rectBottom) {
        this.rectBottom = rectBottom;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public boolean isUseRangeBGColor() {
        return this.useRangeBGColor;
    }

    public void setUseRangeBGColor(boolean useRangeBGColor) {
        this.useRangeBGColor = useRangeBGColor;
    }

    public void setGaugeBackGroundColor(int color) {
        this.gaugeBackGround.setColor(color);
        this.gaugeBGColor = color;
    }

    public int getGaugeBackgroundColor() {
        return this.gaugeBGColor;
    }
}

