/*
 * Decompiled with CFR 0.152.
 */
package in.goodiebag.carouselpicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import in.goodiebag.carouselpicker.CustomPageTransformer;
import in.goodiebag.carouselpicker.R;
import java.util.List;

public class CarouselPicker
extends ViewPager {
    public static int NOT_SPECIFIED;
    private int itemsVisible = 3;
    private float divisor;
    private float opacity;
    private int textMaxLines;
    private Mode mode = Mode.HORIZONTAL;

    public CarouselPicker(Context context) {
        this(context, null);
    }

    public CarouselPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context, attrs);
        this.init();
        this.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ((CarouselViewAdapter)CarouselPicker.this.getAdapter()).applyOpacity(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CarouselPicker);
            this.itemsVisible = array.getInteger(R.styleable.CarouselPicker_items_visible, this.itemsVisible);
            this.divisor = 1.0f + 1.0f / (float)(this.itemsVisible - 1);
            this.mode = Mode.values()[array.getInteger(R.styleable.CarouselPicker_orientation, 0)];
            this.opacity = array.getFloat(R.styleable.CarouselPicker_unselected_item_opacity, 1.0f);
            this.textMaxLines = array.getInt(R.styleable.CarouselPicker_text_max_lines, 0);
            array.recycle();
        }
        if (this.mode == Mode.VERTICAL) {
            this.setOverScrollMode(2);
        }
    }

    private void init() {
        this.setPageTransformer(false, new CustomPageTransformer(this.getContext(), this.mode));
        this.setClipChildren(false);
        this.setFadingEdgeLength(0);
    }

    public void setCurrentItem(int position) {
        super.setCurrentItem(position);
        ((CarouselViewAdapter)this.getAdapter()).applyOpacity(position);
    }

    public void setCurrentItem(int position, boolean smoothScroll) {
        super.setCurrentItem(position, smoothScroll);
        ((CarouselViewAdapter)this.getAdapter()).applyOpacity(position);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mode == Mode.HORIZONTAL || View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE) {
            int height = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                int h = child.getMeasuredHeight();
                if (h <= height) continue;
                height = h;
            }
            heightMeasureSpec = this.mode == Mode.HORIZONTAL ? View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(height * this.itemsVisible), (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = this.getMeasuredWidth();
        this.setPageMargin((int)((float)(-w) / this.divisor));
    }

    public void setAdapter(PagerAdapter adapter) {
        super.setAdapter(adapter);
        this.setOffscreenPageLimit(adapter.getCount());
        CarouselViewAdapter carouselAdapter = (CarouselViewAdapter)adapter;
        carouselAdapter.setOpactiy(this.opacity);
        carouselAdapter.setTextMaxLines(this.textMaxLines);
        carouselAdapter.setOnPageClickedListener(new CarouselViewAdapter.OnPageClickedListener(){

            @Override
            public void onPageClicked(int position) {
                CarouselPicker.this.setCurrentItem(position);
            }
        });
    }

    private MotionEvent swapXY(MotionEvent ev) {
        float width = this.getWidth();
        float height = this.getHeight();
        float newX = ev.getY() / height * width;
        float newY = ev.getX() / width * height;
        ev.setLocation(newX, newY);
        return ev;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercepted;
        if (this.mode == Mode.VERTICAL) {
            intercepted = super.onInterceptTouchEvent(this.swapXY(ev));
            this.swapXY(ev);
        } else {
            intercepted = super.onInterceptTouchEvent(ev);
        }
        return intercepted;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean handled = this.mode == Mode.VERTICAL ? super.onTouchEvent(this.swapXY(ev)) : super.onTouchEvent(ev);
        return handled;
    }

    public static class DrawableItem
    implements PickerItem {
        @DrawableRes
        private int drawable;
        private int color = NOT_SPECIFIED;
        private View view;

        public DrawableItem(@DrawableRes int drawable) {
            this.drawable = drawable;
        }

        public DrawableItem(@DrawableRes int drawable, @ColorInt int color) {
            this(drawable);
            this.color = color;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        @DrawableRes
        public int getDrawable() {
            return this.drawable;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public boolean hasDrawable() {
            return true;
        }

        @Override
        public void setView(View view) {
            this.view = view;
        }

        @Override
        public View getView() {
            return this.view;
        }
    }

    public static class TextItem
    implements PickerItem {
        private String text;
        private int textSize;
        private int color = NOT_SPECIFIED;
        private Typeface font;
        private FontStyle fontStyle;
        private View view;

        public TextItem(String text, int textSize) {
            this.text = text;
            this.textSize = textSize;
        }

        public TextItem(String text, int textSize, @ColorInt int color) {
            this(text, textSize);
            this.color = color;
        }

        public TextItem(String text, int textSize, Typeface font, FontStyle style) {
            this(text, textSize);
            this.font = font;
            this.fontStyle = style;
        }

        public TextItem(String text, int textSize, @ColorInt int color, Typeface font, FontStyle style) {
            this(text, textSize, color);
            this.font = font;
            this.fontStyle = style;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public Typeface getFont() {
            return this.font;
        }

        public FontStyle getFontStyle() {
            return this.fontStyle;
        }

        @Override
        public boolean hasDrawable() {
            return false;
        }

        @Override
        public int getDrawable() {
            return 0;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public void setView(View view) {
            this.view = view;
        }

        @Override
        public View getView() {
            return this.view;
        }

        public static enum FontStyle {
            NORMAL,
            BOLD,
            ITALIC,
            BOLD_ITALIC;

        }
    }

    public static interface PickerItem {
        public boolean hasDrawable();

        public String getText();

        @DrawableRes
        public int getDrawable();

        @ColorInt
        public int getColor();

        public void setView(View var1);

        public View getView();
    }

    public static class CarouselViewAdapter
    extends PagerAdapter {
        private List<PickerItem> items;
        private Context context;
        private int drawable;
        private int textColor = NOT_SPECIFIED;
        private int lastSelected = 0;
        private float opacity = 1.0f;
        private OnPageClickedListener onPageClickedListener;
        private int textMaxLines;

        public CarouselViewAdapter(Context context, List<PickerItem> items, int drawable) {
            this.context = context;
            this.drawable = drawable;
            this.items = items;
            if (this.drawable == 0) {
                this.drawable = R.layout.page;
            }
        }

        public int getCount() {
            return this.items.size();
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            View view = LayoutInflater.from((Context)this.context).inflate(this.drawable, null);
            ImageView iv = (ImageView)view.findViewById(R.id.iv);
            TextView tv = (TextView)view.findViewById(R.id.tv);
            PickerItem pickerItem = this.items.get(position);
            pickerItem.setView(view);
            if (position != this.lastSelected) {
                view.setAlpha(this.opacity);
            }
            if (pickerItem.hasDrawable()) {
                iv.setVisibility(0);
                tv.setVisibility(8);
                iv.setImageResource(pickerItem.getDrawable());
                if (pickerItem.getColor() != NOT_SPECIFIED) {
                    iv.setColorFilter(pickerItem.getColor());
                }
                iv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CarouselViewAdapter.this.onPageClickedListener != null) {
                            CarouselViewAdapter.this.onPageClickedListener.onPageClicked(position);
                        }
                    }
                });
            } else if (pickerItem.getText() != null) {
                iv.setVisibility(8);
                tv.setVisibility(0);
                TextItem textItem = (TextItem)pickerItem;
                tv.setText((CharSequence)textItem.getText());
                if (this.textMaxLines > 0) {
                    tv.setMaxLines(this.textMaxLines);
                    tv.setEllipsize(TextUtils.TruncateAt.END);
                }
                int color = this.textColor;
                if (textItem.getColor() != NOT_SPECIFIED) {
                    color = textItem.getColor();
                }
                if (color != NOT_SPECIFIED) {
                    tv.setTextColor(color);
                }
                if (textItem.getTextSize() != 0) {
                    tv.setTextSize((float)this.dpToPx(textItem.getTextSize()));
                }
                if (textItem.getFont() != null && textItem.getFontStyle() != null) {
                    tv.setTypeface(textItem.getFont(), textItem.getFontStyle().ordinal());
                }
                tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CarouselViewAdapter.this.onPageClickedListener != null) {
                            CarouselViewAdapter.this.onPageClickedListener.onPageClicked(position);
                        }
                    }
                });
            }
            view.setTag((Object)position);
            container.addView(view);
            return view;
        }

        public int getTextColor() {
            return this.textColor;
        }

        public void setTextColor(@ColorInt int textColor) {
            this.textColor = textColor;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        private void setOpactiy(float opactiy) {
            opactiy = Math.max(opactiy, 0.0f);
            this.opacity = opactiy = Math.min(opactiy, 1.0f);
        }

        private void applyOpacity(int position) {
            PickerItem current;
            PickerItem previous;
            if (this.lastSelected < this.items.size() && (previous = this.items.get(this.lastSelected)).getView() != null) {
                previous.getView().setAlpha(this.opacity);
            }
            if ((current = this.items.get(position)).getView() != null) {
                current.getView().setAlpha(1.0f);
            }
            this.lastSelected = position;
        }

        public void setOnPageClickedListener(OnPageClickedListener listener) {
            this.onPageClickedListener = listener;
        }

        private int dpToPx(int dp) {
            DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
            return Math.round(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics));
        }

        public void setTextMaxLines(int textMaxLines) {
            this.textMaxLines = textMaxLines;
        }

        static interface OnPageClickedListener {
            public void onPageClicked(int var1);
        }
    }

    public static enum Mode {
        HORIZONTAL,
        VERTICAL;

    }
}

