/*
 * Decompiled with CFR 0.152.
 */
package com.gkemon.XMLtoPDF;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import com.gkemon.XMLtoPDF.PdfGeneratorListener;
import com.gkemon.XMLtoPDF.model.FailureResponse;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static List<View> getViewListFromID(Activity activity, @IdRes List<Integer> viewIDList, PdfGeneratorListener pdfGeneratorListener) {
        ArrayList<View> viewList;
        block7: {
            viewList = new ArrayList<View>();
            try {
                if (activity != null) {
                    for (int viewID : viewIDList) {
                        if (activity.findViewById(0x1020002) != null && activity.findViewById(0x1020002).findViewById(viewID) != null) {
                            viewList.add(activity.findViewById(0x1020002).findViewById(viewID));
                            continue;
                        }
                        if (pdfGeneratorListener == null) continue;
                        pdfGeneratorListener.onFailure(new FailureResponse("Your provided activity is not containing your desired view. Please make sure that you are using right xml as activity content.Visit the doc for more clearance - https://github.com/GkEmonGON/Android-XML-to-PDF-Generator/blob/master/README.md"));
                    }
                } else if (pdfGeneratorListener != null) {
                    pdfGeneratorListener.onFailure(new FailureResponse("Please provide a valid activity. You are providing null activity."));
                }
            }
            catch (Exception exception) {
                if (pdfGeneratorListener == null) break block7;
                pdfGeneratorListener.onFailure(new FailureResponse(exception, "Error is happening in getViewListFromID() while creating Java's view object(s) from view ids"));
            }
        }
        return viewList;
    }

    public static List<View> getViewListMeasuringRoot(@NonNull List<View> viewList, PdfGeneratorListener pdfGeneratorListener) {
        ArrayList<View> result;
        block3: {
            result = new ArrayList<View>();
            try {
                for (View view : viewList) {
                    if (view == null) continue;
                    view.getRootView().measure(0, 0);
                    result.add(view);
                }
            }
            catch (Exception exception) {
                if (pdfGeneratorListener == null) break block3;
                pdfGeneratorListener.onFailure(new FailureResponse(exception, "Error is happening in getViewListMeasuringRoot() while creating Java's view object(s) from view ids"));
            }
        }
        return result;
    }

    public static List<View> getViewListFromLayout(Context context, PdfGeneratorListener pdfGeneratorListener, List<Integer> layoutList) {
        ArrayList<View> viewList;
        block3: {
            viewList = new ArrayList<View>();
            try {
                LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
                for (int layout : layoutList) {
                    View generatedView = inflater.inflate(layout, null);
                    viewList.add(generatedView);
                }
            }
            catch (Exception e) {
                if (pdfGeneratorListener == null) break block3;
                pdfGeneratorListener.onFailure(new FailureResponse(e, "Error is happening in getViewListFromLayout() while creating Java's view object(s) from layout resources"));
            }
        }
        return viewList;
    }
}

