/*
 * Decompiled with CFR 0.152.
 */
package com.gkemon.XMLtoPDF;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.pdf.PdfDocument;
import android.net.Uri;
import android.os.Environment;
import android.os.StrictMode;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import com.gkemon.XMLtoPDF.PdfGeneratorListener;
import com.gkemon.XMLtoPDF.Utils;
import com.gkemon.XMLtoPDF.model.FailureResponse;
import com.gkemon.XMLtoPDF.model.SuccessResponse;
import com.karumi.dexter.Dexter;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PdfGenerator {
    public static double postScriptThreshold = 0.75;
    public static final int a4HeightInPX = 3508;
    public static final int a4WidthInPX = 2480;
    public static final int a5HeightInPX = 1748;
    public static final int a5WidthInPX = 2480;
    public static int a4HeightInPostScript = (int)(3508.0 * postScriptThreshold);
    public static int a4WidthInPostScript = (int)(2480.0 * postScriptThreshold);
    public static int AS_LIKE_XML_WIDTH = 0;
    public static int AS_LIKE_XML_HEIGHT = 0;

    public static ContextStep getBuilder() {
        return new Builder();
    }

    public static class Builder
    implements Build,
    FileNameStep,
    PageSizeStep,
    LayoutXMLSourceIntakeStep,
    ViewSourceIntakeStep,
    ViewIDSourceIntakeStep,
    FromSourceStep,
    ContextStep {
        private static final int NO_XML_SELECTED_YET = -1;
        private int pageWidthInPixel = AS_LIKE_XML_WIDTH;
        private int pageHeightInPixel = AS_LIKE_XML_HEIGHT;
        private Context context;
        private PdfGeneratorListener pdfGeneratorListener;
        private List<View> viewList = new ArrayList<View>();
        private String fileName;
        private String targetPdf;
        private boolean openPdfFile = true;
        private String folderName;
        private String directoryPath;
        private Disposable disposable;

        private void postFailure(String errorMessage) {
            FailureResponse failureResponse = new FailureResponse(errorMessage);
            this.postLog(errorMessage);
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFailure(failureResponse);
            }
        }

        private void postFailure(Throwable throwable) {
            FailureResponse failureResponse = new FailureResponse(throwable);
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFailure(failureResponse);
            }
        }

        private void postLog(String logMessage) {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.showLog(logMessage);
            }
        }

        private void postOnGenerationStart() {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onStartPDFGeneration();
            }
        }

        private void postOnGenerationFinished() {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFinishPDFGeneration();
            }
        }

        private void postSuccess(PdfDocument pdfDocument, File file, int widthInPS, int heightInPS) {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onSuccess(new SuccessResponse(pdfDocument, file, widthInPS, heightInPS));
            }
        }

        private void openGeneratedPDF() {
            try {
                File file = new File(this.targetPdf);
                if (file.exists()) {
                    Uri path = FileProvider.getUriForFile((Context)this.context, (String)(this.context.getPackageName() + ".xmlToPdf.provider"), (File)file);
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setDataAndType(path, "application/pdf");
                    intent.setFlags(0x4000000);
                    intent.addFlags(1);
                    intent.addFlags(2);
                    intent.addFlags(0x40000000);
                    try {
                        this.context.startActivity(intent);
                    }
                    catch (ActivityNotFoundException e) {
                        this.postFailure(e);
                    }
                } else {
                    String path = TextUtils.isEmpty((CharSequence)this.directoryPath) ? "null" : this.directoryPath;
                    this.postFailure("PDF file is not existing in storage. Your Generated path is " + path);
                }
            }
            catch (Exception exception) {
                this.postFailure("Error occurred while opening the PDF. Error message : " + exception.getMessage());
            }
        }

        private void resetValue() {
            this.pageWidthInPixel = AS_LIKE_XML_WIDTH;
            this.pageHeightInPixel = AS_LIKE_XML_HEIGHT;
            postScriptThreshold = 0.75;
            a4HeightInPostScript = (int)(3508.0 * postScriptThreshold);
        }

        private void print() {
            try {
                if (this.context != null) {
                    PdfDocument document = new PdfDocument();
                    if (this.viewList == null || this.viewList.size() == 0) {
                        this.postLog("View list null or zero sized");
                    }
                    for (int i = 0; i < this.viewList.size(); ++i) {
                        this.resetValue();
                        View content = this.viewList.get(i);
                        if (this.pageWidthInPixel == AS_LIKE_XML_WIDTH && this.pageHeightInPixel == AS_LIKE_XML_HEIGHT) {
                            this.pageHeightInPixel = content.getHeight();
                            this.pageWidthInPixel = content.getWidth();
                            if (this.pageHeightInPixel == 0 && this.pageWidthInPixel == 0) {
                                if (content.getMeasuredWidth() == 0 && content.getMeasuredHeight() == 0) {
                                    content.measure(View.MeasureSpec.makeMeasureSpec((int)this.pageWidthInPixel, (int)0), View.MeasureSpec.makeMeasureSpec((int)this.pageHeightInPixel, (int)0));
                                }
                                this.pageHeightInPixel = content.getMeasuredHeight();
                                this.pageWidthInPixel = content.getMeasuredWidth();
                            }
                            postScriptThreshold = 1.0;
                            a4HeightInPostScript = this.pageHeightInPixel;
                        }
                        this.pageHeightInPixel = (int)((double)this.pageHeightInPixel * postScriptThreshold);
                        this.pageWidthInPixel = (int)((double)this.pageWidthInPixel * postScriptThreshold);
                        content.measure(View.MeasureSpec.makeMeasureSpec((int)this.pageWidthInPixel, (int)0x40000000), 0);
                        this.pageHeightInPixel = Math.max(content.getMeasuredHeight(), a4HeightInPostScript);
                        PdfDocument.PageInfo pageInfo = new PdfDocument.PageInfo.Builder(this.pageWidthInPixel, this.pageHeightInPixel, i + 1).create();
                        PdfDocument.Page page = document.startPage(pageInfo);
                        content.layout(0, 0, this.pageWidthInPixel, this.pageHeightInPixel);
                        content.draw(page.getCanvas());
                        document.finishPage(page);
                        content.invalidate();
                        content.requestLayout();
                    }
                    StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder();
                    StrictMode.setVmPolicy((StrictMode.VmPolicy)builder.build());
                    this.setUpDirectoryPath(this.context);
                    if (TextUtils.isEmpty((CharSequence)this.directoryPath)) {
                        this.postFailure("Cannot find the storage path to create the pdf file.");
                        return;
                    }
                    this.directoryPath = this.directoryPath + "/" + this.folderName + "/";
                    File file = new File(this.directoryPath);
                    if (!file.exists() && !file.mkdirs()) {
                        this.postLog("Folder is not created.file.mkdirs() is returning false");
                    }
                    this.targetPdf = this.directoryPath + this.fileName + ".pdf";
                    File filePath = new File(this.targetPdf);
                    this.disposeDisposable();
                    this.postOnGenerationStart();
                    this.disposable = Completable.fromAction(() -> document.writeTo((OutputStream)new FileOutputStream(filePath))).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(() -> {
                        document.close();
                        this.disposeDisposable();
                        this.postOnGenerationFinished();
                    }).subscribe(() -> {
                        this.postSuccess(document, filePath, this.pageWidthInPixel, this.pageHeightInPixel);
                        if (this.openPdfFile) {
                            this.openGeneratedPDF();
                        }
                    }, this::postFailure);
                } else {
                    this.postFailure("Context is null");
                }
            }
            catch (Exception e) {
                this.postFailure(e);
            }
        }

        private void disposeDisposable() {
            if (this.disposable != null && !this.disposable.isDisposed()) {
                this.disposable.dispose();
            }
        }

        private void setUpDirectoryPath(Context context) {
            String state = Environment.getExternalStorageState();
            if (!TextUtils.isEmpty((CharSequence)state) && "mounted".equals(state)) {
                this.postLog("Your external storage is mounted");
                String string = this.directoryPath = context.getExternalFilesDir(null) != null ? context.getExternalFilesDir(null).getAbsolutePath() : "";
                if (TextUtils.isEmpty((CharSequence)this.directoryPath)) {
                    this.postLog("context.getExternalFilesDir().getAbsolutePath() is returning null.");
                }
            } else {
                this.postLog("Your external storage is unmounted");
                String string = this.directoryPath = context.getFilesDir() != null ? context.getFilesDir().getAbsolutePath() : "";
                if (TextUtils.isEmpty((CharSequence)this.directoryPath)) {
                    this.postFailure("context.getFilesDir().getAbsolutePath() is also returning null.");
                } else {
                    this.postLog("PDF file creation path is " + this.directoryPath);
                }
            }
        }

        private boolean hasAllPermission(Context context) {
            if (context == null) {
                this.postFailure("Context is null");
                return false;
            }
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        }

        @Override
        public void build(PdfGeneratorListener pdfGeneratorListener) {
            this.pdfGeneratorListener = pdfGeneratorListener;
            if (this.hasAllPermission(this.context)) {
                this.print();
            } else {
                this.postLog("WRITE_EXTERNAL_STORAGE and READ_EXTERNAL_STORAGE Permission is not given. Permission taking popup (using https://github.com/Karumi/Dexter) is going to be shown");
                Dexter.withContext((Context)this.context).withPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"}).withListener(new MultiplePermissionsListener(){

                    public void onPermissionsChecked(MultiplePermissionsReport multiplePermissionsReport) {
                        for (PermissionDeniedResponse deniedResponse : multiplePermissionsReport.getDeniedPermissionResponses()) {
                            this.postLog("Denied permission: " + deniedResponse.getPermissionName());
                        }
                        for (PermissionGrantedResponse grantedResponse : multiplePermissionsReport.getGrantedPermissionResponses()) {
                            this.postLog("Granted permission: " + grantedResponse.getPermissionName());
                        }
                        if (multiplePermissionsReport.areAllPermissionsGranted()) {
                            this.print();
                        } else {
                            this.postLog("All necessary permission is not granted by user.Please do that first");
                        }
                    }

                    public void onPermissionRationaleShouldBeShown(List<PermissionRequest> list, PermissionToken permissionToken) {
                    }
                }).withErrorListener(error -> this.postLog("Error from Dexter (https://github.com/Karumi/Dexter) : " + error.toString())).check();
            }
        }

        @Override
        public FileNameStep fromView(View ... viewArrays) {
            this.viewList = Utils.getViewListMeasuringRoot(new ArrayList<View>(Arrays.asList(viewArrays)), this.pdfGeneratorListener);
            return this;
        }

        @Override
        public FileNameStep fromViewList(List<View> viewList) {
            this.viewList = Utils.getViewListMeasuringRoot(viewList, this.pdfGeneratorListener);
            return this;
        }

        @Override
        public Build openPDAfterGeneration(boolean openPdfFile) {
            this.openPdfFile = openPdfFile;
            return this;
        }

        @Override
        public FromSourceStep setContext(Context context) {
            this.context = context;
            return this;
        }

        @Override
        public FileNameStep setPageSize(PageSize pageSize) {
            return this;
        }

        @Override
        public Build setFolderNameOrPath(String folderName) {
            this.folderName = folderName;
            return this;
        }

        @Override
        public Build setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public FileNameStep fromViewID(@NonNull Activity activity, Integer ... xmlResourceList) {
            this.viewList = Utils.getViewListFromID(activity, Arrays.asList(xmlResourceList), this.pdfGeneratorListener);
            return this;
        }

        @Override
        public FileNameStep fromViewIDList(@NonNull Activity activity, List<Integer> viewIDList) {
            this.viewList = Utils.getViewListFromID(activity, viewIDList, this.pdfGeneratorListener);
            return this;
        }

        @Override
        public FileNameStep fromLayoutXML(Integer ... layouts) {
            this.viewList = Utils.getViewListFromLayout(this.context, this.pdfGeneratorListener, Arrays.asList(layouts));
            return this;
        }

        @Override
        public FileNameStep fromLayoutXMLList(@LayoutRes List<Integer> layoutXMLList) {
            this.viewList = Utils.getViewListFromLayout(this.context, this.pdfGeneratorListener, layoutXMLList);
            return this;
        }

        @Override
        public LayoutXMLSourceIntakeStep fromLayoutXMLSource() {
            return this;
        }

        @Override
        public ViewIDSourceIntakeStep fromViewIDSource() {
            return this;
        }

        @Override
        public ViewSourceIntakeStep fromViewSource() {
            return this;
        }
    }

    public static interface Build {
        public void build(PdfGeneratorListener var1);

        public Build setFolderNameOrPath(String var1);

        public Build openPDAfterGeneration(boolean var1);
    }

    public static interface FileNameStep {
        public Build setFileName(String var1);
    }

    public static interface PageSizeStep {
        public FileNameStep setPageSize(PageSize var1);
    }

    public static interface ViewIDSourceIntakeStep {
        public FileNameStep fromViewID(@NonNull Activity var1, Integer ... var2);

        public FileNameStep fromViewIDList(@NonNull Activity var1, @IdRes List<Integer> var2);
    }

    public static interface LayoutXMLSourceIntakeStep {
        public FileNameStep fromLayoutXML(Integer ... var1);

        public FileNameStep fromLayoutXMLList(@LayoutRes List<Integer> var1);
    }

    public static interface ViewSourceIntakeStep {
        public FileNameStep fromView(View ... var1);

        public FileNameStep fromViewList(List<View> var1);
    }

    public static interface FromSourceStep {
        public LayoutXMLSourceIntakeStep fromLayoutXMLSource();

        public ViewIDSourceIntakeStep fromViewIDSource();

        public ViewSourceIntakeStep fromViewSource();
    }

    public static interface ContextStep {
        public FromSourceStep setContext(Context var1);
    }

    public static enum PageSize {
        A4,
        A5,
        AS_LIKE_XML;

    }
}

