/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zjy.pdfview.R;
import com.zjy.pdfview.utils.PdfLog;

public class PdfLoadingLayout
extends FrameLayout {
    TextView waitTv;
    Button reloadTv;
    View waitLayout;
    LoadLayoutListener mListener;

    public PdfLoadingLayout(@NonNull Context context) {
        this(context, null);
    }

    public PdfLoadingLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PdfLoadingLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_pdf_loading, (ViewGroup)this);
        this.waitTv = (TextView)this.findViewById(R.id.waiting_tv);
        this.reloadTv = (Button)this.findViewById(R.id.reload_tv);
        this.waitLayout = this.findViewById(R.id.waiting_layout);
        this.reloadTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PdfLoadingLayout.this.mListener != null) {
                    PdfLoadingLayout.this.mListener.clickRetry();
                }
            }
        });
    }

    public void showLoading() {
        PdfLog.logDebug("showLoading");
        this.setVisibility(0);
        this.waitTv.setText((CharSequence)"\u52a0\u8f7d\u4e2d");
        this.reloadTv.setVisibility(8);
    }

    public void showContent() {
        PdfLog.logDebug("showContent");
        this.setVisibility(8);
    }

    public void showFail() {
        this.setVisibility(0);
        this.waitTv.setText((CharSequence)"\u52a0\u8f7d\u5931\u8d25");
        this.waitLayout.setVisibility(8);
        this.reloadTv.setVisibility(0);
    }

    public void setLoadLayoutListener(LoadLayoutListener listener) {
        this.mListener = listener;
    }

    public static interface LoadLayoutListener {
        public void clickRetry();
    }
}

