/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.zjy.pdfview.R;
import com.zjy.pdfview.widget.AbsControllerBar;

public class PDFControllerBar
extends AbsControllerBar
implements View.OnClickListener {
    private Button previousBtn;
    private Button nextBtn;
    private TextView pageIndexTv;

    public PDFControllerBar(Context context) {
        this(context, null);
    }

    public PDFControllerBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PDFControllerBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public View getView() {
        LinearLayout rootView = new LinearLayout(this.getContext());
        rootView.setOrientation(0);
        rootView.setGravity(17);
        this.setBackgroundColor(-1);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(PDFControllerBar.dip2px(this.getContext(), 8.0f));
        }
        this.previousBtn = new Button(this.getContext());
        this.previousBtn.setBackgroundResource(R.drawable.bg_operate_btn);
        this.previousBtn.setTextSize(2, 14.0f);
        this.previousBtn.setText((CharSequence)"\u4e0a\u4e00\u9875");
        rootView.addView((View)this.previousBtn, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, PDFControllerBar.dip2px(this.getContext(), 36.0f)));
        this.pageIndexTv = new TextView(this.getContext());
        this.pageIndexTv.setTextSize(2, 15.0f);
        this.pageIndexTv.setPadding(PDFControllerBar.dip2px(this.getContext(), 16.0f), 0, PDFControllerBar.dip2px(this.getContext(), 16.0f), 0);
        rootView.addView((View)this.pageIndexTv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pageIndexTv.setTypeface(Typeface.defaultFromStyle((int)1));
        this.pageIndexTv.setText((CharSequence)"1/1");
        this.nextBtn = new Button(this.getContext());
        this.nextBtn.setBackgroundResource(R.drawable.bg_operate_btn);
        this.nextBtn.setTextSize(2, 14.0f);
        this.nextBtn.setText((CharSequence)"\u4e0b\u4e00\u9875");
        rootView.addView((View)this.nextBtn, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, PDFControllerBar.dip2px(this.getContext(), 36.0f)));
        this.previousBtn.setOnClickListener((View.OnClickListener)this);
        this.nextBtn.setOnClickListener((View.OnClickListener)this);
        return rootView;
    }

    public void onClick(View view) {
        if (view == this.previousBtn) {
            this.clickPrevious();
        } else if (view == this.nextBtn) {
            this.clickNext();
        }
    }

    private static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @Override
    public void setPageIndexText(String text) {
        if (this.pageIndexTv != null && text != null) {
            this.pageIndexTv.setText((CharSequence)text);
        }
    }
}

