/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.utils.layoutmanager;

import android.content.Context;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.zjy.pdfview.utils.layoutmanager.MyPagerSnapHelper;
import com.zjy.pdfview.utils.layoutmanager.PagerChangedListener;

public class PageLayoutManager
extends LinearLayoutManager {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private RecyclerView mRecyclerView;
    private SnapHelper mPagerSnapHelper;
    private PagerChangedListener mOnViewPagerListener;
    private int mDrift;
    private RecyclerView.OnChildAttachStateChangeListener mChildAttachStateChangeListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(View view) {
            if (PageLayoutManager.this.mOnViewPagerListener != null && PageLayoutManager.this.getChildCount() == 1) {
                PageLayoutManager.this.mOnViewPagerListener.onInitComplete();
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
            if (PageLayoutManager.this.mDrift >= 0) {
                if (PageLayoutManager.this.mOnViewPagerListener != null) {
                    PageLayoutManager.this.mOnViewPagerListener.onPageRelease(true, PageLayoutManager.this.getPosition(view));
                }
            } else if (PageLayoutManager.this.mOnViewPagerListener != null) {
                PageLayoutManager.this.mOnViewPagerListener.onPageRelease(false, PageLayoutManager.this.getPosition(view));
            }
        }
    };

    public PageLayoutManager(Context context, int orientation) {
        super(context, orientation, false);
        this.init();
    }

    public PageLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.init();
    }

    private void init() {
        this.mPagerSnapHelper = new MyPagerSnapHelper();
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.mRecyclerView = view;
        this.mPagerSnapHelper.attachToRecyclerView(view);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.mChildAttachStateChangeListener);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        super.onLayoutChildren(recycler, state);
    }

    public void onScrollStateChanged(int state) {
        switch (state) {
            case 0: {
                View view = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this);
                if (view == null) {
                    return;
                }
                int position = this.getPosition(view);
                if (this.mOnViewPagerListener == null || this.getChildCount() != 1) break;
                this.mOnViewPagerListener.onPageSelected(position, position == this.getItemCount() - 1);
            }
        }
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.mDrift = dy;
        return super.scrollVerticallyBy(dy, recycler, state);
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.mDrift = dx;
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    public void setOnPagerChangeListener(PagerChangedListener listener) {
        this.mOnViewPagerListener = listener;
    }

    public int getCurrentPosition() {
        View view = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this);
        return view == null ? -1 : this.getPosition(view);
    }
}

