/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import com.zjy.pdfview.R;
import com.zjy.pdfview.widget.ScaleImageView;
import java.util.List;

@RequiresApi(api=21)
public class PdfPageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<Bitmap> pageList;

    public PdfPageAdapter(Context context, List<Bitmap> pageList) {
        this.context = context;
        this.pageList = pageList;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.layout_page_item, null));
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        Bitmap item = this.pageList.get(i);
        viewHolder.itemIv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.context.getResources().getDisplayMetrics().widthPixels, this.context.getResources().getDisplayMetrics().heightPixels - 300));
        viewHolder.itemIv.setImageBitmap(item);
    }

    public int getItemCount() {
        return this.pageList.size();
    }

    public void onViewAttachedToWindow(@NonNull ViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.itemIv.setScaleType(ImageView.ScaleType.FIT_CENTER);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        ScaleImageView itemIv;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.itemIv = (ScaleImageView)itemView.findViewById(R.id.pdf_page_iv);
        }
    }
}

