/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.os.AsyncTask;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import com.zjy.pdfview.R;
import com.zjy.pdfview.adapter.PdfPageAdapter;
import com.zjy.pdfview.download.DownloadResultBroadcast;
import com.zjy.pdfview.download.DownloadService;
import com.zjy.pdfview.download.IDownloadCallback;
import com.zjy.pdfview.utils.FileUtils;
import com.zjy.pdfview.utils.PdfLog;
import com.zjy.pdfview.utils.layoutmanager.PageLayoutManager;
import com.zjy.pdfview.utils.layoutmanager.PagerChangedListener;
import com.zjy.pdfview.widget.AbsControllerBar;
import com.zjy.pdfview.widget.IPDFController;
import com.zjy.pdfview.widget.PdfLoadingLayout;
import com.zjy.pdfview.widget.ScrollSlider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(api=21)
public class PdfView
extends FrameLayout
implements IDownloadCallback,
IPDFController.OperateListener {
    private ViewGroup rootView;
    private FrameLayout controllerContainer;
    private RecyclerView contentRv;
    private PdfLoadingLayout loadingLayout;
    private ScrollSlider scrollSlider;
    private int pageCount;
    private int currentIndex;
    private int quality;
    private String pdfLocalPath;
    private String pdfUrl;
    private List<Bitmap> pageList;
    private PdfRenderer pdfRenderer;
    private PdfRenderer.Page curPdfPage;
    private ParcelFileDescriptor parcelFileDescriptor;
    private PdfPageAdapter pageAdapter;
    private PageLayoutManager pageLayoutManager;
    private Intent serviceIntent;
    private RenderTask renderTask;
    private boolean hasRenderFinish;
    private DownloadResultBroadcast downloadReceiver;

    public PdfView(@NonNull Context context) {
        this(context, null);
    }

    public PdfView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PdfView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.handleStyleable(context, attrs);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStyleable(Context context, AttributeSet attrs) {
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PdfView, 0, 0);
        try {
            this.quality = ta.getInteger(R.styleable.PdfView_quality, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ta.recycle();
        }
    }

    private void init() {
        this.registerResultBroadcast();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_pdf_view, (ViewGroup)this);
        this.rootView = (ViewGroup)this.findViewById(R.id.pdf_root_view);
        this.controllerContainer = (FrameLayout)this.findViewById(R.id.button_group);
        this.loadingLayout = (PdfLoadingLayout)this.findViewById(R.id.loading_layout);
        this.contentRv = (RecyclerView)this.findViewById(R.id.content_rv);
        this.scrollSlider = (ScrollSlider)this.findViewById(R.id.scroll_slider);
        this.pageLayoutManager = new PageLayoutManager(this.getContext(), 1);
        this.pageLayoutManager.setOnPagerChangeListener(new PagerChangedListener(){

            @Override
            public void onInitComplete() {
            }

            @Override
            public void onPageRelease(boolean isNext, int position) {
                PdfView.this.scrollToPosition();
            }

            @Override
            public void onPageSelected(int position, boolean isBottom) {
            }
        });
        this.contentRv.setLayoutManager((RecyclerView.LayoutManager)this.pageLayoutManager);
        this.loadingLayout.setLoadLayoutListener(new PdfLoadingLayout.LoadLayoutListener(){

            @Override
            public void clickRetry() {
                if (!TextUtils.isEmpty((CharSequence)PdfView.this.pdfUrl)) {
                    PdfView.this.loadPdf(PdfView.this.pdfUrl);
                }
            }
        });
        this.pageList = new ArrayList<Bitmap>();
        this.pageAdapter = new PdfPageAdapter(this.getContext(), this.pageList);
        this.contentRv.setAdapter((RecyclerView.Adapter)this.pageAdapter);
        this.getOperateView().addOperateListener(this);
        this.scrollSlider.setScrollSlideListener(new ScrollSlider.ScrollSlideListener(){

            @Override
            public boolean scrolling(int scrollY) {
                int pageItemHeight = PdfView.this.contentRv.getHeight() / PdfView.this.pageCount;
                int scrollIndex = scrollY / pageItemHeight;
                if (scrollIndex >= 0 && scrollIndex < PdfView.this.pageLayoutManager.getItemCount()) {
                    PdfView.this.scrollSlider.setTranslationY(scrollY - scrollY % pageItemHeight);
                    PdfView.this.currentIndex = scrollIndex;
                    PdfView.this.pageLayoutManager.scrollToPosition(PdfView.this.currentIndex);
                    PdfView.this.getOperateView().setPageIndexText(PdfView.this.generatePageIndexText());
                }
                return true;
            }
        });
    }

    public void loadPdf(String url) {
        this.contentRv.setVisibility(8);
        this.loadingLayout.showLoading();
        if (!TextUtils.isEmpty((CharSequence)url)) {
            if (url.startsWith("http")) {
                this.pdfUrl = url;
                this.serviceIntent = new Intent(this.getContext(), DownloadService.class);
                this.serviceIntent.putExtra("DOWNLOAD_URL_KEY", url);
                this.getContext().startService(this.serviceIntent);
            } else {
                this.pdfLocalPath = url;
                this.openPdf();
            }
        }
    }

    public void setPDFController(AbsControllerBar controller) {
        if (this.controllerContainer == null || controller == null) {
            return;
        }
        this.controllerContainer.removeAllViews();
        this.controllerContainer.addView((View)controller, 0);
        controller.getLayoutParams().width = -1;
        controller.getLayoutParams().height = -2;
        controller.addOperateListener(this);
    }

    private void scrollToPosition() {
        this.pageLayoutManager.scrollToPosition(this.currentIndex);
        this.getOperateView().setPageIndexText(this.generatePageIndexText());
        this.scrollSlider();
    }

    private void scrollSlider() {
        int pageItemHeight = this.contentRv.getHeight() / this.pageCount;
        float scrollDistance = this.currentIndex * pageItemHeight;
        this.scrollSlider.setTranslationY(scrollDistance);
    }

    private AbsControllerBar getOperateView() {
        return (AbsControllerBar)this.controllerContainer.getChildAt(0);
    }

    private void registerResultBroadcast() {
        this.downloadReceiver = new DownloadResultBroadcast();
        this.downloadReceiver.setResultCallback(this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("DOWN_LOAD_ACTION");
        this.getContext().registerReceiver((BroadcastReceiver)this.downloadReceiver, intentFilter);
    }

    private void unregisterResultBroadcast() {
        this.getContext().unregisterReceiver((BroadcastReceiver)this.downloadReceiver);
    }

    private String generatePageIndexText() {
        return this.currentIndex + 1 + "/" + this.pageCount;
    }

    private void openPdf() {
        this.renderTask = new RenderTask();
        this.renderTask.execute(new Void[0]);
    }

    private ParcelFileDescriptor getFileDescriptor() {
        try {
            File file = this.pdfLocalPath.contains("asset") ? FileUtils.writeAssetsToFile(this.getContext(), this.pdfLocalPath) : new File(this.pdfLocalPath);
            this.parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.parcelFileDescriptor;
    }

    @Override
    public void clickPrevious() {
        this.currentIndex = this.pageLayoutManager.getCurrentPosition();
        if (this.currentIndex - 1 >= 0) {
            --this.currentIndex;
            this.scrollToPosition();
        }
    }

    @Override
    public void clickNext() {
        this.currentIndex = this.pageLayoutManager.getCurrentPosition();
        if (this.currentIndex + 1 < this.pageLayoutManager.getItemCount()) {
            ++this.currentIndex;
            this.scrollToPosition();
        }
    }

    @Override
    public void downloadSuccess(String path) {
    }

    @Override
    public void downloadFail() {
        this.loadingLayout.showFail();
    }

    @Override
    public void downloadComplete(String path) {
        PdfLog.logDebug("path: " + path);
        this.pdfLocalPath = path;
        if (TextUtils.isEmpty((CharSequence)this.pdfLocalPath)) {
            return;
        }
        this.openPdf();
    }

    public void release() {
        try {
            if (this.curPdfPage != null) {
                this.curPdfPage.close();
                this.curPdfPage = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.renderTask != null) {
            this.renderTask.cancel(true);
            this.renderTask = null;
        }
        this.unregisterResultBroadcast();
        if (this.serviceIntent != null) {
            this.getContext().stopService(this.serviceIntent);
        }
        if (this.hasRenderFinish && this.pdfRenderer != null) {
            this.pdfRenderer.close();
            this.pdfRenderer = null;
        }
        if (null != this.parcelFileDescriptor) {
            try {
                this.parcelFileDescriptor.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class RenderTask
    extends AsyncTask<Void, Void, Boolean> {
        protected Boolean doInBackground(Void ... voids) {
            try {
                PdfView.this.currentIndex = 0;
                PdfView.this.pdfRenderer = new PdfRenderer(PdfView.this.getFileDescriptor());
                PdfView.this.pageCount = PdfView.this.pdfRenderer.getPageCount();
                PdfView.this.pageList.clear();
                for (int i = 0; i < PdfView.this.pageCount; ++i) {
                    PdfRenderer.Page item = PdfView.this.pdfRenderer.openPage(i);
                    PdfView.this.curPdfPage = item;
                    int qualityRatio = PdfView.this.getResources().getDisplayMetrics().densityDpi / (PdfView.this.quality * 72);
                    Bitmap bitmap = Bitmap.createBitmap((int)(qualityRatio * item.getWidth()), (int)(qualityRatio * item.getHeight()), (Bitmap.Config)Bitmap.Config.ARGB_4444);
                    item.render(bitmap, null, null, 1);
                    item.close();
                    PdfView.this.pageList.add(bitmap);
                }
                PdfView.this.hasRenderFinish = true;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (result.booleanValue()) {
                PdfView.this.getOperateView().setPageIndexText(PdfView.this.generatePageIndexText());
                PdfView.this.pageAdapter.notifyDataSetChanged();
                PdfView.this.contentRv.setVisibility(0);
                PdfView.this.loadingLayout.showContent();
            } else {
                PdfView.this.loadingLayout.showFail();
            }
        }
    }
}

