/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.tcp;

import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.event.session.PacketErrorEvent;
import com.github.steveice10.packetlib.packet.Packet;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetInput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetOutput;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;

public class TcpPacketCodec
extends ByteToMessageCodec<Packet> {
    private final Session session;
    private final boolean client;

    public TcpPacketCodec(Session session, boolean client) {
        this.session = session;
        this.client = client;
    }

    public void encode(ChannelHandlerContext ctx, Packet packet, ByteBuf buf) throws Exception {
        block2: {
            int initial = buf.writerIndex();
            try {
                ByteBufNetOutput out = new ByteBufNetOutput(buf);
                this.session.getPacketProtocol().getPacketHeader().writePacketId(out, this.client ? this.session.getPacketProtocol().getServerboundId(packet) : this.session.getPacketProtocol().getClientboundId(packet));
                packet.write(out);
            }
            catch (Throwable t) {
                buf.writerIndex(initial);
                PacketErrorEvent e = new PacketErrorEvent(this.session, t);
                this.session.callEvent(e);
                if (e.shouldSuppress()) break block2;
                throw t;
            }
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        block4: {
            int initial = buf.readerIndex();
            try {
                Packet packet;
                ByteBufNetInput in = new ByteBufNetInput(buf);
                int id = this.session.getPacketProtocol().getPacketHeader().readPacketId(in);
                if (id == -1) {
                    buf.readerIndex(initial);
                    return;
                }
                Packet packet2 = packet = this.client ? this.session.getPacketProtocol().createClientboundPacket(id, in) : this.session.getPacketProtocol().createServerboundPacket(id, in);
                if (buf.readableBytes() > 0) {
                    throw new IllegalStateException("Packet \"" + packet.getClass().getSimpleName() + "\" not fully read.");
                }
                out.add(packet);
            }
            catch (Throwable t) {
                buf.readerIndex(buf.readerIndex() + buf.readableBytes());
                PacketErrorEvent e = new PacketErrorEvent(this.session, t);
                this.session.callEvent(e);
                if (e.shouldSuppress()) break block4;
                throw t;
            }
        }
    }
}

