/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.auth.service;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.Service;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AuthenticationService
extends Service {
    protected String accessToken;
    protected boolean loggedIn;
    protected String username;
    protected String password;
    protected GameProfile selectedProfile;
    protected List<GameProfile.Property> properties = new ArrayList<GameProfile.Property>();
    protected List<GameProfile> profiles = new ArrayList<GameProfile>();

    public AuthenticationService(URI defaultURI) {
        super(defaultURI);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        if (this.loggedIn && this.selectedProfile != null) {
            throw new IllegalStateException("Cannot change username while user is logged in and profile is selected.");
        }
        this.username = username;
    }

    public void setPassword(String password) {
        if (this.loggedIn && this.selectedProfile != null) {
            throw new IllegalStateException("Cannot change password while user is logged in and profile is selected.");
        }
        this.password = password;
    }

    public List<GameProfile.Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public List<GameProfile> getAvailableProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public GameProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public void setAccessToken(String accessToken) {
        if (this.loggedIn && this.selectedProfile != null) {
            throw new IllegalStateException("Cannot change access token while user is logged in and profile is selected.");
        }
        this.accessToken = accessToken;
    }

    public abstract void login() throws RequestException;

    public void logout() throws RequestException {
        if (!this.loggedIn) {
            throw new IllegalStateException("Cannot log out while not logged in.");
        }
        this.accessToken = null;
        this.loggedIn = false;
        this.properties.clear();
        this.profiles.clear();
        this.selectedProfile = null;
    }
}

