/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.packet;

import com.github.steveice10.packetlib.Server;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.codec.PacketCodecHelper;
import com.github.steveice10.packetlib.codec.PacketDefinition;
import com.github.steveice10.packetlib.codec.PacketSerializer;
import com.github.steveice10.packetlib.packet.BufferedPacket;
import com.github.steveice10.packetlib.packet.Packet;
import com.github.steveice10.packetlib.packet.PacketHeader;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class PacketProtocol {
    private final Int2ObjectMap<PacketDefinition<? extends Packet, ?>> serverbound = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<PacketDefinition<? extends Packet, ?>> clientbound = new Int2ObjectOpenHashMap();
    private final Map<Class<? extends Packet>, Integer> clientboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();
    private final Map<Class<? extends Packet>, Integer> serverboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();

    public abstract String getSRVRecordPrefix();

    public abstract PacketHeader getPacketHeader();

    public abstract PacketCodecHelper createHelper();

    public abstract void newClientSession(Session var1);

    public abstract void newServerSession(Server var1, Session var2);

    public final void clearPackets() {
        this.serverbound.clear();
        this.clientbound.clear();
        this.clientboundIds.clear();
        this.serverboundIds.clear();
    }

    public final <T extends Packet, H extends PacketCodecHelper> void register(int id, Class<T> packet, PacketSerializer<T, H> serializer) {
        this.registerServerbound(id, packet, serializer);
        this.registerClientbound(id, packet, serializer);
    }

    public final void register(PacketDefinition<? extends Packet, ?> definition) {
        this.registerServerbound(definition);
        this.registerClientbound(definition);
    }

    public final <T extends Packet, H extends PacketCodecHelper> void registerServerbound(int id, Class<T> packet, PacketSerializer<T, H> serializer) {
        this.registerServerbound(new PacketDefinition<T, H>(id, packet, serializer));
    }

    public final void registerServerbound(PacketDefinition<? extends Packet, ?> definition) {
        this.serverbound.put(definition.getId(), definition);
        this.serverboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public final <T extends Packet, H extends PacketCodecHelper> void registerClientbound(int id, Class<T> packet, PacketSerializer<T, H> serializer) {
        this.registerClientbound(new PacketDefinition<T, H>(id, packet, serializer));
    }

    public final void registerClientbound(PacketDefinition<? extends Packet, ?> definition) {
        this.clientbound.put(definition.getId(), definition);
        this.clientboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public <H extends PacketCodecHelper> Packet createClientboundPacket(int id, ByteBuf buf, H codecHelper) throws IOException {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.newInstance(buf, codecHelper);
    }

    public int getClientboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.clientboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered clientbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getClientboundId(Packet packet) {
        if (packet instanceof BufferedPacket) {
            return this.getClientboundId(((BufferedPacket)packet).getPacketClass());
        }
        return this.getClientboundId(packet.getClass());
    }

    public Class<? extends Packet> getClientboundClass(int id) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }

    public <H extends PacketCodecHelper> Packet createServerboundPacket(int id, ByteBuf buf, H codecHelper) throws IOException {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.newInstance(buf, codecHelper);
    }

    public int getServerboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.serverboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered serverbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getServerboundId(Packet packet) {
        if (packet instanceof BufferedPacket) {
            return this.getServerboundId(((BufferedPacket)packet).getPacketClass());
        }
        return this.getServerboundId(packet.getClass());
    }

    public Class<? extends Packet> getServerboundClass(int id) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }

    public PacketDefinition<?, ?> getServerboundDefinition(int id) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition;
    }

    public PacketDefinition<?, ?> getClientboundDefinition(int id) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition;
    }
}

