/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.cloudburstmc.math.vector.Vector3i;

public class ClientboundSetDefaultSpawnPositionPacket
implements MinecraftPacket {
    @NonNull
    private final Vector3i position;
    private final float angle;

    public ClientboundSetDefaultSpawnPositionPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.position = helper.readPosition(in);
        this.angle = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writePosition(out, this.position);
        out.writeFloat(this.angle);
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetDefaultSpawnPositionPacket)) {
            return false;
        }
        ClientboundSetDefaultSpawnPositionPacket other = (ClientboundSetDefaultSpawnPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getAngle(), other.getAngle()) != 0) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetDefaultSpawnPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getAngle());
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSetDefaultSpawnPositionPacket(position=" + this.getPosition() + ", angle=" + this.getAngle() + ")";
    }

    public ClientboundSetDefaultSpawnPositionPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundSetDefaultSpawnPositionPacket(position, this.angle);
    }

    public ClientboundSetDefaultSpawnPositionPacket withAngle(float angle) {
        return this.angle == angle ? this : new ClientboundSetDefaultSpawnPositionPacket(this.position, angle);
    }

    public ClientboundSetDefaultSpawnPositionPacket(@NonNull Vector3i position, float angle) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.angle = angle;
    }
}

