/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.CraftingBookCategory;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.data.game.recipe.Recipe;
import com.github.steveice10.mc.protocol.data.game.recipe.RecipeType;
import com.github.steveice10.mc.protocol.data.game.recipe.data.CookedRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.RecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapedRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapelessRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.SimpleCraftingRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.SmithingTransformRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.SmithingTrimRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.StoneCuttingRecipeData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundUpdateRecipesPacket
implements MinecraftPacket {
    @NonNull
    private final Recipe[] recipes;

    public ClientboundUpdateRecipesPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.recipes = new Recipe[helper.readVarInt(in)];
        for (int i = 0; i < this.recipes.length; ++i) {
            RecipeType type = RecipeType.from(helper.readResourceLocation(in));
            String identifier = helper.readResourceLocation(in);
            this.recipes[i] = new Recipe(type, identifier, switch (type) {
                case RecipeType.CRAFTING_SHAPELESS -> {
                    String group = helper.readString(in);
                    CraftingBookCategory category = CraftingBookCategory.from(helper.readVarInt(in));
                    Ingredient[] ingredients = new Ingredient[helper.readVarInt(in)];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = helper.readRecipeIngredient(in);
                    }
                    ItemStack result = helper.readItemStack(in);
                    yield new ShapelessRecipeData(group, category, ingredients, result);
                }
                case RecipeType.CRAFTING_SHAPED -> {
                    String group = helper.readString(in);
                    CraftingBookCategory category = CraftingBookCategory.from(helper.readVarInt(in));
                    int width = helper.readVarInt(in);
                    int height = helper.readVarInt(in);
                    Ingredient[] ingredients = new Ingredient[width * height];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = helper.readRecipeIngredient(in);
                    }
                    ItemStack result = helper.readItemStack(in);
                    boolean showNotification = in.readBoolean();
                    yield new ShapedRecipeData(width, height, group, category, ingredients, result, showNotification);
                }
                case RecipeType.SMELTING, RecipeType.BLASTING, RecipeType.SMOKING, RecipeType.CAMPFIRE_COOKING -> {
                    String group = helper.readString(in);
                    CraftingBookCategory category = CraftingBookCategory.from(helper.readVarInt(in));
                    Ingredient ingredient = helper.readRecipeIngredient(in);
                    ItemStack result = helper.readItemStack(in);
                    float experience = in.readFloat();
                    int cookingTime = helper.readVarInt(in);
                    yield new CookedRecipeData(group, category, ingredient, result, experience, cookingTime);
                }
                case RecipeType.STONECUTTING -> {
                    String group = helper.readString(in);
                    Ingredient ingredient = helper.readRecipeIngredient(in);
                    ItemStack result = helper.readItemStack(in);
                    yield new StoneCuttingRecipeData(group, ingredient, result);
                }
                case RecipeType.SMITHING_TRANSFORM -> {
                    Ingredient template = helper.readRecipeIngredient(in);
                    Ingredient base = helper.readRecipeIngredient(in);
                    Ingredient addition = helper.readRecipeIngredient(in);
                    ItemStack result = helper.readItemStack(in);
                    yield new SmithingTransformRecipeData(template, base, addition, result);
                }
                case RecipeType.SMITHING_TRIM -> {
                    Ingredient template = helper.readRecipeIngredient(in);
                    Ingredient base = helper.readRecipeIngredient(in);
                    Ingredient addition = helper.readRecipeIngredient(in);
                    yield new SmithingTrimRecipeData(template, base, addition);
                }
                default -> {
                    CraftingBookCategory category = CraftingBookCategory.from(helper.readVarInt(in));
                    yield new SimpleCraftingRecipeData(category);
                }
            });
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.recipes.length);
        block8: for (Recipe recipe : this.recipes) {
            helper.writeResourceLocation(out, recipe.getType().getResourceLocation());
            helper.writeResourceLocation(out, recipe.getIdentifier());
            switch (recipe.getType()) {
                case CRAFTING_SHAPELESS: {
                    RecipeData data = (ShapelessRecipeData)recipe.getData();
                    helper.writeString(out, ((ShapelessRecipeData)data).getGroup());
                    helper.writeVarInt(out, ((ShapelessRecipeData)data).getCategory().ordinal());
                    helper.writeVarInt(out, ((ShapelessRecipeData)data).getIngredients().length);
                    for (Ingredient ingredient : ((ShapelessRecipeData)data).getIngredients()) {
                        helper.writeRecipeIngredient(out, ingredient);
                    }
                    helper.writeItemStack(out, ((ShapelessRecipeData)data).getResult());
                    continue block8;
                }
                case CRAFTING_SHAPED: {
                    RecipeData data = (ShapedRecipeData)recipe.getData();
                    if (((ShapedRecipeData)data).getIngredients().length != ((ShapedRecipeData)data).getWidth() * ((ShapedRecipeData)data).getHeight()) {
                        throw new IllegalStateException("Shaped recipe must have ingredient count equal to width * height.");
                    }
                    helper.writeString(out, ((ShapedRecipeData)data).getGroup());
                    helper.writeVarInt(out, ((ShapedRecipeData)data).getCategory().ordinal());
                    helper.writeVarInt(out, ((ShapedRecipeData)data).getWidth());
                    helper.writeVarInt(out, ((ShapedRecipeData)data).getHeight());
                    for (Ingredient ingredient : ((ShapedRecipeData)data).getIngredients()) {
                        helper.writeRecipeIngredient(out, ingredient);
                    }
                    helper.writeItemStack(out, ((ShapedRecipeData)data).getResult());
                    out.writeBoolean(((ShapedRecipeData)data).isShowNotification());
                    continue block8;
                }
                case SMELTING: 
                case BLASTING: 
                case SMOKING: 
                case CAMPFIRE_COOKING: {
                    RecipeData data = (CookedRecipeData)recipe.getData();
                    helper.writeString(out, ((CookedRecipeData)data).getGroup());
                    helper.writeVarInt(out, ((CookedRecipeData)data).getCategory().ordinal());
                    helper.writeRecipeIngredient(out, ((CookedRecipeData)data).getIngredient());
                    helper.writeItemStack(out, ((CookedRecipeData)data).getResult());
                    out.writeFloat(((CookedRecipeData)data).getExperience());
                    helper.writeVarInt(out, ((CookedRecipeData)data).getCookingTime());
                    continue block8;
                }
                case STONECUTTING: {
                    RecipeData data = (StoneCuttingRecipeData)recipe.getData();
                    helper.writeString(out, ((StoneCuttingRecipeData)data).getGroup());
                    helper.writeRecipeIngredient(out, ((StoneCuttingRecipeData)data).getIngredient());
                    helper.writeItemStack(out, ((StoneCuttingRecipeData)data).getResult());
                    continue block8;
                }
                case SMITHING_TRANSFORM: {
                    RecipeData data = (SmithingTransformRecipeData)recipe.getData();
                    helper.writeRecipeIngredient(out, ((SmithingTransformRecipeData)data).getTemplate());
                    helper.writeRecipeIngredient(out, ((SmithingTransformRecipeData)data).getBase());
                    helper.writeRecipeIngredient(out, ((SmithingTransformRecipeData)data).getAddition());
                    helper.writeItemStack(out, ((SmithingTransformRecipeData)data).getResult());
                    continue block8;
                }
                case SMITHING_TRIM: {
                    RecipeData data = (SmithingTrimRecipeData)recipe.getData();
                    helper.writeRecipeIngredient(out, ((SmithingTrimRecipeData)data).getTemplate());
                    helper.writeRecipeIngredient(out, ((SmithingTrimRecipeData)data).getBase());
                    helper.writeRecipeIngredient(out, ((SmithingTrimRecipeData)data).getAddition());
                    continue block8;
                }
                default: {
                    RecipeData data = (SimpleCraftingRecipeData)recipe.getData();
                    helper.writeVarInt(out, ((SimpleCraftingRecipeData)data).getCategory().ordinal());
                    continue block8;
                }
            }
        }
    }

    @NonNull
    public Recipe[] getRecipes() {
        return this.recipes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateRecipesPacket)) {
            return false;
        }
        ClientboundUpdateRecipesPacket other = (ClientboundUpdateRecipesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getRecipes(), other.getRecipes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateRecipesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getRecipes());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateRecipesPacket(recipes=" + Arrays.deepToString(this.getRecipes()) + ")";
    }

    public ClientboundUpdateRecipesPacket withRecipes(@NonNull Recipe[] recipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        return this.recipes == recipes ? this : new ClientboundUpdateRecipesPacket(recipes);
    }

    public ClientboundUpdateRecipesPacket(@NonNull Recipe[] recipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        this.recipes = recipes;
    }
}

