/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk;

import com.github.steveice10.mc.protocol.data.game.chunk.BitStorage;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.GlobalPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.ListPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.MapPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.Palette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.PaletteType;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.SingletonPalette;
import lombok.NonNull;

public class DataPalette {
    @Deprecated(forRemoval=true)
    public static final int GLOBAL_PALETTE_BITS_PER_ENTRY = 14;
    @NonNull
    private Palette palette;
    private BitStorage storage;
    private final PaletteType paletteType;

    @Deprecated(forRemoval=true)
    public DataPalette(@NonNull Palette palette, BitStorage storage, PaletteType paletteType, int globalPaletteBits) {
        this(palette, storage, paletteType);
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
    }

    public DataPalette(DataPalette original) {
        this(original.palette.copy(), original.storage == null ? null : new BitStorage(original.storage), original.paletteType);
    }

    public static DataPalette createForChunk() {
        return DataPalette.createEmpty(PaletteType.CHUNK);
    }

    @Deprecated(forRemoval=true)
    public static DataPalette createForChunk(int globalPaletteBits) {
        return DataPalette.createForChunk();
    }

    @Deprecated(forRemoval=true)
    public static DataPalette createForBiome(int globalPaletteBits) {
        return DataPalette.createForBiome();
    }

    public static DataPalette createForBiome() {
        return DataPalette.createEmpty(PaletteType.BIOME);
    }

    public static DataPalette createEmpty(PaletteType paletteType) {
        return new DataPalette(new ListPalette(paletteType.getMinBitsPerEntry()), new BitStorage(paletteType.getMinBitsPerEntry(), paletteType.getStorageSize()), paletteType);
    }

    @Deprecated(forRemoval=true)
    public static DataPalette createEmpty(PaletteType paletteType, int globalPaletteBits) {
        return DataPalette.createEmpty(paletteType);
    }

    public int get(int x, int y, int z) {
        if (this.storage != null) {
            int id = this.storage.get(this.index(x, y, z));
            return this.palette.idToState(id);
        }
        return this.palette.idToState(0);
    }

    public int set(int x, int y, int z, int state) {
        int id = this.palette.stateToId(state);
        if (id == -1) {
            this.resize();
            id = this.palette.stateToId(state);
        }
        if (this.storage != null) {
            int index = this.index(x, y, z);
            int curr = this.storage.get(index);
            this.storage.set(index, id);
            return curr;
        }
        return state;
    }

    private int sanitizeBitsPerEntry(int bitsPerEntry) {
        if (bitsPerEntry <= this.paletteType.getMaxBitsPerEntry()) {
            return Math.max(this.paletteType.getMinBitsPerEntry(), bitsPerEntry);
        }
        return 14;
    }

    private void resize() {
        Palette oldPalette = this.palette;
        BitStorage oldData = this.storage;
        int bitsPerEntry = this.sanitizeBitsPerEntry(oldPalette instanceof SingletonPalette ? 1 : oldData.getBitsPerEntry() + 1);
        this.palette = DataPalette.createPalette(bitsPerEntry, this.paletteType);
        this.storage = new BitStorage(bitsPerEntry, this.paletteType.getStorageSize());
        if (oldPalette instanceof SingletonPalette) {
            this.palette.stateToId(oldPalette.idToState(0));
        } else {
            for (int i = 0; i < this.paletteType.getStorageSize(); ++i) {
                this.storage.set(i, this.palette.stateToId(oldPalette.idToState(oldData.get(i))));
            }
        }
    }

    private static Palette createPalette(int bitsPerEntry, PaletteType paletteType) {
        if (bitsPerEntry <= paletteType.getMinBitsPerEntry()) {
            return new ListPalette(bitsPerEntry);
        }
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntry()) {
            return new MapPalette(bitsPerEntry);
        }
        return new GlobalPalette();
    }

    private int index(int x, int y, int z) {
        return y << this.paletteType.getMaxBitsPerEntry() | z << this.paletteType.getMinBitsPerEntry() | x;
    }

    @NonNull
    public Palette getPalette() {
        return this.palette;
    }

    public BitStorage getStorage() {
        return this.storage;
    }

    public PaletteType getPaletteType() {
        return this.paletteType;
    }

    public void setPalette(@NonNull Palette palette) {
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
        this.palette = palette;
    }

    public void setStorage(BitStorage storage) {
        this.storage = storage;
    }

    public DataPalette(@NonNull Palette palette, BitStorage storage, PaletteType paletteType) {
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
        this.palette = palette;
        this.storage = storage;
        this.paletteType = paletteType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPalette)) {
            return false;
        }
        DataPalette other = (DataPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Palette this$palette = this.getPalette();
        Palette other$palette = other.getPalette();
        if (this$palette == null ? other$palette != null : !this$palette.equals(other$palette)) {
            return false;
        }
        BitStorage this$storage = this.getStorage();
        BitStorage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        PaletteType this$paletteType = this.getPaletteType();
        PaletteType other$paletteType = other.getPaletteType();
        return !(this$paletteType == null ? other$paletteType != null : !((Object)((Object)this$paletteType)).equals((Object)other$paletteType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPalette;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Palette $palette = this.getPalette();
        result = result * 59 + ($palette == null ? 43 : $palette.hashCode());
        BitStorage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        PaletteType $paletteType = this.getPaletteType();
        result = result * 59 + ($paletteType == null ? 43 : ((Object)((Object)$paletteType)).hashCode());
        return result;
    }

    public String toString() {
        return "DataPalette(palette=" + this.getPalette() + ", storage=" + this.getStorage() + ", paletteType=" + this.getPaletteType() + ")";
    }
}

