/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.level;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerboundMoveVehiclePacket
implements Packet {
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public ServerboundMoveVehiclePacket(NetInput in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
    }

    public void write(NetOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMoveVehiclePacket)) {
            return false;
        }
        ServerboundMoveVehiclePacket other = (ServerboundMoveVehiclePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        return Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundMoveVehiclePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public String toString() {
        return "ServerboundMoveVehiclePacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public ServerboundMoveVehiclePacket withX(double x) {
        return this.x == x ? this : new ServerboundMoveVehiclePacket(x, this.y, this.z, this.yaw, this.pitch);
    }

    public ServerboundMoveVehiclePacket withY(double y) {
        return this.y == y ? this : new ServerboundMoveVehiclePacket(this.x, y, this.z, this.yaw, this.pitch);
    }

    public ServerboundMoveVehiclePacket withZ(double z) {
        return this.z == z ? this : new ServerboundMoveVehiclePacket(this.x, this.y, z, this.yaw, this.pitch);
    }

    public ServerboundMoveVehiclePacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerboundMoveVehiclePacket(this.x, this.y, this.z, yaw, this.pitch);
    }

    public ServerboundMoveVehiclePacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerboundMoveVehiclePacket(this.x, this.y, this.z, this.yaw, pitch);
    }

    public ServerboundMoveVehiclePacket(double x, double y, double z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

